/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.DatabaseConfig;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Configuration
@EnableTransactionManagement
@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u00015\u0011\u0001cU9m\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011AB2p]\u001aLwM\u0003\u0002\u0006\r\u0005!1m\u001c:f\u0015\t9\u0001\"\u0001\u0005eKBdw._5u\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0012\u0001C4sSjTH.\u001a3\n\u0005m1\"a\u0002'pO\u001eLgn\u001a\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005I\u0001\u0010\u001c3D_:4\u0017n\u001a\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011\u0011\u0002\u00177e\u0007>tg-[4\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\t)c\u0005\u0005\u0002 \u0001!)QD\ta\u0001=!)\u0001\u0006\u0001C\u0001S\u0005qQ.Y5o\t\u0006$\u0018mU8ve\u000e,W#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013aA:rY*\tq&A\u0003kCZ\f\u00070\u0003\u00022Y\tQA)\u0019;b'>,(oY3)\t\u001d\u001at\b\u0011\t\u0003iuj\u0011!\u000e\u0006\u0003m]\n!\"\u00198o_R\fG/[8o\u0015\tA\u0014(A\u0004d_:$X\r\u001f;\u000b\u0005iZ\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003q\n1a\u001c:h\u0013\tqTG\u0001\u0003CK\u0006t\u0017!\u00043fgR\u0014x._'fi\"|G-I\u0001B\u0003\u0015\u0019Gn\\:f\u0011\u0015\u0019\u0005\u0001\"\u0001*\u0003M\u0011X\r]8si&tw\rR1uCN{WO]2fQ\u0011\u00115g\u0010!\t\u000b\u0019\u0003A\u0011B$\u0002-%t7\u000f\u001e:v[\u0016tG/\u001a3ECR\f7k\\;sG\u0016$2\u0001\u0013*X!\tI\u0005+D\u0001K\u0015\tYE*\u0001\u0003kI\n\u001c'BA'O\u0003\u001diW\r\u001e:jGNT!a\u0014\u0006\u0002\u000bQ\fH-\u001a<\n\u0005ES%AF%ogR\u0014X/\\3oi\u0016$G)\u0019;b'>,(oY3\t\u000bM+\u0005\u0019\u0001+\u0002\u0011\u0011\fG/\u00192bg\u0016\u0004\"aH+\n\u0005Y\u0013!A\u0004#bi\u0006\u0014\u0017m]3D_:4\u0017n\u001a\u0005\u00061\u0016\u0003\r!W\u0001\u0005]\u0006lW\r\u0005\u0002[C:\u00111l\u0018\t\u00039Bi\u0011!\u0018\u0006\u0003=2\ta\u0001\u0010:p_Rt\u0014B\u00011\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001\u0004\u0002\"B3\u0001\t\u00031\u0017AD7bS:\u001c\u0016\u000f\u001c#jC2,7\r^\u000b\u0002OB\u0011\u0001N[\u0007\u0002S*\u0011Q\u0006B\u0005\u0003W&\u0014!bU9m\t&\fG.Z2uQ\t!7\u0007C\u0003o\u0001\u0011\u0005a-A\nsKB|'\u000f^5oON\u000bH\u000eR5bY\u0016\u001cG\u000f\u000b\u0002ng!)\u0011\u000f\u0001C\u0001e\u0006\u0001R.Y5o\u0015\u0012\u00147\rV3na2\fG/Z\u000b\u0002gB\u0011Ao^\u0007\u0002k*\u0011QA\u001e\u0006\u0003\u0017fJ!\u0001_;\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3)\u0005A\u001c\u0004\"B>\u0001\t\u0003a\u0018AF7bS:$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0016\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u0001s\u0005YAO]1og\u0006\u001cG/[8o\u0013\r\t)a \u0002\u001b!2\fGOZ8s[R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\u0003uNBa!a\u0003\u0001\t\u0003a\u0018a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'\u000fK\u0002\u0002\nMBq!!\u0005\u0001\t\u0003\t\u0019\"\u0001\fj]&$\u0018.\u00197ju\u0016l\u0015-\u001b8ECR\f'-Y:f+\t\t)\u0002E\u0002\u0010\u0003/I1!!\u0007\u0011\u0005\u0011)f.\u001b;)\t\u0005=\u0011Q\u0004\t\u0005\u0003?\t\u0019#\u0004\u0002\u0002\")\u0011aGL\u0005\u0005\u0003K\t\tCA\u0007Q_N$8i\u001c8tiJ,8\r\u001e\u0005\b\u0003S\u0001A\u0011AA\n\u0003mIg.\u001b;jC2L'0\u001a*fa>\u0014H/\u001b8h\t\u0006$\u0018MY1tK\"\"\u0011qEA\u000f\u0011\u001d\ty\u0003\u0001C\u0005\u0003c\tq\"\u001e9eCR,G*[9vS\n\f7/\u001a\u000b\u0007\u0003+\t\u0019$a\u000e\t\u000f\u0005U\u0012Q\u0006a\u00013\u000611o\u00195f[\u0006Dq!!\u000f\u0002.\u0001\u0007!&\u0001\u0006eCR\f7k\\;sG\u0016Dq!!\u0010\u0001\t\u0003\ty$\u0001\u0007iS.\f'/[\"p]\u001aLw\r\u0006\u0004\u0002B\u0005E\u00131\u000b\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0019A\u0017n[1sS*\u0019\u00111\n\u0006\u0002\ri\f\u0007\u0010_3s\u0013\u0011\ty%!\u0012\u0003\u0019!K7.\u0019:j\u0007>tg-[4\t\r\r\tY\u00041\u0001U\u0011\u001d\t)&a\u000fA\u0002e\u000b\u0001\u0002]8pY:\u000bW.\u001a\u0015\u0004\u0001\u0005e\u0003\u0003BA.\u0003?j!!!\u0018\u000b\u0005Yz\u0018\u0002BA1\u0003;\u00121$\u00128bE2,GK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3nK:$\bf\u0001\u0001\u0002fA\u0019A'a\u001a\n\u0007\u0005%TGA\u0007D_:4\u0017nZ;sCRLwN\u001c")
public class SqlConfiguration
implements Logging {
    private final XldConfig xldConfig;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        return this.instrumentedDataSource(this.xldConfig.repository().database(), "MainPool");
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        return this.instrumentedDataSource(this.xldConfig.reporting().database(), "ReportingPool");
    }

    private InstrumentedDataSource instrumentedDataSource(DatabaseConfig database, String name) {
        return new InstrumentedDataSource((DataSource)new HikariDataSource(this.hikariConfig(database, name)), MetricRegistry.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect mainSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected SQL dialect for main: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dialect})));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect reportingSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected SQL dialect for reporting: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dialect})));
        return var1_1;
    }

    @Bean
    public JdbcTemplate mainJdbcTemplate() {
        return new JdbcTemplate(this.mainDataSource());
    }

    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new DataSourceTransactionManager(this.mainDataSource());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/main-schema.yaml", this.mainDataSource());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/reporting-schema.yaml", this.reportingDataSource());
    }

    private void updateLiquibase(String schema, DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new JdbcConnection(connection)).update("");
        }
    }

    /*
     * WARNING - void declaration
     */
    public HikariConfig hikariConfig(DatabaseConfig config, String poolName) {
        void var3_3;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(config.driverClassname());
        hikariConfig.setJdbcUrl(config.url());
        hikariConfig.setUsername(config.username());
        hikariConfig.setPassword(config.password());
        hikariConfig.setMaximumPoolSize(config.maxPoolSize());
        hikariConfig.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        hikariConfig.setPoolName(poolName);
        hikariConfig.setAutoCommit(false);
        hikariConfig.setLeakDetectionThreshold(120000L);
        return var3_3;
    }

    public SqlConfiguration(XldConfig xldConfig) {
        this.xldConfig = xldConfig;
        Logging.$init$((Logging)this);
    }
}

