package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.OidcProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class OidcConfigurationUpgrader extends DeployConfUpgrader {
  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.security")) {
      createYamlConfiguration(confFile, "xl.security", "deploy.security", classOf[OidcProperties])
    }
  }

  override def configurationFileDescription: String = "Oidc Configuration"

  override def destinationFileName: String = "deploy-oidc.yaml"
}
