package com.xebialabs.deployit.core.upgrade.configuration

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.core.upgrade.configuration.common.BaseConfigurationUpgrader
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.deployit.util.PropertyUtil
import org.springframework.beans.factory.annotation.Value

import scala.util.{Failure, Success, Try}

class AkkaHostnamePortConfigurationUpgrader(@Value("${deploy.server.hostname:127.0.0.1}")oldServerHostname: String,
                                            @Value("${deploy.server.port:8180}")oldServerPort: String) extends BaseConfigurationUpgrader{

  override def destinationFileName: String = "deploy-server.yaml"

  override def configurationFileDescription: String = "Server config"

  override def upgradeVersion(): Version = Version.valueOf("central-config", "10.4.0")

  override def doUpgrade(): Boolean = Try {
    updateConfiguration()
  } match {
    case Success(_) =>
      logger.debug(s"Moved 'deploy.server.hostname' and 'deploy.server.port' from $destinationFileName to deployit.conf")
      true
    case Failure(exception: Exception) =>
      logger.debug(s"$destinationFileName configuration cannot be moved: " + exception.getMessage)
      false
    case _ =>
      false
  }

  override protected def updateConfiguration(): Unit = {
    val properties = PropertyUtil.readPropertiesFile(deployitConfFile)
    properties.setProperty(ServerConfiguration.KEY_SERVER_HOSTNAME, oldServerHostname)
    properties.setProperty(ServerConfiguration.KEY_SERVER_PORT, oldServerPort)
    PropertyUtil.storePropertiesFile(deployitConfFile, properties)
    deleteCentralConfigurationProperties(Seq("deploy.server.hostname", "deploy.server.port"))
  }
}
