package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.JmxProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class JmxConfigurationUpgrader extends DeployConfUpgrader {

  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.jmx")) {
      createYamlConfiguration(confFile, "xl.jmx", "deploy.jmx", classOf[JmxProperties])
    }
  }

  override def configurationFileDescription: String = "JMX Configuration"

  override def destinationFileName: String = "deploy-jmx.yaml"
}
