package com.xebialabs.deployit.core.upgrade.configuration

import ai.digital.configuration.central.deploy.SecretComplexityProperties
import com.typesafe.config.Config
import com.xebialabs.deployit.core.upgrade.configuration.common.DeployConfUpgrader

class SecretComplexityConfigurationUpgrader extends DeployConfUpgrader {

  override protected def xlConfigUpdate(confFile: Config): Unit = {
    if (confFile.hasPath("xl.secret-complexity.regex-validations")) {
      createYamlConfiguration(confFile, "xl.secret-complexity", "deploy.secret-complexity", classOf[SecretComplexityProperties])
    }
  }

  override protected def getYamlFileNamesToMove: List[String] = List("xld-secret-complexity.yaml")

  override def configurationFileDescription: String = "Secret complexity"

  override def destinationFileName: String = "deploy-secret-complexity.yaml"
}
