/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportAbstract;
import org.apache.derby.impl.load.ExportWriteData;
import org.apache.derby.impl.load.ExportWriteDataAbstract;
import org.apache.derby.impl.load.LoadError;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

public class Export
extends ExportAbstract {
    private String outputFileName;
    private String lobsFileName;

    private void doExport() throws SQLException {
        try {
            if (this.entityName == null && this.selectStatement == null) {
                throw LoadError.entityNameMissing();
            }
            if (this.outputFileName == null) {
                throw LoadError.dataFileNull();
            }
            if (this.dataFileExists(this.outputFileName)) {
                throw LoadError.dataFileExists(this.outputFileName);
            }
            if (this.lobsFileName != null && this.lobsFileExists(this.lobsFileName)) {
                throw LoadError.lobsFileExists(this.lobsFileName);
            }
            try {
                this.doAllTheWork();
            }
            catch (IOException iOException) {
                throw LoadError.errorWritingData(iOException);
            }
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    private Export(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        this.con = connection;
        this.schemaName = string;
        this.entityName = string2;
        this.selectStatement = string3;
        this.outputFileName = string4;
        try {
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string5, string6, string7);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    private void setLobsExtFileName(String string) throws SQLException {
        if (string == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S", new Object[0]));
        }
        this.lobsFileName = string;
        this.lobsInExtFile = true;
    }

    private boolean lobsFileExists(String string) throws SQLException {
        if (string == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S", new Object[0]));
        }
        string = FileUtil.stripProtocolFromFileName(string);
        File file = new File(string);
        return this.fileExists(file);
    }

    private boolean dataFileExists(String string) throws SQLException {
        if (string == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE05.S", new Object[0]));
        }
        string = FileUtil.stripProtocolFromFileName(string);
        File file = new File(string);
        return this.fileExists(file);
    }

    private final boolean fileExists(File file) {
        return file.exists();
    }

    public static void exportTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        try {
            SecurityUtil.authorize(Securable.EXPORT_TABLE);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        Export export = new Export(connection, string, string2, null, string3, string5, string4, string6);
        export.doExport();
    }

    public static void exportTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Export export = new Export(connection, string, string2, null, string3, string5, string4, string6);
        export.setLobsExtFileName(string7);
        export.doExport();
    }

    public static void exportQuery(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        Export export = new Export(connection, null, null, string, string2, string4, string3, string5);
        export.doExport();
    }

    public static void exportQuery(Connection connection, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Export export = new Export(connection, null, null, string, string2, string4, string3, string5);
        export.setLobsExtFileName(string6);
        export.doExport();
    }

    @Override
    protected ExportWriteDataAbstract getExportWriteData() throws Exception {
        if (this.lobsInExtFile) {
            return new ExportWriteData(this.outputFileName, this.lobsFileName, this.controlFileReader);
        }
        return new ExportWriteData(this.outputFileName, this.controlFileReader);
    }
}

