/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.config;

import java.security.AccessController;
import java.util.function.Supplier;

class WrappedAction {
    WrappedAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R> R execute(Supplier<R> action, ClassLoader cl) {
        if (cl == null) {
            return action.get();
        }
        ClassLoader current = WrappedAction.getTccl();
        try {
            WrappedAction.setTccl(cl);
            R r = action.get();
            return r;
        }
        finally {
            WrappedAction.setTccl(current);
        }
    }

    static void execute(Runnable action, ClassLoader cl) {
        if (cl == null) {
            action.run();
        } else {
            ClassLoader current = WrappedAction.getTccl();
            try {
                WrappedAction.setTccl(cl);
                action.run();
            }
            finally {
                WrappedAction.setTccl(current);
            }
        }
    }

    private static ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    private static void setTccl(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            });
        }
    }
}

