/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.util.HeadingCollectingVisitor;
import com.vladsch.flexmark.ext.toc.SimTocBlock;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.TocUtils;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocFormatOptions;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.misc.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimTocNodeFormatter
implements NodeFormatter {
    private final TocOptions options;
    private final TocFormatOptions formatOptions;
    private MarkdownTable myTable;

    public SimTocNodeFormatter(DataHolder options) {
        this.options = new TocOptions(options, true);
        this.formatOptions = new TocFormatOptions(options);
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(SimTocBlock.class, this::render), new NodeFormattingHandler(SimTocContent.class, this::render)));
    }

    private void render(SimTocBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        switch (this.formatOptions.updateOnFormat) {
            case REMOVE: {
                String simTocPrefix = TocUtils.getSimTocPrefix(this.options, this.options);
                markdown.append((CharSequence)simTocPrefix);
                if (!this.options.isBlankLineSpacer) break;
                markdown.blankLine();
                break;
            }
            case UPDATE: {
                HeadingCollectingVisitor visitor = new HeadingCollectingVisitor();
                ArrayList headings = visitor.collectAndGetHeadings((Node)context.getDocument());
                if (headings == null) break;
                SimTocOptionsParser optionsParser = new SimTocOptionsParser();
                TocOptions options = (TocOptions)optionsParser.parseOption(node.getStyle(), this.options, null).getFirst();
                if (node.getTitle().isNotNull()) {
                    options = options.withTitle(node.getTitle().unescape());
                }
                String simTocPrefix = TocUtils.getSimTocPrefix(options, this.options);
                markdown.append((CharSequence)simTocPrefix);
                if (options.isBlankLineSpacer) {
                    markdown.blankLine();
                }
                this.renderTocHeaders(markdown, headings, options);
                break;
            }
            case AS_IS: {
                ((MarkdownWriter)((MarkdownWriter)markdown.openPreFormatted(false)).append((CharSequence)node.getChars())).closePreFormatted();
                break;
            }
            default: {
                throw new IllegalStateException(this.formatOptions.updateOnFormat.toString() + " is not implemented");
            }
        }
    }

    private void renderTocHeaders(MarkdownWriter markdown, List<Heading> headings, TocOptions options) {
        List<Heading> filteredHeadings = TocUtils.filteredHeadings(headings, options);
        Pair<List<Heading>, List<String>> paired = TocUtils.markdownHeaderTexts(filteredHeadings, options);
        TocUtils.renderTocContent(markdown, options, this.options, (List)paired.getFirst(), (List)paired.getSecond());
    }

    private void render(SimTocContent node, NodeFormatterContext context, MarkdownWriter markdown) {
    }

    public static class Factory
    implements NodeFormatterFactory {
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new SimTocNodeFormatter(options);
        }
    }
}

