/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.web.access.AuthorizationManagerWebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public class HandlerMappingIntrospectorRequestTransformer
implements AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer {
    private final HandlerMappingIntrospector introspector;

    public HandlerMappingIntrospectorRequestTransformer(HandlerMappingIntrospector introspector) {
        Assert.notNull((Object)introspector, (String)"introspector canot be null");
        this.introspector = introspector;
    }

    @Override
    public HttpServletRequest transform(HttpServletRequest request) {
        CacheableRequestWrapper cacheableRequest = new CacheableRequestWrapper(request);
        this.introspector.setCache((HttpServletRequest)cacheableRequest);
        return cacheableRequest;
    }

    static final class CacheableRequestWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        CacheableRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.REQUEST;
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.attributes.keySet());
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void setAttribute(String name, Object o) {
            this.attributes.put(name, o);
        }

        public void removeAttribute(String name) {
            this.attributes.remove(name);
        }
    }
}

