/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ui;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.web.authentication.ui.HtmlTemplates;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public final class DefaultOneTimeTokenSubmitPageGeneratingFilter
extends OncePerRequestFilter {
    private RequestMatcher requestMatcher = new AntPathRequestMatcher("/login/ott", "GET");
    private Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs = request -> Collections.emptyMap();
    private String loginProcessingUrl = "/login/ott";
    private static final String ONE_TIME_TOKEN_SUBMIT_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <title>One-Time Token Login</title>\n    <meta charset=\"utf-8\"/>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\"/>\n    <link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />\n  </head>\n  <body>\n    <div class=\"container\">\n      <form class=\"login-form\" action=\"{{loginProcessingUrl}}\" method=\"post\">\n        <h2>Please input the token</h2>\n        <p>\n          <label for=\"token\" class=\"screenreader\">Token</label>\n          <input type=\"text\" id=\"token\" name=\"token\" value=\"{{tokenValue}}\" placeholder=\"Token\" required=\"true\" autofocus=\"autofocus\"/>\n        </p>\n        <button class=\"primary\" type=\"submit\">Sign in</button>\n{{hiddenInputs}}\n      </form>\n    </div>\n  </body>\n</html>\n";
    private static final String HIDDEN_HTML_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String html = this.generateHtml(request);
        response.setContentType("text/html;charset=UTF-8");
        response.setContentLength(html.getBytes(StandardCharsets.UTF_8).length);
        response.getWriter().write(html);
    }

    private String generateHtml(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String token = request.getParameter("token");
        String tokenValue = StringUtils.hasText((String)token) ? token : "";
        String hiddenInputs = this.resolveHiddenInputs.apply(request).entrySet().stream().map(inputKeyValue -> this.renderHiddenInput((String)inputKeyValue.getKey(), (String)inputKeyValue.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(ONE_TIME_TOKEN_SUBMIT_PAGE_TEMPLATE).withValue("contextPath", contextPath).withValue("tokenValue", tokenValue).withValue("loginProcessingUrl", contextPath + this.loginProcessingUrl).withRawHtml("hiddenInputs", hiddenInputs).render();
    }

    private String renderHiddenInput(String name, String value) {
        return HtmlTemplates.fromTemplate(HIDDEN_HTML_INPUT_TEMPLATE).withValue("name", name).withValue("value", value).render();
    }

    public void setResolveHiddenInputs(Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs) {
        Assert.notNull(resolveHiddenInputs, (String)"resolveHiddenInputs cannot be null");
        this.resolveHiddenInputs = resolveHiddenInputs;
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.requestMatcher = requestMatcher;
    }

    public void setLoginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be null or empty");
        this.loginProcessingUrl = loginProcessingUrl;
    }
}

