/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.gcp.GcpKeyManager;
import com.xebialabs.overthere.gcp.GcpKeyManagerFactory;
import com.xebialabs.overthere.gcp.GcpMetadataKeyManager;
import com.xebialabs.overthere.gcp.GcpOsLoginKeyManager;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;

public enum GcpKeyManagementType {
    OsLogin{

        @Override
        GcpKeyManager createGcpKeyManager(ConnectionOptions options, GcpCredentialFactory gcpCredentialFactory) {
            return new GcpOsLoginKeyManager(GcpKeyManagerFactory.GENERATE_SSH_KEY, gcpCredentialFactory).init();
        }
    }
    ,
    Metadata{

        @Override
        GcpKeyManager createGcpKeyManager(ConnectionOptions options, GcpCredentialFactory gcpCredentialFactory) {
            String zoneName = (String)options.get("zoneName");
            String instanceId = (String)options.getOptional("instanceId");
            String username = (String)options.get("username");
            String applicationName = (String)options.getOptional("applicationName");
            return new GcpMetadataKeyManager(GcpKeyManagerFactory.GENERATE_SSH_KEY, gcpCredentialFactory, zoneName, instanceId, username, applicationName).init();
        }
    };


    abstract GcpKeyManager createGcpKeyManager(ConnectionOptions var1, GcpCredentialFactory var2);

    public static GcpKeyManager resolveGcpKeyManager(ConnectionOptions options, GcpCredentialFactory gcpCredentialFactory) {
        GcpKeyManagementType gcpKeyManagementType = options.getEnum("gcpKeyManagementType", GcpKeyManagementType.class);
        return gcpKeyManagementType.createGcpKeyManager(options, gcpCredentialFactory);
    }
}

