/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.client;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.client.PoolFlow;
import org.apache.pekko.http.impl.engine.client.PoolId;
import org.apache.pekko.http.impl.engine.client.PoolInterface$;
import org.apache.pekko.http.impl.engine.client.PoolInterface$ShutdownReason$IdleTimeout$;
import org.apache.pekko.http.impl.engine.client.PoolInterface$ShutdownReason$ShutdownRequested$;
import org.apache.pekko.http.impl.engine.client.PoolMaster;
import org.apache.pekko.http.impl.settings.HostConnectionPoolSetup;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.impl.util.StreamUtils$CaptureTerminationOp$;
import org.apache.pekko.http.impl.util.package$RichHttpRequest$;
import org.apache.pekko.http.javadsl.ConnectionContext;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.OptHttpResponse$;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.macros.LogHelper;
import org.apache.pekko.macros.LogHelperMacro;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BufferOverflowException;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogic;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011-b\u0001\u00034h!\u0003\r\n!\\;\t\u000bq\u0004a\u0011\u0001@\t\u000f\u00055\u0002A\"\u0001\u00020!91\u0011\u001c\u0001\u0007\u0002\u0011%r\u0001CA O\"\u0005Q.!\u0011\u0007\u000f\u0019<\u0007\u0012A7\u0002D!9\u0011QI\u0003\u0005\u0002\u0005\u001dcACA%\u000bA\u0005\u0019\u0013E7\u0002L\u001dA\u0011q^\u0003\t\u00025\f)F\u0002\u0005\u0002J\u0015A\t!\\A)\u0011\u001d\t)%\u0003C\u0001\u0003':q!!\u0017\n\u0011\u0003\u000bYFB\u0004\u0002`%A\t)!\u0019\t\u000f\u0005\u0015C\u0002\"\u0001\u0002\u0004\"I\u0011Q\u0011\u0007\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u00033c\u0011\u0011!C\u0001\u00037C\u0011\"a)\r\u0003\u0003%\t!!*\t\u0013\u0005EF\"!A\u0005B\u0005M\u0006\"CAa\u0019\u0005\u0005I\u0011AAb\u0011%\ti\rDA\u0001\n\u0003\ny\rC\u0005\u0002R2\t\t\u0011\"\u0011\u0002T\"I\u0011Q\u001b\u0007\u0002\u0002\u0013%\u0011q[\u0004\b\u0003?L\u0001\u0012QAq\r\u001d\ty%\u0003EA\u0003GDq!!\u0012\u0018\t\u0003\t)\u000fC\u0005\u0002\u0006^\t\t\u0011\"\u0011\u0002\b\"I\u0011\u0011T\f\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003G;\u0012\u0011!C\u0001\u0003OD\u0011\"!-\u0018\u0003\u0003%\t%a-\t\u0013\u0005\u0005w#!A\u0005\u0002\u0005-\b\"CAg/\u0005\u0005I\u0011IAh\u0011%\t\tnFA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002V^\t\t\u0011\"\u0003\u0002X\"9\u0011\u0011_\u0003\u0005\u0002\u0005M\b\"CAp\u000b\t\u0007I\u0011BAD\u0011!\u0011i#\u0002Q\u0001\n\u0005%eA\u0002B\u0018\u000b\u0001\u0011\t\u0004\u0003\u0006\u0003\f\u0011\u0012\t\u0011)A\u0005\u0005\u001bA!B!\n%\u0005\u0003\u0005\u000b\u0011\u0002B\u0014\u0011)\u0011y\u0007\nB\u0001B\u0003%\u0011Q\u0014\u0005\u000b\u0005c\"#\u0011!Q\u0001\n\tM\u0004bBA#I\u0011\u0005!q\u0010\u0005\n\u0005\u0017##\u0019!C\u0005\u0005\u001bC\u0001B!&%A\u0003%!q\u0012\u0005\n\u0005/##\u0019!C\u0005\u00053C\u0001B!)%A\u0003%!1\u0014\u0005\b\u0005G#C\u0011\tBS\u0011\u001d\u00119\u000b\nC!\u0005SCqAa*%\t\u0003\u0012\tM\u0002\u0004\u0003J\u0016!!1\u001a\u0005\u000b\u0005\u0017\t$\u0011!Q\u0001\n\t5\u0001B\u0003BRc\t\u0005\t\u0015!\u0003\u0003@!Q!QE\u0019\u0003\u0002\u0003\u0006IAa\n\t\u0015\t-\u0015G!A!\u0002\u0013\u0011y\t\u0003\u0006\u0003\u0018F\u0012\t\u0011)A\u0005\u00057C!Ba\u001c2\u0005\u0003\u0005\u000b\u0011BAO\u0011)\u0011\t(\rBC\u0002\u0013\u0005!1\u001e\u0005\u000b\u0005[\f$\u0011!Q\u0001\n\tM\u0004B\u0003Bxc\t\u0005\t\u0015a\u0003\u0003r\"9\u0011QI\u0019\u0005\u0002\t]\b\u0002CB\u0007c\u0001\u0006Iaa\u0004\t\u0013\rU\u0011G1A\u0005\u0002\r]\u0001\u0002CB\u0013c\u0001\u0006Ia!\u0007\t\u0013\r\u001d\u0012G1A\u0005\u0002\r%\u0002\u0002CB\u001cc\u0001\u0006Iaa\u000b\t\u0013\re\u0012G1A\u0005\u0002\rm\u0002\u0002CB c\u0001\u0006Ia!\u0010\t\u000f\r\u0005\u0013\u0007\"\u0001\u0004D!I1QI\u0019A\u0002\u0013\u00051q\t\u0005\n\u0007\u001f\n\u0004\u0019!C\u0001\u0007#B\u0001b!\u00162A\u0003&1\u0011\n\u0005\n\u0007/\n\u0004\u0019!C\u0001\u00037C\u0011b!\u00172\u0001\u0004%\taa\u0017\t\u0011\r}\u0013\u0007)Q\u0005\u0003;C\u0011b!\u00192\u0005\u0004%\taa\u0019\t\u0011\rE\u0014\u0007)A\u0005\u0007KBqaa\u001d2\t\u0003\u001a)\bC\u0004\u0004xE\"\tf!\u001f\t\u000f\r}\u0014\u0007\"\u0011\u0004v!91\u0011Q\u0019\u0005B\rU\u0004\"CBBc\t\u0007I\u0011ABC\u0011!\u0019)*\rQ\u0001\n\r\u001d\u0005\"CBLc\t\u0007I\u0011ABM\u0011!\u0019y*\rQ\u0001\n\rm\u0005\"CBQc\t\u0007I\u0011ABR\u0011!\u00199+\rQ\u0001\n\r\u0015\u0006bBBUc\u0011\u00051Q\u000f\u0005\b\u0007W\u000bD\u0011ABW\u0011\u001d\u0019\u0019,\rC\u0001\u0007kBqa!.2\t\u0003\u0019)\bC\u0004\u00048F\"\taa\u0011\t\u000f\re\u0016\u0007\"\u0011\u0004<\"91qY\u0019\u0005B\rU\u0004B\u0002?2\t\u0003\u001aI\rC\u0004\u0002.E\"\tea4\t\u000f\re\u0017\u0007\"\u0011\u0004\\\"91Q\\\u0019\u0005\u0002\r}\u0007bBByc\u0011\u000511\u001f\u0005\b\u0007s\fD\u0011AB~\u0011\u001d!y!\rC\u0001\t#A!\u0002b\u0007\u0006\u0005\u0004%\t!\u001cC\u000f\u0011!!)#\u0002Q\u0001\n\u0011}!!\u0004)p_2Le\u000e^3sM\u0006\u001cWM\u0003\u0002iS\u000611\r\\5f]RT!A[6\u0002\r\u0015tw-\u001b8f\u0015\taW.\u0001\u0003j[Bd'B\u00018p\u0003\u0011AG\u000f\u001e9\u000b\u0005A\f\u0018!\u00029fW.|'B\u0001:t\u0003\u0019\t\u0007/Y2iK*\tA/A\u0002pe\u001e\u001c\"\u0001\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0003e\fQa]2bY\u0006L!a\u001f=\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0011X-];fgR\u001c\u0001\u0001F\u0003\u0000\u0003\u000b\t9\u0002E\u0002x\u0003\u0003I1!a\u0001y\u0005\u0011)f.\u001b;\t\rq\f\u0001\u0019AA\u0004!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tQ!\\8eK2T1!!\u0005n\u0003!\u00198-\u00197bINd\u0017\u0002BA\u000b\u0003\u0017\u00111\u0002\u0013;uaJ+\u0017/^3ti\"9\u0011\u0011D\u0001A\u0002\u0005m\u0011a\u0004:fgB|gn]3Qe>l\u0017n]3\u0011\r\u0005u\u00111EA\u0014\u001b\t\tyBC\u0002\u0002\"a\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\t)#a\b\u0003\u000fA\u0013x.\\5tKB!\u0011\u0011BA\u0015\u0013\u0011\tY#a\u0003\u0003\u0019!#H\u000f\u001d*fgB|gn]3\u0002\u0011MDW\u000f\u001e3po:$\"!!\r\u0015\t\u0005MBq\u0005\t\u0007\u0003;\t)$!\u000f\n\t\u0005]\u0012q\u0004\u0002\u0007\rV$XO]3\u0011\u0007\u0005mrAD\u0002\u0002>\u0011i\u0011aZ\u0001\u000e!>|G.\u00138uKJ4\u0017mY3\u0011\u0007\u0005uRa\u0005\u0002\u0006m\u00061A(\u001b8jiz\"\"!!\u0011\u0003\u001dMCW\u000f\u001e3po:\u0014V-Y:p]N\u0011qA^\u0015\u0004\u000f]a!aC%eY\u0016$\u0016.\\3pkR\u001c\"!\u0003<\u0015\u0005\u0005U\u0003cAA,\u00135\tQ!A\tTQV$Hm\\<o%\u0016\fX/Z:uK\u0012\u00042!!\u0018\r\u001b\u0005I!!E*ikR$wn\u001e8SKF,Xm\u001d;fINAAB^A2\u0003K\nY\u0007E\u0002\u0002X\u001d\u00012a^A4\u0013\r\tI\u0007\u001f\u0002\b!J|G-^2u!\u0011\ti'! \u000f\t\u0005=\u0014\u0011\u0010\b\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011QO?\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0018bAA>q\u00069\u0001/Y2lC\u001e,\u0017\u0002BA@\u0003\u0003\u0013AbU3sS\u0006d\u0017N_1cY\u0016T1!a\u001fy)\t\tY&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*\u0001\u0003mC:<'BAAJ\u0003\u0011Q\u0017M^1\n\t\u0005]\u0015Q\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0005cA<\u0002 &\u0019\u0011\u0011\u0015=\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0016Q\u0016\t\u0004o\u0006%\u0016bAAVq\n\u0019\u0011I\\=\t\u0013\u0005=\u0006#!AA\u0002\u0005u\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00026B1\u0011qWA_\u0003Ok!!!/\u000b\u0007\u0005m\u00060\u0001\u0006d_2dWm\u0019;j_:LA!a0\u0002:\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)-a3\u0011\u0007]\f9-C\u0002\u0002Jb\u0014qAQ8pY\u0016\fg\u000eC\u0005\u00020J\t\t\u00111\u0001\u0002(\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u001e\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\n\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u001c\t\u0005\u0003\u0017\u000bY.\u0003\u0003\u0002^\u00065%AB(cU\u0016\u001cG/A\u0006JI2,G+[7f_V$\bcAA//MAqC^A2\u0003K\nY\u0007\u0006\u0002\u0002bR!\u0011qUAu\u0011%\tykGA\u0001\u0002\u0004\ti\n\u0006\u0003\u0002F\u00065\b\"CAX;\u0005\u0005\t\u0019AAT\u00039\u0019\u0006.\u001e;e_^t'+Z1t_:\fQ!\u00199qYf$\u0002\"!>\u0003\n\tM!1\u0005\u000b\u0005\u0003o\fI\u0010E\u0002\u0002>\u0001Aq!a?\"\u0001\b\ti0\u0001\u0002g[B!\u0011q B\u0003\u001b\t\u0011\tAC\u0002\u0003\u0004=\faa\u001d;sK\u0006l\u0017\u0002\u0002B\u0004\u0005\u0003\u0011A\"T1uKJL\u0017\r\\5{KJDqAa\u0003\"\u0001\u0004\u0011i!\u0001\u0004q_>d\u0017\n\u001a\t\u0005\u0003{\u0011y!C\u0002\u0003\u0012\u001d\u0014a\u0001U8pY&#\u0007b\u0002B\u000bC\u0001\u0007!qC\u0001\u0007a\u0006\u0014XM\u001c;\u0011\t\te!qD\u0007\u0003\u00057Q1A!\bp\u0003\u0015\t7\r^8s\u0013\u0011\u0011\tCa\u0007\u0003\u001f\u0005\u001bGo\u001c:SK\u001a4\u0015m\u0019;pefDqA!\n\"\u0001\u0004\u00119#\u0001\u0004nCN$XM\u001d\t\u0005\u0003{\u0011I#C\u0002\u0003,\u001d\u0014!\u0002U8pY6\u000b7\u000f^3s\u00031IE\r\\3US6,w.\u001e;!\u0005I\u0001vn\u001c7J]R,'OZ1dKN#\u0018mZ3\u0014\u0007\u0011\u0012\u0019\u0004\u0005\u0005\u00036\tm\"qHA|\u001b\t\u00119D\u0003\u0003\u0003:\t\u0005\u0011!B:uC\u001e,\u0017\u0002\u0002B\u001f\u0005o\u0011qd\u0012:ba\"\u001cF/Y4f/&$\b.T1uKJL\u0017\r\\5{K\u00124\u0016\r\\;f!!\tyP!\u0011\u0003F\t%\u0014\u0002\u0002B\"\u0005\u0003\u0011\u0011B\u00127poNC\u0017\r]3\u0011\t\t\u001d#1\r\b\u0005\u0005\u0013\u0012yF\u0004\u0003\u0003L\tuc\u0002\u0002B'\u00057rAAa\u0014\u0003Z9!!\u0011\u000bB,\u001d\u0011\u0011\u0019F!\u0016\u000e\u0003EL!\u0001]9\n\u00059|\u0017B\u00017n\u0013\tQ7.\u0003\u0002iS&\u0019!\u0011M4\u0002\u0011A{w\u000e\u001c$m_^LAA!\u001a\u0003h\ty!+Z:q_:\u001cXmQ8oi\u0016DHOC\u0002\u0003b\u001d\u0004BAa\u0012\u0003l%!!Q\u000eB4\u00059\u0011V-];fgR\u001cuN\u001c;fqR\f!BY;gM\u0016\u00148+\u001b>f\u0003\rawn\u001a\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)\u0019!\u0011P8\u0002\u000b\u00154XM\u001c;\n\t\tu$q\u000f\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s))\u0011\tIa!\u0003\u0006\n\u001d%\u0011\u0012\t\u0004\u0003/\"\u0003b\u0002B\u0006S\u0001\u0007!Q\u0002\u0005\b\u0005KI\u0003\u0019\u0001B\u0014\u0011\u001d\u0011y'\u000ba\u0001\u0003;CqA!\u001d*\u0001\u0004\u0011\u0019(\u0001\u0006sKF,Xm\u001d;PkR,\"Aa$\u0011\r\u0005}(\u0011\u0013B5\u0013\u0011\u0011\u0019J!\u0001\u0003\r=+H\u000f\\3u\u0003-\u0011X-];fgR|U\u000f\u001e\u0011\u0002\u0015I,7\u000f]8og\u0016Le.\u0006\u0002\u0003\u001cB1\u0011q BO\u0005\u000bJAAa(\u0003\u0002\t)\u0011J\u001c7fi\u0006Y!/Z:q_:\u001cX-\u00138!\u0003\u0015\u0019\b.\u00199f+\t\u0011y$A\u0010de\u0016\fG/\u001a'pO&\u001c\u0017I\u001c3NCR,'/[1mSj,GMV1mk\u0016$BAa+\u00038B9qO!,\u00032\u0006]\u0018b\u0001BXq\n1A+\u001e9mKJ\u0002BA!\u000e\u00034&!!Q\u0017B\u001c\u0005=9%/\u00199i'R\fw-\u001a'pO&\u001c\u0007b\u0002B]_\u0001\u0007!1X\u0001\u0014S:DWM]5uK\u0012\fE\u000f\u001e:jEV$Xm\u001d\t\u0005\u0003\u007f\u0014i,\u0003\u0003\u0003@\n\u0005!AC!uiJL'-\u001e;fgR1!1\u0016Bb\u0005\u000bDqA!/1\u0001\u0004\u0011Y\fC\u0004\u0003HB\u0002\r!!@\u0002\u001b}k\u0017\r^3sS\u0006d\u0017N_3s\u0005\u0015aunZ5d'-\t$QZA|\u0005'\u0014INa8\u0011\t\tU\"qZ\u0005\u0005\u0005#\u00149D\u0001\u000bUS6,'o\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\t\u0005\u0005k\u0011).\u0003\u0003\u0003X\n]\"!C%o\u0011\u0006tG\r\\3s!\u0011\u0011)Da7\n\t\tu'q\u0007\u0002\u000b\u001fV$\b*\u00198eY\u0016\u0014\b\u0003\u0002Bq\u0005Ol!Aa9\u000b\u0007\t\u0015x.\u0001\u0004nC\u000e\u0014xn]\u0005\u0005\u0005S\u0014\u0019OA\u0005M_\u001eDU\r\u001c9feV\u0011!1O\u0001\u0005Y><\u0007%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!\u0011Q\u0004Bz\u0013\u0011\u0011)0a\b\u0003!\u0015CXmY;uS>t7i\u001c8uKb$H\u0003\u0005B}\u0005\u007f\u001c\taa\u0001\u0004\u0006\r\u001d1\u0011BB\u0006)\u0011\u0011YP!@\u0011\u0007\u0005]\u0013\u0007C\u0004\u0003pn\u0002\u001dA!=\t\u000f\t-1\b1\u0001\u0003\u000e!9!1U\u001eA\u0002\t}\u0002b\u0002B\u0013w\u0001\u0007!q\u0005\u0005\b\u0005\u0017[\u0004\u0019\u0001BH\u0011\u001d\u00119j\u000fa\u0001\u00057CqAa\u001c<\u0001\u0004\ti\nC\u0004\u0003rm\u0002\rAa\u001d\u0002+A{w\u000e\\(wKJ4Gn\\<Fq\u000e,\u0007\u000f^5p]B!\u0011q`B\t\u0013\u0011\u0019\u0019B!\u0001\u0003/\t+hMZ3s\u001fZ,'O\u001a7po\u0016C8-\u001a9uS>t\u0017\u0001\u00025daN,\"a!\u0007\u0011\t\rm1\u0011E\u0007\u0003\u0007;Q1aa\bl\u0003!\u0019X\r\u001e;j]\u001e\u001c\u0018\u0002BB\u0012\u0007;\u0011q\u0003S8ti\u000e{gN\\3di&|g\u000eU8pYN+G/\u001e9\u0002\u000b!\u001c\u0007o\u001d\u0011\u0002\u0017%$G.\u001a+j[\u0016|W\u000f^\u000b\u0003\u0007W\u0001Ba!\f\u000445\u00111q\u0006\u0006\u0005\u0007c\ty\"\u0001\u0005ekJ\fG/[8o\u0013\u0011\u0019)da\f\u0003\u0011\u0011+(/\u0019;j_:\fA\"\u001b3mKRKW.Z8vi\u0002\nqb\u001d5vi\u0012|wO\u001c)s_6L7/Z\u000b\u0003\u0007{\u0001b!!\b\u0002$\u0005\r\u0014\u0001E:ikR$wn\u001e8Qe>l\u0017n]3!\u00031\u0019\b.\u001e;uS:<Gi\\<o+\t\t)-\u0001\ntQV$H/\u001b8h\t><hNU3bg>tWCAB%!\u0015981JA2\u0013\r\u0019i\u0005\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0002-MDW\u000f\u001e;j]\u001e$un\u001e8SK\u0006\u001cxN\\0%KF$2a`B*\u0011%\ty+RA\u0001\u0002\u0004\u0019I%A\ntQV$H/\u001b8h\t><hNU3bg>t\u0007%\u0001\nsK6\f\u0017N\\5oOJ+\u0017/^3ti\u0016$\u0017A\u0006:f[\u0006Lg.\u001b8h%\u0016\fX/Z:uK\u0012|F%Z9\u0015\u0007}\u001ci\u0006C\u0005\u00020\"\u000b\t\u00111\u0001\u0002\u001e\u0006\u0019\"/Z7bS:Lgn\u001a*fcV,7\u000f^3eA\u00051!-\u001e4gKJ,\"a!\u001a\u0011\r\r\u001d4Q\u000eB5\u001b\t\u0019IG\u0003\u0003\u0004l\u0005E\u0015\u0001B;uS2LAaa\u001c\u0004j\tQ\u0011I\u001d:bs\u0012+\u0017/^3\u0002\u000f\t,hMZ3sA\u0005A\u0001O]3Ti\u0006\u0014H\u000fF\u0001\u0000\u0003\u001dyg\u000eV5nKJ$2a`B>\u0011\u001d\u0019i(\u0014a\u0001\u0003O\u000b\u0001\u0002^5nKJ\\U-_\u0001\u0007_:\u0004Vo\u001d5\u0002\r=t\u0007+\u001e7m\u0003e\u0011Xm\u001d9p]N,7i\\7qY\u0016$X\rZ\"bY2\u0014\u0017mY6\u0016\u0005\r\u001d\u0005C\u0002B\u001b\u0007\u0013\u001bi)\u0003\u0003\u0004\f\n]\"!D!ts:\u001c7)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0004\u0010\u000eEU\"A8\n\u0007\rMuN\u0001\u0003E_:,\u0017A\u0007:fgB|gn]3D_6\u0004H.\u001a;fI\u000e\u000bG\u000e\u001c2bG.\u0004\u0013a\u0004:fcV,7\u000f^\"bY2\u0014\u0017mY6\u0016\u0005\rm\u0005C\u0002B\u001b\u0007\u0013\u001bi\nE\u0004x\u0005[\u000b9!a\u0007\u0002!I,\u0017/^3ti\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001E:ikR$wn\u001e8DC2d'-Y2l+\t\u0019)\u000bE\u0003\u00036\r%u0A\ttQV$Hm\\<o\u0007\u0006dGNY1dW\u0002\nA#\u00194uKJ\u0014V-];fgR4\u0015N\\5tQ\u0016$\u0017a\u0004:fcV,7\u000f^*ikR$wn\u001e8\u0015\u0007}\u001cy\u000bC\u0004\u00042^\u0003\r!a\u0019\u0002\rI,\u0017m]8o\u0003y\u0019\b.\u001e;e_^t\u0017J\u001a*fcV,7\u000f^3e\u0003:$\u0007k\\:tS\ndW-\u0001\bsKN,G/\u00133mKRKW.\u001a:\u0002!MDw.\u001e7e'R|\u0007o\u00148JI2,\u0017!E8o+B\u001cHO]3b[\u001a\u000b\u0017\u000e\\;sKR\u0019qp!0\t\u000f\r}6\f1\u0001\u0004B\u0006\u0011Q\r\u001f\t\u0005\u0003[\u001a\u0019-\u0003\u0003\u0004F\u0006\u0005%!\u0003+ie><\u0018M\u00197f\u0003!\u0001xn\u001d;Ti>\u0004H#B@\u0004L\u000e5\u0007B\u0002?^\u0001\u0004\t9\u0001C\u0004\u0002\u001au\u0003\r!a\u0007\u0015\u0005\rEG\u0003BBj\u0007+\u0004b!!\b\u00026\u0005\r\u0004bBBl=\u0002\u000f!\u0011_\u0001\u0003K\u000e\fAb\u001e5f]NCW\u000f\u001e3po:,\"aa5\u0002\r=t\u0017J\\5u)\ry8\u0011\u001d\u0005\b\u0005\u0017\u0001\u0007\u0019\u0001B\u0007Q\r\u00017Q\u001d\t\u0005\u0007O\u001ci/\u0004\u0002\u0004j*\u001911^8\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004p\u000e%(!E%oi\u0016\u0014h.\u00197Ti\u0006\u0014G.Z!qS\u0006QqN\u001c#jgB\fGo\u00195\u0015\t\u0005\u001d1Q\u001f\u0005\u0007y\u0006\u0004\r!a\u0002)\u0007\u0005\u001c)/\u0001\u0006p]J+7\u000f]8og\u0016$b!a*\u0004~\u000e}\bB\u0002?c\u0001\u0004\t9\u0001C\u0004\u0005\u0002\t\u0004\r\u0001b\u0001\u0002\u0011I,7\u000f]8og\u0016\u0004b\u0001\"\u0002\u0005\n\u0005\u001dRB\u0001C\u0004\u0015\r\u0019Y\u0007_\u0005\u0005\t\u0017!9AA\u0002UefD3AYBs\u0003IygNU3ta>t7/Z\"p[BdW\r^3\u0015\u0007}$\u0019\u0002C\u0004\u0005\u0016\r\u0004\r!a*\u0002\u0007\u0005t\u0017\u0010K\u0002d\u0007KD3!MBs\u00035\u0001vn\u001c7M_\u001e\u001cv.\u001e:dKV\u0011Aq\u0004\t\u0007\u0005k\"\tC!\u0004\n\t\u0011\r\"q\u000f\u0002\n\u0019><7k\\;sG\u0016\fa\u0002U8pY2{wmU8ve\u000e,\u0007\u0005C\u0004\u0004X\n\u0001\u001dA!=\u0016\u0005\u0005M\u0002")
public interface PoolInterface {
    public static PoolInterface apply(PoolId poolId, ActorRefFactory parent, PoolMaster master, Materializer fm) {
        return PoolInterface$.MODULE$.apply(poolId, parent, master, fm);
    }

    public void request(HttpRequest var1, Promise<HttpResponse> var2);

    public Future<ShutdownReason> shutdown(ExecutionContext var1);

    public Future<ShutdownReason> whenShutdown();

    @InternalStableApi
    private static class Logic
    extends TimerGraphStageLogic
    implements PoolInterface,
    InHandler,
    OutHandler,
    LogHelper {
        private final PoolId poolId;
        private final PoolMaster master;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final ExecutionContext executionContext;
        private final BufferOverflowException PoolOverflowException;
        private final HostConnectionPoolSetup hcps;
        private final Duration idleTimeout;
        private final Promise<ShutdownReason> shutdownPromise;
        private Option<ShutdownReason> shuttingDownReason;
        private int remainingRequested;
        private final ArrayDeque<PoolFlow.RequestContext> buffer;
        private final AsyncCallback<Done> responseCompletedCallback;
        private final AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback;
        private final AsyncCallback<BoxedUnit> shutdownCallback;

        public boolean isDebugEnabled() {
            return LogHelper.isDebugEnabled$((LogHelper)this);
        }

        public boolean isInfoEnabled() {
            return LogHelper.isInfoEnabled$((LogHelper)this);
        }

        public boolean isWarningEnabled() {
            return LogHelper.isWarningEnabled$((LogHelper)this);
        }

        public String prefixString() {
            return LogHelper.prefixString$((LogHelper)this);
        }

        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this);
        }

        public void onDownstreamFinish(Throwable cause) throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
        }

        public void onUpstreamFinish() throws Exception {
            InHandler.onUpstreamFinish$((InHandler)this);
        }

        public LoggingAdapter log() {
            return this.log;
        }

        public HostConnectionPoolSetup hcps() {
            return this.hcps;
        }

        public Duration idleTimeout() {
            return this.idleTimeout;
        }

        public Promise<ShutdownReason> shutdownPromise() {
            return this.shutdownPromise;
        }

        public boolean shuttingDown() {
            return this.shuttingDownReason().isDefined();
        }

        public Option<ShutdownReason> shuttingDownReason() {
            return this.shuttingDownReason;
        }

        public void shuttingDownReason_$eq(Option<ShutdownReason> x$1) {
            this.shuttingDownReason = x$1;
        }

        public int remainingRequested() {
            return this.remainingRequested;
        }

        public void remainingRequested_$eq(int x$1) {
            this.remainingRequested = x$1;
        }

        public ArrayDeque<PoolFlow.RequestContext> buffer() {
            return this.buffer;
        }

        public void preStart() {
            this.onInit(this.poolId);
            this.pull(this.responseIn);
            this.resetIdleTimer();
        }

        public void onTimer(Object timerKey) {
            if (this.isDebugEnabled()) {
                this.log().debug(new StringBuilder(89).append(this.prefixString()).append("Pool shutting down because pekko.http.host-connection-pool.idle-timeout triggered after ").append(this.idleTimeout()).append(".").toString());
            }
            this.requestShutdown(PoolInterface$ShutdownReason$IdleTimeout$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        public void onPush() {
            var1_1 = (PoolFlow.ResponseContext)this.grab(this.responseIn);
            if (var1_1 == null) {
                throw new MatchError(null);
            }
            rc = var1_1.rc();
            response0 = var1_1.response();
            ctx = this.onResponse(var2_2.request(), (Try<HttpResponse>)var3_3);
            var6_5 = false;
            var7_6 = null;
            if (!(var3_3 instanceof Success)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Success)var3_3;
            r = (HttpResponse)var7_6.value();
            if (r == null) ** GOTO lbl-1000
            if (!OptHttpResponse$.MODULE$.isEmpty$extension(r) && !(entity = r.entity()).isStrict()) {
                var10_9 = StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
                if (var10_9 == null) {
                    throw new MatchError(null);
                }
                newEntity = (ResponseEntity)var10_9._1();
                termination = (Future)var10_9._2();
                var12_11.onComplete((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$onPush$1$adapted(org.apache.pekko.http.impl.engine.client.PoolInterface$Logic scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((Logic)this), this.executionContext);
                v0 = new Success((Object)r.withEntity((org.apache.pekko.http.javadsl.model.ResponseEntity)var11_10));
            } else if (var6_5) {
                response = (HttpResponse)var7_6.value();
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                v0 = new Success((Object)response);
            } else if (var3_3 instanceof Failure) {
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                v0 = var3_3;
            } else {
                throw new MatchError((Object)var3_3);
            }
            response1 = v0;
            var2_2.responsePromise().complete((Try)response1);
            this.onResponseComplete(ctx);
            this.pull(this.responseIn);
            this.afterRequestFinished();
        }

        public void onPull() {
            if (!this.buffer().isEmpty()) {
                PoolFlow.RequestContext ctx = this.buffer().removeFirst();
                if (this.isDebugEnabled()) {
                    this.log().debug(new StringBuilder(63).append(this.prefixString()).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(ctx.request())).append("] from buffer to pool. Remaining buffer: ").append(this.buffer().size()).append("/").append(this.bufferSize).toString());
                }
                this.push(this.requestOut, ctx);
                return;
            }
        }

        public AsyncCallback<Done> responseCompletedCallback() {
            return this.responseCompletedCallback;
        }

        public AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback() {
            return this.requestCallback;
        }

        public AsyncCallback<BoxedUnit> shutdownCallback() {
            return this.shutdownCallback;
        }

        public void afterRequestFinished() {
            this.shutdownIfRequestedAndPossible();
            this.resetIdleTimer();
        }

        public void requestShutdown(ShutdownReason reason) {
            this.shuttingDownReason_$eq((Option<ShutdownReason>)new Some((Object)reason));
            this.shutdownIfRequestedAndPossible();
        }

        public void shutdownIfRequestedAndPossible() {
            if (this.shuttingDown()) {
                if (this.remainingRequested() == 0) {
                    if (this.isDebugEnabled()) {
                        this.log().debug(new StringBuilder(39).append(this.prefixString()).append("Pool is now shutting down as requested.").toString());
                    }
                    this.shutdownPromise().trySuccess(this.shuttingDownReason().get());
                    this.completeStage();
                    return;
                }
                if (this.isDebugEnabled()) {
                    this.log().debug(new StringBuilder(64).append(this.prefixString()).append("Pool is shutting down after waiting for [").append(this.remainingRequested()).append("] outstanding requests.").toString());
                }
                return;
            }
        }

        public void resetIdleTimer() {
            this.cancelTimer(PoolInterface$.MODULE$.org$apache$pekko$http$impl$engine$client$PoolInterface$$IdleTimeout());
            if (this.shouldStopOnIdle()) {
                this.scheduleOnce(PoolInterface$.MODULE$.org$apache$pekko$http$impl$engine$client$PoolInterface$$IdleTimeout(), (FiniteDuration)this.idleTimeout());
                return;
            }
        }

        public boolean shouldStopOnIdle() {
            return !this.shuttingDown() && this.remainingRequested() == 0 && this.idleTimeout().isFinite() && this.hcps().setup().settings().minConnections() == 0;
        }

        public void onUpstreamFailure(Throwable ex) {
            this.shutdownPromise().tryFailure(ex);
        }

        public void postStop() {
            this.shutdownPromise().tryFailure((Throwable)new IllegalStateException("Pool shutdown unexpectedly"));
        }

        @Override
        public void request(HttpRequest request, Promise<HttpResponse> responsePromise) {
            this.requestCallback().invokeWithFeedback((Object)new Tuple2((Object)request, responsePromise)).failed().foreach((Function1 & Serializable)x$6 -> {
                if (this.isDebugEnabled()) {
                    this.log().debug(new StringBuilder(106).append(this.prefixString()).append("Request was sent to pool which was already closed, retrying through the master to create new pool instance").toString());
                }
                return responsePromise.tryCompleteWith($this.master.dispatchRequest($this.poolId, request, this.materializer()));
            }, this.executionContext);
        }

        @Override
        public Future<ShutdownReason> shutdown(ExecutionContext ec) {
            this.shutdownCallback().invoke((Object)BoxedUnit.UNIT);
            return this.whenShutdown();
        }

        @Override
        public Future<ShutdownReason> whenShutdown() {
            return this.shutdownPromise().future();
        }

        @InternalStableApi
        public void onInit(PoolId poolId) {
        }

        @InternalStableApi
        public HttpRequest onDispatch(HttpRequest request) {
            return request;
        }

        @InternalStableApi
        public Object onResponse(HttpRequest request, Try<HttpResponse> response) {
            return None$.MODULE$;
        }

        @InternalStableApi
        public void onResponseComplete(Object any) {
        }

        public static final /* synthetic */ void $anonfun$onPush$1(Logic $this, Try x$3) {
            $this.responseCompletedCallback().invoke((Object)Done$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$responseCompletedCallback$1(Logic $this, Done x$4) {
            $this.remainingRequested_$eq($this.remainingRequested() - 1);
            $this.afterRequestFinished();
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void $anonfun$requestCallback$1(Logic $this, Tuple2 x0$1) {
            if (x0$1 != null) {
                void withDefaultHeaders_otherHeaders;
                HttpRequest request = (HttpRequest)x0$1._1();
                Promise responsePromise = (Promise)x0$1._2();
                String scheme = Uri$.MODULE$.httpScheme(((ConnectionContext)((Object)$this.hcps().setup().connectionContext())).isSecure());
                Host hostHeader = Host$.MODULE$.apply($this.hcps().host(), Uri$.MODULE$.normalizePort($this.hcps().port(), scheme));
                HttpRequest httpRequest = request.withUri(request.uri().toHttpRequestTargetOriginForm());
                Nil$ nil$ = Nil$.MODULE$;
                if (httpRequest == null) {
                    throw null;
                }
                nil$ = null;
                HttpRequest effectiveRequest = $this.onDispatch((HttpRequest)HttpMessage.withDefaultHeaders$(httpRequest, hostHeader, (Seq)withDefaultHeaders_otherHeaders));
                int retries = request.method().isIdempotent() ? $this.hcps().setup().settings().maxRetries() : 0;
                $this.remainingRequested_$eq($this.remainingRequested() + 1);
                $this.resetIdleTimer();
                PoolFlow.RequestContext ctx = new PoolFlow.RequestContext(effectiveRequest, (Promise<HttpResponse>)responsePromise, retries);
                if ($this.isAvailable($this.requestOut)) {
                    if ($this.isDebugEnabled()) {
                        $this.log().debug(new StringBuilder(30).append($this.prefixString()).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(request)).append("] to pool").toString());
                    }
                    $this.push($this.requestOut, ctx);
                    return;
                }
                if ($this.buffer().size() < $this.bufferSize) {
                    $this.buffer().addLast(ctx);
                    if ($this.isDebugEnabled()) {
                        $this.log().debug(new StringBuilder(34).append($this.prefixString()).append("Buffering request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(request)).append("] at position ").append($this.buffer().size()).append("/").append($this.bufferSize).toString());
                        return;
                    }
                    return;
                }
                if ($this.isDebugEnabled()) {
                    $this.log().debug(new StringBuilder(52).append($this.prefixString()).append("Could not dispatch request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(request)).append("] because buffer is full").toString());
                }
                responsePromise.tryFailure((Throwable)$this.PoolOverflowException);
                return;
            }
            throw new MatchError(null);
        }

        public Logic(PoolId poolId, FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape, PoolMaster master, Outlet<PoolFlow.RequestContext> requestOut, Inlet<PoolFlow.ResponseContext> responseIn, int bufferSize, LoggingAdapter log, ExecutionContext executionContext) {
            this.poolId = poolId;
            this.master = master;
            this.requestOut = requestOut;
            this.responseIn = responseIn;
            this.bufferSize = bufferSize;
            this.log = log;
            this.executionContext = executionContext;
            super(shape);
            InHandler.$init$((InHandler)this);
            OutHandler.$init$((OutHandler)this);
            LogHelperMacro.$init$((LogHelperMacro)this);
            LogHelper.$init$((LogHelper)this);
            this.PoolOverflowException = new BufferOverflowException(new StringBuilder(376).append("Exceeded configured max-open-requests value of [").append(poolId.hcps().setup().settings().maxOpenRequests()).append("]. This means that the request queue of this pool (").append(poolId.hcps()).append(") ").append("has completely filled up because the pool currently does not process requests fast enough to handle the incoming request load. ").append("Please retry the request later. See https://pekko.apache.org/docs/pekko-http/current/scala/http/client-side/pool-overflow.html for ").append("more information.").toString());
            this.hcps = poolId.hcps();
            this.idleTimeout = this.hcps().setup().settings().idleTimeout();
            this.shutdownPromise = Promise$.MODULE$.apply();
            this.shuttingDownReason = None$.MODULE$;
            this.remainingRequested = 0;
            this.buffer = new ArrayDeque(bufferSize);
            this.setHandlers(responseIn, requestOut, this);
            this.responseCompletedCallback = this.getAsyncCallback((Function1 & Serializable)x$4 -> {
                Logic.$anonfun$responseCompletedCallback$1(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.requestCallback = this.getAsyncCallback((Function1 & Serializable)x0$1 -> {
                Logic.$anonfun$requestCallback$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.shutdownCallback = this.getAsyncCallback((Function1 & Serializable)x$5 -> {
                this.requestShutdown(PoolInterface$ShutdownReason$ShutdownRequested$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Object $anonfun$onPush$1$adapted(Logic $this, Try x$3) {
            Logic.$anonfun$onPush$1($this, x$3);
            return BoxedUnit.UNIT;
        }
    }

    public static class PoolInterfaceStage
    extends GraphStageWithMaterializedValue<FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>, PoolInterface> {
        private final PoolId poolId;
        private final PoolMaster master;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;

        private Outlet<PoolFlow.RequestContext> requestOut() {
            return this.requestOut;
        }

        private Inlet<PoolFlow.ResponseContext> responseIn() {
            return this.responseIn;
        }

        public FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape() {
            return new FlowShape(this.responseIn(), this.requestOut());
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            throw new IllegalStateException("Should not be called");
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer _materializer) {
            Logic logic = new Logic(this.poolId, this.shape(), this.master, this.requestOut(), this.responseIn(), this.bufferSize, this.log, (ExecutionContext)_materializer.executionContext());
            return new Tuple2((Object)logic, (Object)logic);
        }

        public PoolInterfaceStage(PoolId poolId, PoolMaster master, int bufferSize, LoggingAdapter log) {
            this.poolId = poolId;
            this.master = master;
            this.bufferSize = bufferSize;
            this.log = log;
            this.requestOut = Outlet$.MODULE$.apply("PoolInterface.requestOut");
            this.responseIn = Inlet$.MODULE$.apply("PoolInterface.responseIn");
        }
    }

    public static interface ShutdownReason {
    }
}

