/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.liquibase.logging.slf4j;

import java.util.logging.Level;
import liquibase.logging.Logger;
import liquibase.logging.core.AbstractLogger;

public class Slf4jLogger
extends AbstractLogger
implements Logger {
    private static final int TRACE_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_THRESHOLD = Level.WARNING.intValue();
    private static final int ERROR_THRESHOLD = Level.SEVERE.intValue();
    private final org.slf4j.Logger logger;

    Slf4jLogger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    public void log(Level level, String message, Throwable e) {
        int levelValue = level.intValue();
        if (levelValue <= TRACE_THRESHOLD) {
            this.logger.trace(message, e);
        } else if (levelValue <= DEBUG_THRESHOLD) {
            this.logger.debug(message, e);
        } else if (levelValue <= INFO_THRESHOLD) {
            this.logger.info(message, e);
        } else if (levelValue <= WARN_THRESHOLD) {
            this.logger.warn(message, e);
        } else if (levelValue <= ERROR_THRESHOLD) {
            this.logger.error(message, e);
        }
    }

    public void severe(String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message);
        }
    }

    public void severe(String message, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, e);
        }
    }

    public void warning(String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message);
        }
    }

    public void warning(String message, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message, e);
        }
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message);
        }
    }

    public void info(String message, Throwable e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message, e);
        }
    }

    public void config(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message);
        }
    }

    public void config(String message, Throwable e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message, e);
        }
    }

    public void fine(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }

    public void fine(String message, Throwable e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, e);
        }
    }
}

