/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JekyllTagNodeFormatter
implements PhasedNodeFormatter {
    private boolean embedIncludedContent;

    public JekyllTagNodeFormatter(DataHolder options) {
    }

    @Nullable
    public Set<FormattingPhase> getFormattingPhases() {
        return Collections.singleton(FormattingPhase.COLLECT);
    }

    public void renderDocument(@NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown, @NotNull Document document, @NotNull FormattingPhase phase) {
        this.embedIncludedContent = (Boolean)JekyllTagExtension.EMBED_INCLUDED_CONTENT.get((DataHolder)document);
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(JekyllTagBlock.class, this::render), new NodeFormattingHandler(JekyllTag.class, this::render)));
    }

    private void render(JekyllTagBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren((Node)node);
    }

    private void render(JekyllTag node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.embedIncludedContent) {
            context.renderChildren((Node)node);
        } else {
            if (!(node.getParent() instanceof JekyllTagBlock)) {
                Node prev = node.getPrevious();
                if (prev != null) {
                    BasedSequence chars = prev.getChars();
                    ((MarkdownWriter)markdown.pushOptions()).preserveSpaces().append((CharSequence)chars.baseSubSequence(chars.getEndOffset(), node.getStartOffset())).popOptions();
                } else {
                    int startLine = node.getBaseSequence().startOfLine(node.getStartOffset());
                    if (startLine < node.getStartOffset()) {
                        BasedSequence chars = node.baseSubSequence(startLine, node.getStartOffset());
                        ((MarkdownWriter)markdown.pushOptions()).preserveSpaces().append((CharSequence)chars).popOptions();
                    }
                }
            }
            markdown.append((CharSequence)node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new JekyllTagNodeFormatter(options);
        }
    }
}

