/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.cmd.Tail;
import org.hyperic.sigar.win32.EventLog;
import org.hyperic.sigar.win32.EventLogNotification;
import org.hyperic.sigar.win32.EventLogRecord;
import org.hyperic.sigar.win32.EventLogThread;
import org.hyperic.sigar.win32.Win32Exception;

public class EventLogTail {
    private static void tail(String name, Tail tail) throws Win32Exception {
        int first;
        EventLog log = new EventLog();
        log.open(name);
        int max = log.getNumberOfRecords();
        if (tail.number < max) {
            max = tail.number;
        }
        int last = log.getNewestRecord() + 1;
        for (int i = first = last - max; i < last; ++i) {
            EventLogRecord record = log.read(i);
            System.out.println(record);
        }
        log.close();
    }

    public static void main(String[] args) throws Exception {
        Tail tail = new Tail();
        tail.parseArgs(args);
        if (tail.files.size() == 0) {
            tail.files.add("System");
        }
        for (int i = 0; i < tail.files.size(); ++i) {
            String name = (String)tail.files.get(i);
            EventLogTail.tail(name, tail);
            if (!tail.follow) continue;
            TailNotification notifier = new TailNotification();
            EventLogThread thread = EventLogThread.getInstance(name);
            thread.add(notifier);
            thread.doStart();
        }
        if (tail.follow) {
            System.in.read();
        }
    }

    private static class TailNotification
    implements EventLogNotification {
        private TailNotification() {
        }

        public void handleNotification(EventLogRecord event) {
            System.out.println(event);
        }

        public boolean matches(EventLogRecord event) {
            return true;
        }
    }
}

