/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import jakarta.persistence.criteria.JoinType;
import java.util.List;
import java.util.Set;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditAssociationQuery;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;
import org.hibernate.envers.query.internal.impl.AuditQueryImplementor;
import org.hibernate.envers.query.internal.impl.EntitiesAtRevisionAssociationQuery;
import org.hibernate.query.Query;

public class EntitiesModifiedAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;

    public EntitiesModifiedAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, Number revision) {
        super(enversService, versionsReader, cls);
        this.revision = revision;
    }

    public EntitiesModifiedAtRevisionQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision) {
        super(enversService, versionsReader, cls, entityName);
        this.revision = revision;
    }

    @Override
    public List list() {
        String revisionPropertyPath = this.enversService.getConfig().getRevisionNumberPath();
        this.qb.getRootParameters().addWhereWithParam(revisionPropertyPath, "=", this.revision);
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.enversService, this.versionsReader, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, "e__", this.qb, this.qb.getRootParameters());
        }
        for (AbstractAuditAssociationQuery associationQuery : this.associationQueries) {
            associationQuery.addCriterionToQuery(this.versionsReader);
        }
        Query query = this.buildQuery();
        Set params = query.getParameterMetadata().getNamedParameterNames();
        if (params.contains("revision")) {
            query.setParameter("revision", (Object)this.revision);
        }
        List queryResult = query.list();
        return this.applyProjections(queryResult, this.revision);
    }

    @Override
    public AuditAssociationQuery<? extends AuditQuery> traverseRelation(String associationName, JoinType joinType, String alias, AuditCriterion onClauseCriterion) {
        EntitiesAtRevisionAssociationQuery<AuditQueryImplementor> query = (EntitiesAtRevisionAssociationQuery<AuditQueryImplementor>)this.associationQueryMap.get(associationName);
        if (query == null) {
            query = new EntitiesAtRevisionAssociationQuery<AuditQueryImplementor>(this.enversService, this.versionsReader, this, this.qb, associationName, joinType, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, "e__", alias, null);
            this.addAssociationQuery(associationName, query);
        }
        return query;
    }
}

