/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.util.Assert;

public class WebAuthnAuthentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -4879907158750659197L;
    private final PublicKeyCredentialUserEntity principal;

    public WebAuthnAuthentication(PublicKeyCredentialUserEntity principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        super.setAuthenticated(true);
    }

    public void setAuthenticated(boolean authenticated) {
        Assert.isTrue((!authenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted");
        super.setAuthenticated(authenticated);
    }

    public Object getCredentials() {
        return null;
    }

    public PublicKeyCredentialUserEntity getPrincipal() {
        return this.principal;
    }

    public String getName() {
        return this.principal.getName();
    }
}

