/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientInput;
import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientInputs;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.ImmutableAuthenticationExtensionsClientInputs;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialDescriptor;
import org.springframework.security.web.webauthn.api.UserVerificationRequirement;
import org.springframework.util.Assert;

public final class PublicKeyCredentialRequestOptions
implements Serializable {
    private static final long serialVersionUID = -2970057592835694354L;
    private final Bytes challenge;
    private final Duration timeout;
    private final String rpId;
    private final List<PublicKeyCredentialDescriptor> allowCredentials;
    private final UserVerificationRequirement userVerification;
    private final AuthenticationExtensionsClientInputs extensions;

    private PublicKeyCredentialRequestOptions(Bytes challenge, Duration timeout, String rpId, List<PublicKeyCredentialDescriptor> allowCredentials, UserVerificationRequirement userVerification, AuthenticationExtensionsClientInputs extensions) {
        Assert.notNull((Object)challenge, (String)"challenge cannot be null");
        Assert.hasText((String)rpId, (String)"rpId cannot be empty");
        this.challenge = challenge;
        this.timeout = timeout;
        this.rpId = rpId;
        this.allowCredentials = allowCredentials;
        this.userVerification = userVerification;
        this.extensions = extensions;
    }

    public Bytes getChallenge() {
        return this.challenge;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getRpId() {
        return this.rpId;
    }

    public List<PublicKeyCredentialDescriptor> getAllowCredentials() {
        return this.allowCredentials;
    }

    public UserVerificationRequirement getUserVerification() {
        return this.userVerification;
    }

    public AuthenticationExtensionsClientInputs getExtensions() {
        return this.extensions;
    }

    public static PublicKeyCredentialRequestOptionsBuilder builder() {
        return new PublicKeyCredentialRequestOptionsBuilder();
    }

    public static final class PublicKeyCredentialRequestOptionsBuilder {
        private Bytes challenge;
        private Duration timeout = Duration.ofMinutes(5L);
        private String rpId;
        private List<PublicKeyCredentialDescriptor> allowCredentials = Collections.emptyList();
        private UserVerificationRequirement userVerification;
        private AuthenticationExtensionsClientInputs extensions = new ImmutableAuthenticationExtensionsClientInputs(new ArrayList<AuthenticationExtensionsClientInput>());

        private PublicKeyCredentialRequestOptionsBuilder() {
        }

        public PublicKeyCredentialRequestOptionsBuilder challenge(Bytes challenge) {
            this.challenge = challenge;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder timeout(Duration timeout) {
            Assert.notNull((Object)timeout, (String)"timeout cannot be null");
            this.timeout = timeout;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder allowCredentials(List<PublicKeyCredentialDescriptor> allowCredentials) {
            Assert.notNull(allowCredentials, (String)"allowCredentials cannot be null");
            this.allowCredentials = allowCredentials;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder userVerification(UserVerificationRequirement userVerification) {
            this.userVerification = userVerification;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder extensions(AuthenticationExtensionsClientInputs extensions) {
            this.extensions = extensions;
            return this;
        }

        public PublicKeyCredentialRequestOptionsBuilder customize(Consumer<PublicKeyCredentialRequestOptionsBuilder> customizer) {
            customizer.accept(this);
            return this;
        }

        public PublicKeyCredentialRequestOptions build() {
            if (this.challenge == null) {
                this.challenge = Bytes.random();
            }
            return new PublicKeyCredentialRequestOptions(this.challenge, this.timeout, this.rpId, this.allowCredentials, this.userVerification, this.extensions);
        }
    }
}

