/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class PPandMMHelper {
    private boolean exprentReplaced;

    public boolean findPPandMM(RootStatement root) {
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        stack.add(dgraph.first);
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        boolean res = false;
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            if (setVisited.contains(node)) continue;
            setVisited.add(node);
            res |= this.processExprentList(node.exprents);
            stack.addAll(node.succs);
        }
        return res;
    }

    private boolean processExprentList(List<Exprent> lst) {
        boolean result = false;
        for (int i = 0; i < lst.size(); ++i) {
            Exprent exprent = lst.get(i);
            this.exprentReplaced = false;
            Exprent retexpr = this.processExprentRecursive(exprent);
            if (retexpr != null) {
                lst.set(i, retexpr);
                result = true;
                --i;
            }
            result |= this.exprentReplaced;
        }
        return result;
    }

    private Exprent processExprentRecursive(Exprent exprent) {
        boolean replaced = true;
        block0: while (replaced) {
            replaced = false;
            for (Exprent expr : exprent.getAllExprents()) {
                Exprent retexpr = this.processExprentRecursive(expr);
                if (retexpr == null) continue;
                exprent.replaceExprent(expr, retexpr);
                replaced = true;
                this.exprentReplaced = true;
                continue block0;
            }
        }
        if (exprent.type == 2) {
            AssignmentExprent as = (AssignmentExprent)exprent;
            if (as.getRight().type == 6) {
                FunctionExprent func = (FunctionExprent)as.getRight();
                VarType midlayer = null;
                if (func.getFuncType() >= 14 && func.getFuncType() <= 28) {
                    midlayer = func.getSimpleCastType();
                    if (func.getLstOperands().get((int)0).type == 6) {
                        func = (FunctionExprent)func.getLstOperands().get(0);
                    } else {
                        return null;
                    }
                }
                if (func.getFuncType() == 0 || func.getFuncType() == 1) {
                    Exprent econd = func.getLstOperands().get(0);
                    Exprent econst = func.getLstOperands().get(1);
                    if (econst.type != 3 && econd.type == 3 && func.getFuncType() == 0) {
                        econd = econst;
                        econst = func.getLstOperands().get(0);
                    }
                    if (econst.type == 3 && ((ConstExprent)econst).hasValueOne()) {
                        Exprent left = as.getLeft();
                        VarType condtype = econd.getExprType();
                        if (left.equals(econd) && (midlayer == null || midlayer.equals(condtype))) {
                            FunctionExprent ret = new FunctionExprent(func.getFuncType() == 0 ? 35 : 33, econd, (Set<Integer>)func.bytecode);
                            ret.setImplicitType(condtype);
                            this.exprentReplaced = true;
                            return ret;
                        }
                    }
                }
            }
        }
        return null;
    }
}

