/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;

public abstract class DelegatingCacheLoader<K, V>
implements CacheLoader<K, V> {
    protected CacheLoader actual;
    protected InitializationContext ctx;

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        if (this.actual instanceof DelegatingCacheLoader) {
            this.actual.init(ctx);
        }
    }

    public void start() {
        if (this.actual instanceof DelegatingCacheLoader) {
            this.actual.start();
        }
    }

    public void stop() {
        if (this.actual instanceof DelegatingCacheLoader) {
            this.actual.stop();
        }
    }

    protected DelegatingCacheLoader(CacheLoader actual) {
        this.actual = actual;
    }

    @Override
    public boolean contains(Object key) {
        return this.actual != null && this.actual.contains(key);
    }

    @Override
    public MarshallableEntry<K, V> loadEntry(Object key) {
        return this.actual != null ? this.actual.loadEntry(key) : null;
    }

    public CacheLoader undelegate() {
        CacheLoader<K, V> cl = this;
        while ((cl = cl.actual) instanceof DelegatingCacheLoader) {
        }
        return cl;
    }
}

