/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import java.util.function.Function;

public enum UnsupportedFeatureHandling {
    ERROR,
    WARN,
    IGNORE,
    PICK;


    public static UnsupportedFeatureHandling fromSetting(Object value) {
        return UnsupportedFeatureHandling.fromSetting(value, (Object v) -> null);
    }

    public static UnsupportedFeatureHandling fromSetting(Object value, UnsupportedFeatureHandling defaultValue) {
        return UnsupportedFeatureHandling.fromSetting(value, (Object v) -> defaultValue);
    }

    public static UnsupportedFeatureHandling fromSetting(Object value, Function<Object, UnsupportedFeatureHandling> defaultValueSupplier) {
        if (value != null) {
            if (value instanceof UnsupportedFeatureHandling) {
                return (UnsupportedFeatureHandling)((Object)value);
            }
            if (ERROR.name().equalsIgnoreCase(value.toString())) {
                return ERROR;
            }
            if (IGNORE.name().equalsIgnoreCase(value.toString())) {
                return IGNORE;
            }
            if (PICK.name().equalsIgnoreCase(value.toString())) {
                return PICK;
            }
        }
        return defaultValueSupplier.apply(value);
    }
}

