/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.FlushModeType;
import org.hibernate.AssertionFailure;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;

public enum FlushMode {
    MANUAL,
    COMMIT,
    AUTO,
    ALWAYS;


    public boolean lessThan(FlushMode other) {
        return this.level() < other.level();
    }

    public static FlushMode interpretExternalSetting(String externalName) {
        return FlushModeTypeHelper.interpretExternalSetting(externalName);
    }

    private int level() {
        switch (this) {
            case ALWAYS: {
                return 20;
            }
            case AUTO: {
                return 10;
            }
            case COMMIT: {
                return 5;
            }
            case MANUAL: {
                return 0;
            }
        }
        throw new AssertionFailure("Impossible FlushMode");
    }

    public static FlushMode fromJpaFlushMode(FlushModeType flushModeType) {
        return FlushModeTypeHelper.getFlushMode(flushModeType);
    }

    public static FlushModeType toJpaFlushMode(FlushMode flushMode) {
        return FlushModeTypeHelper.getFlushModeType(flushMode);
    }

    public FlushModeType toJpaFlushMode() {
        return FlushModeTypeHelper.getFlushModeType(this);
    }
}

