/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io.copy;

import com.xebialabs.deployit.io.copy.ArchiveOptions;
import com.xebialabs.deployit.io.copy.ArchiveOptions$;
import com.xebialabs.deployit.io.copy.CopyStrategies$;
import com.xebialabs.deployit.io.copy.CopyStrategy;
import com.xebialabs.deployit.io.copy.ZippedCopy;
import com.xebialabs.deployit.io.copy.package;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFolderArtifact;
import com.xebialabs.deployit.plugin.overthere.CopyStrategyName;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.jdk.javaapi.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class CopyUtil$ {
    public static final CopyUtil$ MODULE$ = new CopyUtil$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String FILE_FOLDER_TYPE_PROPERTY = "file.Folder";

    private Logger logger() {
        return logger;
    }

    private String FILE_FOLDER_TYPE_PROPERTY() {
        return FILE_FOLDER_TYPE_PROPERTY;
    }

    public LocalFile zip(CopyStrategyName copyStrategy, LocalFile file) {
        package.Zipper qual$1 = new package.Zipper(copyStrategy);
        LocalFile x$1 = file;
        boolean x$2 = qual$1.zip$default$2();
        boolean x$3 = qual$1.zip$default$3();
        return qual$1.zip(x$1, x$2, x$3);
    }

    public LocalFile zipWithDirectoryAndExcludeRootDir(CopyStrategyName copyStrategy, LocalFile file) {
        return new package.Zipper(copyStrategy).zip(file, true, true);
    }

    public LocalFile zipWithDirectoryAndRootDir(CopyStrategyName copyStrategy, LocalFile file) {
        package.Zipper qual$1 = new package.Zipper(copyStrategy);
        LocalFile x$1 = file;
        boolean x$2 = true;
        boolean x$3 = qual$1.zip$default$3();
        return qual$1.zip(x$1, true, x$3);
    }

    public void extractFolder(CopyStrategyName strategyName, String srcFileName, OverthereFile dest, ArchiveOptions archiveOptions, OverthereFile remoteZippedCopy) {
        CopyStrategy strategy;
        CopyStrategy copyStrategy;
        CopyStrategyName copyStrategyName = strategyName;
        if (CopyStrategyName.ZipWindows.equals(copyStrategyName)) {
            copyStrategy = CopyStrategies$.MODULE$.unzipWindows();
        } else if (CopyStrategyName.ZipUnix.equals(copyStrategyName)) {
            copyStrategy = CopyStrategies$.MODULE$.unzipUnix();
        } else if (CopyStrategyName.Tar.equals(copyStrategyName)) {
            copyStrategy = CopyStrategies$.MODULE$.untar();
        } else if (CopyStrategyName.OneByOne.equals(copyStrategyName)) {
            copyStrategy = CopyStrategies$.MODULE$.oneByOne();
        } else {
            throw new MatchError((Object)copyStrategyName);
        }
        CopyStrategy copyStrategy2 = strategy = copyStrategy;
        if (copyStrategy2 instanceof ZippedCopy) {
            CopyStrategy copyStrategy3 = copyStrategy2;
            ((ZippedCopy)((Object)copyStrategy3)).extractFolder(srcFileName, dest, archiveOptions, remoteZippedCopy);
            return;
        }
    }

    public OverthereFile getDestZippedFile(OverthereFile dest, CopyStrategyName copyStrategyName, String sourceFileName) {
        String string;
        CopyStrategyName copyStrategyName2 = copyStrategyName;
        if (CopyStrategyName.ZipWindows.equals(copyStrategyName2)) {
            string = ".zip";
        } else if (CopyStrategyName.ZipUnix.equals(copyStrategyName2)) {
            string = ".zip";
        } else if (CopyStrategyName.Tar.equals(copyStrategyName2)) {
            string = ".tar";
        } else if (CopyStrategyName.OneByOne.equals(copyStrategyName2)) {
            string = "";
        } else {
            throw new MatchError((Object)copyStrategyName2);
        }
        String extension = string;
        return dest.getParentFile().getFile(sourceFileName + extension);
    }

    public ArchiveOptions newArchiveOptionsForFolder(BaseDeployableFolderArtifact bfa, Integer stripComponentsDerived, Set<String> membersDerived) {
        return this.newArchiveOptionsByStripAndMembers(bfa, stripComponentsDerived, membersDerived);
    }

    public ArchiveOptions newArchiveOptionsForFolder(BaseDeployableFolderArtifact bfa) {
        Integer stripComponents = Predef$.MODULE$.int2Integer(this.getStripComponents(bfa));
        Set<String> members = this.getMembers(bfa);
        return this.newArchiveOptionsByStripAndMembers(bfa, stripComponents, members);
    }

    private ArchiveOptions newArchiveOptionsByStripAndMembers(BaseDeployableFolderArtifact bfa, Integer stripComponents, Set<String> members) {
        ArchiveOptions archiveOptions = null;
        this.logger().debug("getArchiveOptions() - BaseDeployableFolderArtifact detected: {}, Type: {}", (Object)bfa.getId(), (Object)bfa.getType());
        boolean extractToTargetPath = bfa.isForceArchive();
        String targetDestPath = this.getTargetPathDerived(bfa, extractToTargetPath);
        boolean isTargetPathDerived = this.checkTargetPathDerivedFound(targetDestPath);
        boolean tarOptionsApplied = this.isTarOptionsApplied(Predef$.MODULE$.Integer2int(stripComponents), members);
        this.logger().debug("getArchiveOptions() - extractToTargetPath: {}, targetPathDerived: {} , stripComponents: {}, members.size: {}, tarCopyOptionsApplied: {}", new Object[]{BoxesRunTime.boxToBoolean((boolean)extractToTargetPath), BoxesRunTime.boxToBoolean((boolean)isTargetPathDerived), stripComponents, members != null ? BoxesRunTime.boxToInteger((int)members.size()) : BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToBoolean((boolean)tarOptionsApplied)});
        if (extractToTargetPath || tarOptionsApplied) {
            archiveOptions = new ArchiveOptions(Predef$.MODULE$.Integer2int(stripComponents), (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.asScala(new TreeSet<String>(members)).toSet(), bfa.getDefaultCopyStrategyName(), extractToTargetPath && isTargetPathDerived, targetDestPath);
            this.logger().debug("getArchiveOptions() - created custom ArchiveOptions: {}", (Object)archiveOptions);
        } else {
            archiveOptions = this.newArchiveOptionsFromDefaultCopyStrategy(bfa);
            this.logger().debug("getArchiveOptions() - using default ArchiveOptions: {}", (Object)archiveOptions);
        }
        return archiveOptions;
    }

    public ArchiveOptions newArchiveOptionsFromDefaultCopyStrategy(BaseDeployableFolderArtifact bfa) {
        ArchiveOptions archiveOptions = null;
        archiveOptions = bfa.getDefaultCopyStrategy() != null ? ArchiveOptions$.MODULE$.fromCopyStrategy(bfa.getDefaultCopyStrategyName()) : ArchiveOptions$.MODULE$.newDefaultInstance();
        return archiveOptions;
    }

    public boolean isDeployableFileFolder(BaseDeployableFolderArtifact bfa) {
        return this.FILE_FOLDER_TYPE_PROPERTY().equals(bfa.getType().toString());
    }

    public boolean isTarOptionsApplied(int stripComponents, Set<String> members) {
        return stripComponents > 0 || members != null && !members.isEmpty();
    }

    public Set<String> getMembers(BaseDeployableFolderArtifact bfa) {
        if (bfa.hasProperty("members")) {
            Set members = (Set)bfa.getProperty("members");
            return (Set)Option$.MODULE$.apply((Object)members).getOrElse((Function0 & Serializable)() -> Collections.emptySet());
        }
        return Collections.emptySet();
    }

    public int getStripComponents(BaseDeployableFolderArtifact bfa) {
        if (bfa.hasProperty("stripComponents")) {
            return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(bfa.getProperty("stripComponents")).map((Function1 & Serializable)obj -> obj.toString()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)CopyUtil$.$anonfun$getStripComponents$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        }
        return 0;
    }

    public boolean checkTargetPathDerivedFound(String targetDestPath) {
        return targetDestPath != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(targetDestPath));
    }

    public String getTargetPathDerived(BaseDeployableFolderArtifact bfa, boolean extractToTargetPath) {
        if (extractToTargetPath && bfa.hasProperty("targetPath")) {
            return (String)Option$.MODULE$.apply(bfa.getProperty("targetPath")).map((Function1 & Serializable)obj -> obj.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return null;
    }

    public static final /* synthetic */ int $anonfun$getStripComponents$3(String x$1) {
        return Integer.parseInt(x$1);
    }

    private CopyUtil$() {
    }
}

