/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedBufferedInputStream;
import org.apache.tika.extractor.AbstractEmbeddedDocumentBytesHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.extractor.EmbeddedDocumentBytesConfig;

public class BasicEmbeddedDocumentBytesHandler
extends AbstractEmbeddedDocumentBytesHandler {
    private final EmbeddedDocumentBytesConfig config;
    Map<Integer, byte[]> docBytes = new HashMap<Integer, byte[]>();

    public BasicEmbeddedDocumentBytesHandler(EmbeddedDocumentBytesConfig config) {
        this.config = config;
    }

    @Override
    public void add(int id, Metadata metadata, InputStream is) throws IOException {
        super.add(id, metadata, is);
        this.docBytes.put(id, IOUtils.toByteArray((InputStream)is));
    }

    public InputStream getDocument(int id) throws IOException {
        return ((UnsynchronizedBufferedInputStream.Builder)new UnsynchronizedBufferedInputStream.Builder().setByteArray(this.docBytes.get(id))).get();
    }

    @Override
    public void close() throws IOException {
    }
}

