/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.ITask;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.stitch.model.ci.BaseSource;
import com.xebialabs.deployit.plugin.stitch.model.ci.FolderSource;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.SourceSyncStateService;
import com.xebialabs.deployit.plugin.stitch.service.StitchServiceHolder$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.ParallelSyncOccurredException;
import com.xebialabs.deployit.plugin.stitch.service.engine.util.FileUtil$;
import com.xebialabs.deployit.plugin.stitch.steps.BaseSourceStep;
import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@StepMetadata(name="sync")
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\u0007\u000f\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)1\t\u0001C\u0001\t\")1\t\u0001C\u0001\u0011\")\u0011\n\u0001C!\u0015\")a\n\u0001C!\u001f\")\u0001\u000b\u0001C\u0005#\")A\r\u0001C\u0005K\")Q\u000e\u0001C\u0005]\")A\u0010\u0001C\u0005{\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0002\t'ft7m\u0015;fa*\u0011q\u0002E\u0001\u0006gR,\u0007o\u001d\u0006\u0003#I\taa\u001d;ji\u000eD'BA\n\u0015\u0003\u0019\u0001H.^4j]*\u0011QCF\u0001\tI\u0016\u0004Hn\\=ji*\u0011q\u0003G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!G\u0001\u0004G>l7\u0001A\n\u0004\u0001q!\u0003CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u00152S\"\u0001\b\n\u0005\u001dr!A\u0004\"bg\u0016\u001cv.\u001e:dKN#X\r]\u0001\u0012G>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\r)H-\u001c\u0006\u0003]I\t1!\u00199j\u0013\t\u00014FA\tD_:4\u0017nZ;sCRLwN\\%uK6\f!B\u0019:b]\u000eDg*Y7f!\r\u0019d\u0007O\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1q\n\u001d;j_:\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e5\u001b\u0005a$BA\u001f\u001b\u0003\u0019a$o\\8u}%\u0011q\bN\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@i\u00051A(\u001b8jiz\"2!\u0012$H!\t)\u0003\u0001C\u0003)\u0007\u0001\u0007\u0011\u0006C\u00032\u0007\u0001\u0007!\u0007F\u0001F\u0003!9W\r^(sI\u0016\u0014H#A&\u0011\u0005Mb\u0015BA'5\u0005\rIe\u000e^\u0001\u000fO\u0016$H)Z:de&\u0004H/[8o)\u0005A\u0014AE2sK\u0006$X-\u00118e'R\f'\u000f^*z]\u000e$2A\u0015.]!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0002dS*\u0011q\u000bE\u0001\u0006[>$W\r\\\u0005\u00033R\u0013!BQ1tKN{WO]2f\u0011\u0015Yv\u00011\u00019\u0003\tIG\rC\u0003^\u000f\u0001\u0007a,A\u0002dib\u0004\"a\u00182\u000e\u0003\u0001T!!Y\u0017\u0002\t\u0019dwn^\u0005\u0003G\u0002\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0015!\fg\u000e\u001a7f'ft7\r\u0006\u0003gS*d\u0007CA0h\u0013\tA\u0007M\u0001\u0007Ti\u0016\u0004X\t_5u\u0007>$W\rC\u0003\\\u0011\u0001\u0007\u0001\bC\u0003l\u0011\u0001\u0007!+\u0001\u0006d_6\u0004H.\u001a;f\u0007&DQ!\u0018\u0005A\u0002y\u000b!\u0002[1oI2,g)Y5m)\u00111wN_>\t\u000bAL\u0001\u0019A9\u0002\u0013\u0015D8-\u001a9uS>t\u0007C\u0001:x\u001d\t\u0019XO\u0004\u0002<i&\tQ'\u0003\u0002wi\u00059\u0001/Y2lC\u001e,\u0017B\u0001=z\u0005%!\u0006N]8xC\ndWM\u0003\u0002wi!)Q,\u0003a\u0001=\")1,\u0003a\u0001q\u0005i\u0001.\u00198eY\u0016\u001cVoY2fgN$BA\u001a@\u0002\u0002!)qP\u0003a\u0001q\u00059Q.Z:tC\u001e,\u0007\"B/\u000b\u0001\u0004q\u0016\u0001\u00034bS2\u001c\u0016P\\2\u0015\u000f\u0019\f9!!\u0003\u0002\f!)\u0001o\u0003a\u0001c\")Ql\u0003a\u0001=\")1l\u0003a\u0001q\u00059Q\r_3dkR,Gc\u00014\u0002\u0012!)Q\f\u0004a\u0001=\":\u0001!!\u0006\u0002\u001c\u0005u\u0001cA\u000f\u0002\u0018%\u0019\u0011\u0011\u0004\u0010\u0003!M+\b\u000f\u001d:fgN<\u0016M\u001d8j]\u001e\u001c\u0018!\u0002<bYV,GFAA\u0010C\t\t\t#A\u0007Ok2d\u0007+\u0019:b[\u0016$XM\u001d\u0015\b\u0001\u0005\u0015\u0012\u0011GA\u001a!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016[\u0005)!/\u001e7fg&!\u0011qFA\u0015\u00051\u0019F/\u001a9NKR\fG-\u0019;b\u0003\u0011q\u0017-\\3\"\u0005\u0005U\u0012\u0001B:z]\u000e\u0004")
public class SyncStep
implements BaseSourceStep {
    private final ConfigurationItem configurationItem;
    private final Option<String> branchName;

    @Override
    public BaseSource fetchCompleteCi(String id) {
        return BaseSourceStep.fetchCompleteCi$(this, id);
    }

    @Override
    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Source synchronization";
    }

    private BaseSource createAndStartSync(String id, ExecutionContext ctx) {
        None$ none$;
        BaseSource completeCi;
        ctx.logOutput("Started synchronizing stitch source [" + id + "]");
        BaseSource baseSource = completeCi = this.fetchCompleteCi(id);
        if (baseSource instanceof GitSource) {
            GitSource gitSource = (GitSource)baseSource;
            ctx.logOutput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Source URL [" + gitSource.repositoryUrl() + "], on [" + this.branchName.getOrElse((Function0 & Serializable)() -> (String)Option$.MODULE$.apply((Object)gitSource.masterBranchName()).getOrElse((Function0 & Serializable)() -> "/")) + "]\n             |Fetching repository...")));
        } else if (baseSource instanceof FolderSource) {
            FolderSource folderSource = (FolderSource)baseSource;
            ctx.logOutput("Source path [" + FileUtil$.MODULE$.getAbsolutePathAsString(folderSource.path()) + "]");
        } else {
            throw new MatchError((Object)baseSource);
        }
        SourceSyncStateService sourceSyncStateService = StitchServiceHolder$.MODULE$.getSourceSyncStateService();
        sourceSyncStateService.create(Predef$.MODULE$.Integer2int(completeCi.get$internalId()), this.branchName);
        ITask iTask = ctx.getTask();
        if (iTask != null) {
            ITask iTask2 = iTask;
            none$ = new Some((Object)iTask2.getId());
        } else {
            none$ = None$.MODULE$;
        }
        None$ syncTaskId = none$;
        sourceSyncStateService.startSync(Predef$.MODULE$.Integer2int(completeCi.get$internalId()), (Option<String>)syncTaskId, this.branchName);
        return completeCi;
    }

    private StepExitCode handleSync(String id, BaseSource completeCi, ExecutionContext ctx) {
        boolean bl = false;
        Failure failure = null;
        Try<Object> try_ = StitchServiceHolder$.MODULE$.getSourceSyncService().sync(completeCi, this.branchName, (Option<ExecutionContext>)Option$.MODULE$.apply((Object)ctx));
        if (try_ instanceof Success) {
            return this.handleSuccess("Completed synchronizing stitch source [" + id + "]", ctx);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof ParallelSyncOccurredException) {
                return this.handleSuccess("Skipping synchronizing stitch source [" + id + "] - another sync is already in progress for this source", ctx);
            }
        }
        if (bl) {
            Throwable exception = failure.exception();
            return this.failSync(exception, ctx, id);
        }
        throw new MatchError(try_);
    }

    private StepExitCode handleFail(Throwable exception, ExecutionContext ctx, String id) {
        ctx.logError("Failed synchronizing stitch source [" + id + "]");
        ctx.logError("Reason: " + exception.getMessage());
        return StepExitCode.FAIL;
    }

    private StepExitCode handleSuccess(String message, ExecutionContext ctx) {
        ctx.logOutput(message);
        return StepExitCode.SUCCESS;
    }

    private StepExitCode failSync(Throwable exception, ExecutionContext ctx, String id) {
        BaseSource completeCi = this.fetchCompleteCi(id);
        StitchServiceHolder$.MODULE$.getSourceSyncStateService().failSync(Predef$.MODULE$.Integer2int(completeCi.get$internalId()), exception.getMessage(), ExceptionUtils.getStackTrace((Throwable)exception), this.branchName);
        return this.handleFail(exception, ctx, id);
    }

    public StepExitCode execute(ExecutionContext ctx) {
        String id = this.configurationItem.getId();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.createAndStartSync(id, ctx));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BaseSource completeCi = (BaseSource)success.value();
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> this.handleSync(id, completeCi, ctx));
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                StepExitCode value = (StepExitCode)success2.value();
                return value;
            }
            if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable ex = failure.exception();
                return this.failSync(ex, ctx, id);
            }
            throw new MatchError((Object)try_2);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return this.failSync(e, ctx, id);
        }
        throw new MatchError((Object)try_);
    }

    public SyncStep(ConfigurationItem configurationItem, Option<String> branchName) {
        this.configurationItem = configurationItem;
        this.branchName = branchName;
        BaseSourceStep.$init$(this);
    }

    public SyncStep() {
        this(null, (Option<String>)None$.MODULE$);
    }
}

