/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.functions;

import com.hierynomus.ntlm.NtlmException;
import com.hierynomus.ntlm.functions.NtlmFunctions;
import com.hierynomus.security.Cipher;
import com.hierynomus.security.SecurityException;
import com.hierynomus.security.SecurityProvider;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Random;

class NtlmV1Functions {
    static final byte[] LMOWFv1_SECRET = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    private SecurityProvider securityProvider;

    public NtlmV1Functions(Random random, SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public byte[] NTOWFv1(String password, String username, String userDomain) {
        return NtlmFunctions.md4(this.securityProvider, NtlmFunctions.unicode(password));
    }

    public byte[] LMOWFv1(String password, String username, String userDomain) {
        try {
            byte[] bytes = password.toUpperCase().getBytes("US-ASCII");
            if (bytes.length != 14) {
                bytes = Arrays.copyOf(bytes, 14);
            }
            Cipher leftCipher = NtlmFunctions.getDESCipher(this.securityProvider, Arrays.copyOfRange(bytes, 0, 7));
            Cipher rightCipher = NtlmFunctions.getDESCipher(this.securityProvider, Arrays.copyOfRange(bytes, 7, 14));
            byte[] lmHash = new byte[16];
            int outOff = leftCipher.update(LMOWFv1_SECRET, 0, LMOWFv1_SECRET.length, lmHash, 0);
            outOff += leftCipher.doFinal(lmHash, outOff);
            outOff += rightCipher.update(LMOWFv1_SECRET, 0, LMOWFv1_SECRET.length, lmHash, outOff);
            if ((outOff += rightCipher.doFinal(lmHash, outOff)) != 16) {
                throw new NtlmException("Incorrect lmHash calculated");
            }
            return lmHash;
        }
        catch (SecurityException | UnsupportedEncodingException e) {
            throw new NtlmException(e);
        }
    }
}

