/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.settings.GeneralSettings;
import ai.digital.deploy.sql.model.CreatePersonalAccessTokenForm;
import ai.digital.deploy.sql.model.UserTokensView;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.XldUserTokenService;
import com.xebialabs.deployit.core.rest.api.AbstractUserRestrictedResource;
import com.xebialabs.deployit.core.rest.api.XldUserTokenService$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.service.GeneralSettingsService;
import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.service.UserTokenService;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\b\u0011\u0001uA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011%A\u0006\u00011AA\u0002\u0013\u0005\u0011\fC\u0005e\u0001\u0001\u0007\t\u0019!C\u0001K\"Ia\u000e\u0001a\u0001\u0002\u0003\u0006KA\u0017\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002\b\u0002!\t%!#\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\n9\u0002\f\u001c3Vg\u0016\u0014Hk\\6f]N+'O^5dK&k\u0007\u000f\u001c\u0006\u0003#I\t1!\u00199j\u0015\t\u0019B#\u0001\u0003sKN$(BA\u000b\u0017\u0003\u0011\u0019wN]3\u000b\u0005]A\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005eQ\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0012aA2p[\u000e\u00011c\u0001\u0001\u001fEA\u0011q\u0004I\u0007\u0002!%\u0011\u0011\u0005\u0005\u0002\u001f\u0003\n\u001cHO]1diV\u001bXM\u001d*fgR\u0014\u0018n\u0019;fIJ+7o\\;sG\u0016\u0004\"aI\u0013\u000e\u0003\u0011R!!\u0005\u000b\n\u0005\u0019\"#a\u0005-mIV\u001bXM\u001d+pW\u0016t7+\u001a:wS\u000e,\u0017\u0001E;tKJ$vn[3o'\u0016\u0014h/[2f!\tIc&D\u0001+\u0015\tYC&A\u0004tKJ4\u0018nY3\u000b\u000552\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005=R#\u0001E+tKJ$vn[3o'\u0016\u0014h/[2f\u0003-)8/\u001a:TKJ4\u0018nY3\u0011\u0005I\u001aT\"\u0001\u0017\n\u0005Qb#aC+tKJ\u001cVM\u001d<jG\u0016\fQ\u0003\u001d:j]\u000eL\u0007/\u00197ECR\f\u0007K]8wS\u0012,'\u000f\u0005\u00028u5\t\u0001H\u0003\u0002:Y\u0005i\u0001O]5oG&\u0004\u0018\r\u001c3bi\u0006L!a\u000f\u001d\u0003+A\u0013\u0018N\\2ja\u0006dG)\u0019;b!J|g/\u001b3fe\u00061r-\u001a8fe\u0006d7+\u001a;uS:<7oU3sm&\u001cW\r\u0005\u0002?\u00016\tqH\u0003\u0002,)%\u0011\u0011i\u0010\u0002\u0017\u000f\u0016tWM]1m'\u0016$H/\u001b8hgN+'O^5dK\u00061A(\u001b8jiz\"R\u0001R#G\u000f\"\u0003\"a\b\u0001\t\u000b\u001d*\u0001\u0019\u0001\u0015\t\u000bA*\u0001\u0019A\u0019\t\u000bU*\u0001\u0019\u0001\u001c\t\u000bq*\u0001\u0019A\u001f)\u0005\u0015Q\u0005CA&W\u001b\u0005a%BA'O\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u001fB\u000bqAZ1di>\u0014\u0018P\u0003\u0002R%\u0006)!-Z1og*\u00111\u000bV\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ+A\u0002pe\u001eL!a\u0016'\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u0003:fgB|gn]3\u0016\u0003i\u0003\"a\u00172\u000e\u0003qS!!\u00180\u0002\u0007M\u0004\u0018N\u0003\u0002`A\u0006A!/Z:uK\u0006\u001c\u0018P\u0003\u0002b)\u0006)!NY8tg&\u00111\r\u0018\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\re\u0016\u001c\bo\u001c8tK~#S-\u001d\u000b\u0003M2\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014A!\u00168ji\"9QnBA\u0001\u0002\u0004Q\u0016a\u0001=%c\u0005I!/Z:q_:\u001cX\r\t\u0015\u0003\u0011A\u0004\"!]=\u000e\u0003IT!!F:\u000b\u0005Q,\u0018A\u0001:t\u0015\t1x/\u0001\u0002xg*\t\u00010A\u0004kC.\f'\u000f^1\n\u0005i\u0014(aB\"p]R,\u0007\u0010^\u0001\u000eO\u0016$Xk]3s)>\\WM\\:\u0015\u000fu\f9\"!\f\u00028A\u0019a0a\u0005\u000e\u0003}TA!!\u0001\u0002\u0004\u0005)Qn\u001c3fY*!\u0011QAA\u0004\u0003\r\u0019\u0018\u000f\u001c\u0006\u0005\u0003\u0013\tY!\u0001\u0004eKBdw.\u001f\u0006\u0005\u0003\u001b\ty!A\u0004eS\u001eLG/\u00197\u000b\u0005\u0005E\u0011AA1j\u0013\r\t)b \u0002\u000f+N,'\u000fV8lK:\u001ch+[3x\u0011\u001d\tI\"\u0003a\u0001\u00037\ta\u0001]1hS:<\u0007\u0003BA\u000f\u0003Si!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0004IR|'bA\t\u0002&)\u0019\u0011q\u0005\f\u0002\r\u0015tw-\u001b8f\u0013\u0011\tY#a\b\u0003\rA\u000bw-\u001b8h\u0011\u001d\ty#\u0003a\u0001\u0003c\tQa\u001c:eKJ\u0004B!!\b\u00024%!\u0011QGA\u0010\u0005!y%\u000fZ3sS:<\u0007bBA\u001d\u0013\u0001\u0007\u00111H\u0001\ni>\\WM\u001c(pi\u0016\u0004B!!\u0010\u0002L9!\u0011qHA$!\r\t\t\u0005[\u0007\u0003\u0003\u0007R1!!\u0012\u001d\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\n5\u0002\rA\u0013X\rZ3g\u0013\u0011\ti%a\u0014\u0003\rM#(/\u001b8h\u0015\r\tI\u0005[\u0001\u0015O\u0016$Hk\\6f]N4uN]+tKJt\u0017-\\3\u0015\u0013u\f)&!\u0017\u0002\\\u0005u\u0003bBA,\u0015\u0001\u0007\u00111H\u0001\tkN,'O\\1nK\"9\u0011\u0011\u0004\u0006A\u0002\u0005m\u0001bBA\u0018\u0015\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003sQ\u0001\u0019AA\u001e\u0003E9WM\\3sCR,Wk]3s)>\\WM\u001c\u000b\u0004{\u0006\r\u0004bBA3\u0017\u0001\u0007\u0011qM\u0001\u000ekN,'\u000fV8lK:4uN]7\u0011\u0007y\fI'C\u0002\u0002l}\u0014Qd\u0011:fCR,\u0007+\u001a:t_:\fG.Q2dKN\u001cHk\\6f]\u001a{'/\\\u0001!I\u0016dW\r^3Vg\u0016\u0014Hk\\6f]\nKXk]3s]\u0006lW-\u00118e\u0007&LE\rF\u0003g\u0003c\n\u0019\bC\u0004\u0002X1\u0001\r!a\u000f\t\u000f\u0005UD\u00021\u0001\u0002x\u0005!1-[%e!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA\u0001\\1oO*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006m$aB%oi\u0016<WM]\u0001\u0016I\u0016dW\r^3Vg\u0016\u0014Hk\\6f]\nK8)[%e)\r1\u00171\u0012\u0005\b\u0003kj\u0001\u0019AA<\u0003M9W\r^+tKJt\u0017-\\3G_J$vn[3o)\u0011\tY$!%\t\u000f\u0005Me\u00021\u0001\u0002<\u0005)Ao\\6f]\"\u001a\u0001!a&\u0011\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(S\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003C\u000bYJ\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class XldUserTokenServiceImpl
extends AbstractUserRestrictedResource
implements XldUserTokenService {
    private final UserTokenService userTokenService;
    private final UserService userService;
    private final PrincipalDataProvider principalDataProvider;
    private final GeneralSettingsService generalSettingsService;
    @Context
    private HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    public void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public UserTokensView getUserTokens(Paging paging, Ordering order, String tokenNote) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(authentication.getName(), paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(authentication.getName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        int countUserToken = this.userTokenService.countUserTokens(authentication.getName());
        PaginationSupport$.MODULE$.addTotalCountHeader((long)countUserToken, this.response());
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView getTokensForUsername(String username, Paging paging, Ordering order, String tokenNote) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(username, paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(username, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        boolean personalAccessTokenSupported;
        boolean bl;
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        try {
            this.userService.read(username);
            bl = true;
        }
        catch (NotFoundException notFoundException) {
            bl = false;
        }
        boolean user = bl;
        GeneralSettings generalSettings = this.generalSettingsService.getGeneralSettings();
        boolean bl2 = personalAccessTokenSupported = generalSettings.patEnableForSSO() || userData.isFound() || user;
        if (!personalAccessTokenSupported) {
            throw new Checks.IncorrectArgumentException("Personal access tokens are only supported for internal users and external users authenticated via LDAP", new Object[0]);
        }
        Checks.checkArgument((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(userTokenForm.tokenNote())), (String)"Note can't be blank", (Object[])new Object[0]);
        boolean isValidExpiryDate = userTokenForm.expiryDate() != null ? userTokenForm.expiryDate().getTime() > System.currentTimeMillis() : true;
        Checks.checkArgument((boolean)isValidExpiryDate, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.tokenNote().trim();
        userTokenForm.tokenNote_$eq(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        Checks.checkArgument((!xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$generateUserToken$1(userTokenForm, token))) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
        XldUserToken userTokens = this.userTokenService.createUserToken(username, userTokenForm.tokenNote(), userTokenForm.expiryDate());
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenViewForCreateToken((Tokens)tokens))).asJava());
    }

    public void deleteUserTokenByUsernameAndCiId(String username, Integer ciId) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        this.userTokenService.deleteUserToken(username, ciId);
    }

    public void deleteUserTokenByCiId(Integer ciId) {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        if (xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$deleteUserTokenByCiId$1(ciId, token)))) {
            this.userTokenService.deleteUserToken(username, ciId);
            return;
        }
        throw new Checks.IncorrectArgumentException("Personal access token ciId[" + ciId + "] does not belong to user[" + username + "]", new Object[0]);
    }

    public String getUsernameForToken(String token) {
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        XldUserToken userToken = this.userTokenService.findByUserToken(tokenHash);
        XldUserToken xldUserToken = userToken;
        if (xldUserToken == null) {
            throw new NotFoundException("Token not found: " + token, new Object[0]);
        }
        return userToken.username();
    }

    public static final /* synthetic */ boolean $anonfun$generateUserToken$1(CreatePersonalAccessTokenForm userTokenForm$1, Tokens token) {
        String string = token.tokenNote();
        String string2 = userTokenForm$1.tokenNote();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteUserTokenByCiId$1(Integer ciId$1, Tokens token) {
        Integer n = token.ciId();
        Integer n2 = ciId$1;
        return !(n != null ? !((Object)n).equals(n2) : n2 != null);
    }

    @Autowired
    public XldUserTokenServiceImpl(UserTokenService userTokenService, UserService userService, PrincipalDataProvider principalDataProvider, GeneralSettingsService generalSettingsService) {
        this.userTokenService = userTokenService;
        this.userService = userService;
        this.principalDataProvider = principalDataProvider;
        this.generalSettingsService = generalSettingsService;
    }
}

