/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileSystemException;

public final class DefaultURLConnection
extends URLConnection {
    private final FileContent fileContent;

    public DefaultURLConnection(URL url, FileContent fileContent) {
        super(url);
        this.fileContent = fileContent;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public String getContentEncoding() {
        return (String)Uncheck.get(() -> this.fileContent.getContentInfo().getContentEncoding());
    }

    @Override
    public int getContentLength() {
        try {
            return (int)this.fileContent.getSize();
        }
        catch (FileSystemException fse) {
            return -1;
        }
    }

    @Override
    public String getContentType() {
        return (String)Uncheck.get(() -> this.fileContent.getContentInfo().getContentType());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileContent.getInputStream();
    }

    @Override
    public long getLastModified() {
        try {
            return this.fileContent.getLastModifiedTime();
        }
        catch (FileSystemException ignored) {
            return -1L;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.fileContent.getOutputStream();
    }
}

