/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.AbstractUpdateOrDeleteStatement;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class SimpleDeleteQueryPlan
implements NonSelectQueryPlan {
    private final EntityMappingType entityDescriptor;
    private final SqmDeleteStatement<?> sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private JdbcOperationQueryMutation jdbcOperation;
    private SqmTranslation<? extends AbstractUpdateOrDeleteStatement> sqmInterpretation;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;

    public SimpleDeleteQueryPlan(EntityMappingType entityDescriptor, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref) {
        assert (entityDescriptor.getEntityName().equals(((SqmRoot)sqmDelete.getTarget()).getEntityName()));
        this.entityDescriptor = entityDescriptor;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        boolean missingRestriction;
        BulkOperationCleanupAction.schedule(executionContext.getSession(), this.sqmDelete);
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<? extends JdbcOperationQueryMutation> sqlAstTranslator = null;
        if (this.jdbcOperation == null) {
            sqlAstTranslator = this.createTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getRuntimeMetamodels().getMappingMetamodel(), this.sqmInterpretation.getFromClauseAccess()::findTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return SimpleDeleteQueryPlan.this.sqmInterpretation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, session);
        if (this.jdbcOperation != null && !this.jdbcOperation.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            sqlAstTranslator = this.createTranslator(executionContext);
        }
        if (sqlAstTranslator != null) {
            this.jdbcOperation = sqlAstTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        }
        boolean bl = missingRestriction = this.sqmInterpretation.getSqlAst().getRestriction() == null;
        if (missingRestriction) {
            assert (this.domainParameterXref.getSqmParameterCount() == 0);
            assert (this.jdbcParamsXref.isEmpty());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext);
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            MutatingTableReferenceGroupWrapper collectionTableGroup = new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference);
            MutableObject additionalPredicate = new MutableObject();
            attributeMapping.applyBaseRestrictions(p -> additionalPredicate.set(Predicate.combinePredicates((Predicate)additionalPredicate.get(), p)), collectionTableGroup, factory.getJdbcServices().getDialect().getDmlTargetColumnQualifierSupport() == DmlTargetColumnQualifierSupport.TABLE_ALIAS, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, null);
            if (missingRestriction) {
                return (Predicate)additionalPredicate.get();
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            Expression fkColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression(collectionTableGroup, fkDescriptor.getKeyPart(), null, factory);
            QuerySpec matchingIdSubQuery = new QuerySpec(false);
            MutatingTableReferenceGroupWrapper tableGroup = new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, this.sqmInterpretation.getSqlAst().getTargetTable());
            Expression fkTargetColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression(tableGroup, fkDescriptor.getTargetPart(), this.sqmInterpretation.getSqlExpressionResolver(), factory);
            matchingIdSubQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, fkTargetColumnExpression));
            matchingIdSubQuery.getFromClause().addRoot(tableGroup);
            matchingIdSubQuery.applyPredicate(this.sqmInterpretation.getSqlAst().getRestriction());
            return Predicate.combinePredicates((Predicate)additionalPredicate.get(), new InSubQueryPredicate(fkColumnExpression, matchingIdSubQuery, false));
        }, missingRestriction ? JdbcParameterBindings.NO_BINDINGS : jdbcParameterBindings, executionContextAdapter);
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcOperation, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContextAdapter);
    }

    protected SqlAstTranslator<? extends JdbcOperationQueryMutation> createTranslator(DomainQueryExecutionContext executionContext) {
        MutationStatement ast;
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        SqmTranslator<? extends MutationStatement> translator = factory.getQueryEngine().getSqmTranslatorFactory().createMutationTranslator(this.sqmDelete, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), factory);
        this.sqmInterpretation = translator.translate();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, this.sqmInterpretation::getJdbcParamsBySqmParam);
        if (this.entityDescriptor.getSoftDeleteMapping() == null) {
            ast = this.sqmInterpretation.getSqlAst();
        } else {
            AbstractUpdateOrDeleteStatement sqlDeleteAst = this.sqmInterpretation.getSqlAst();
            NamedTableReference targetTable = sqlDeleteAst.getTargetTable();
            SoftDeleteMapping columnMapping = this.getEntityDescriptor().getSoftDeleteMapping();
            ColumnReference columnReference = new ColumnReference(targetTable, (SelectableMapping)columnMapping);
            JdbcLiteral<Object> jdbcLiteral = new JdbcLiteral<Object>(columnMapping.getDeletedLiteralValue(), columnMapping.getJdbcMapping());
            Assignment assignment = new Assignment(columnReference, jdbcLiteral);
            ast = new UpdateStatement(targetTable, Collections.singletonList(assignment), sqlDeleteAst.getRestriction());
        }
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildMutationTranslator(factory, ast);
    }
}

