/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.ProxyUtils;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface TypeInformation<S> {
    public static final TypeInformation<Collection> COLLECTION = new ClassTypeInformation<Collection>(Collection.class);
    public static final TypeInformation<List> LIST = new ClassTypeInformation<List>(List.class);
    public static final TypeInformation<Set> SET = new ClassTypeInformation<Set>(Set.class);
    public static final TypeInformation<Map> MAP = new ClassTypeInformation<Map>(Map.class);
    public static final TypeInformation<Object> OBJECT = new ClassTypeInformation<Object>(Object.class);

    public static TypeInformation<?> of(ResolvableType type) {
        Assert.notNull((Object)type, (String)"Type must not be null");
        return type.hasGenerics() || type.isArray() && type.getComponentType().hasGenerics() || type.getType() instanceof TypeVariable ? TypeDiscoverer.ofCached(type) : ClassTypeInformation.from(type);
    }

    public static <S> TypeInformation<S> of(Class<S> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return ClassTypeInformation.from(type);
    }

    public static TypeInformation<?> fromReturnTypeOf(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        return TypeInformation.fromReturnTypeOf(method, null);
    }

    public static TypeInformation<?> fromReturnTypeOf(Method method, @Nullable Class<?> type) {
        ResolvableType intermediate = type == null ? ResolvableType.forMethodReturnType((Method)method) : ResolvableType.forMethodReturnType((Method)method, type);
        return TypeInformation.of(intermediate);
    }

    public static TypeInformation<?> fromMethodParameter(MethodParameter parameter) {
        return TypeInformation.of(ResolvableType.forMethodParameter((MethodParameter)parameter));
    }

    public List<TypeInformation<?>> getParameterTypes(Constructor<?> var1);

    @Nullable
    public TypeInformation<?> getProperty(String var1);

    default public TypeInformation<?> getRequiredProperty(String property) {
        TypeInformation<?> typeInformation = this.getProperty(property);
        if (typeInformation != null) {
            return typeInformation;
        }
        throw new IllegalArgumentException(String.format("Could not find required property %s on %s", property, this.getType()));
    }

    public boolean isCollectionLike();

    @Nullable
    public TypeInformation<?> getComponentType();

    default public TypeInformation<?> getRequiredComponentType() {
        TypeInformation<?> componentType = this.getComponentType();
        if (componentType != null) {
            return componentType;
        }
        throw new IllegalStateException(String.format("Can't resolve required component type for %s", this.getType()));
    }

    public boolean isMap();

    @Nullable
    public TypeInformation<?> getMapValueType();

    default public TypeInformation<?> getRequiredMapValueType() {
        TypeInformation<?> mapValueType = this.getMapValueType();
        if (mapValueType != null) {
            return mapValueType;
        }
        throw new IllegalStateException(String.format("Can't resolve required map value type for %s", this.getType()));
    }

    public Class<S> getType();

    default public TypeInformation<?> getUserTypeInformation() {
        Class<?> userType = ProxyUtils.getUserClass(this.getType());
        return userType.equals(this.getType()) ? this : TypeInformation.of(userType);
    }

    public TypeInformation<?> getRawTypeInformation();

    @Nullable
    public TypeInformation<?> getActualType();

    default public TypeInformation<?> getRequiredActualType() {
        TypeInformation<?> result = this.getActualType();
        if (result == null) {
            throw new IllegalStateException("Expected to be able to resolve a type but got null; This usually stems from types implementing raw Map or Collection interfaces");
        }
        return result;
    }

    public TypeInformation<?> getReturnType(Method var1);

    public List<TypeInformation<?>> getParameterTypes(Method var1);

    @Nullable
    public TypeInformation<?> getSuperTypeInformation(Class<?> var1);

    default public TypeInformation<?> getRequiredSuperTypeInformation(Class<?> superType) {
        TypeInformation<?> result = this.getSuperTypeInformation(superType);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve super type information for %s; Does current type really implement the given one", superType));
        }
        return result;
    }

    public boolean isAssignableFrom(TypeInformation<?> var1);

    public List<TypeInformation<?>> getTypeArguments();

    default public TypeInformation<? extends S> specialize(TypeInformation<?> type) {
        return type;
    }

    default public boolean isSubTypeOf(Class<?> type) {
        return !type.equals(this.getType()) && type.isAssignableFrom(this.getType());
    }

    public TypeDescriptor toTypeDescriptor();
}

