/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.resteasy.concurrent.ContextualScheduledExecutorService;
import org.jboss.resteasy.concurrent.ContextualThreadFactory;
import org.jboss.resteasy.concurrent.SecurityActions;

class GlobalContextualScheduledExecutorService
extends ContextualScheduledExecutorService
implements AutoCloseable {
    static final GlobalContextualScheduledExecutorService INSTANCE = new GlobalContextualScheduledExecutorService();
    private final Thread shutdownHook = new Thread("resteasy-shutdown"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GlobalContextualScheduledExecutorService globalContextualScheduledExecutorService = GlobalContextualScheduledExecutorService.this;
            synchronized (globalContextualScheduledExecutorService) {
                if (GlobalContextualScheduledExecutorService.this.delegate != null) {
                    GlobalContextualScheduledExecutorService.this.delegate.shutdown();
                    GlobalContextualScheduledExecutorService.this.delegate = null;
                }
            }
        }
    };
    private volatile ScheduledExecutorService delegate;

    private GlobalContextualScheduledExecutorService() {
        super(null, true);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ScheduledExecutorService getDelegate() {
        if (this.delegate == null) {
            GlobalContextualScheduledExecutorService globalContextualScheduledExecutorService = this;
            synchronized (globalContextualScheduledExecutorService) {
                if (this.delegate == null) {
                    int poolSize = SecurityActions.getCoreThreads("resteasy.async.timeout.scheduler.min.pool.size");
                    this.delegate = Executors.newScheduledThreadPool(poolSize, new ContextualThreadFactory("contextual-scheduled-pool"));
                    SecurityActions.registerShutdownHook(this.shutdownHook);
                }
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GlobalContextualScheduledExecutorService globalContextualScheduledExecutorService = this;
        synchronized (globalContextualScheduledExecutorService) {
            SecurityActions.removeShutdownHook(this.shutdownHook);
            if (this.delegate != null) {
                this.delegate.shutdown();
                this.delegate = null;
            }
        }
    }
}

