/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser$;
import org.apache.pekko.http.impl.engine.parsing.HttpRequestParser$;
import org.apache.pekko.http.impl.engine.parsing.NotEnoughDataException$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$StreamEnd$;
import org.apache.pekko.http.impl.engine.parsing.ParsingException;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.engine.server.HttpAttributes;
import org.apache.pekko.http.impl.engine.ws.Handshake$Server$;
import org.apache.pekko.http.impl.engine.ws.UpgradeToWebSocketLowLevel;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.UriParser;
import org.apache.pekko.http.impl.util.ByteStringParserInput;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpCharsets$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.IllegalUriException;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.SslSessionInfo;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.UniversalEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.WebSocketSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.parboiled2.ParserInput;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ma!B\b\u0011\u0005Yq\u0002\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\")q\u000b\u0001C\u00011\"9a\f\u0001b\u0001\n\u0003y\u0006BB2\u0001A\u0003%\u0001\rC\u0004e\u0001\t\u0007I\u0011A3\t\r%\u0004\u0001\u0015!\u0003g\u0011\u001dQ\u0007A1A\u0005\u0002-Da\u0001\u001c\u0001!\u0002\u00139\u0003\"B7\u0001\t#r\u0007\"\u0002:\u0001\t\u0003\u001a\b\"B=\u0001\t\u0003R(!\u0005%uiB\u0014V-];fgR\u0004\u0016M]:fe*\u0011\u0011CE\u0001\ba\u0006\u00148/\u001b8h\u0015\t\u0019B#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003+Y\tA![7qY*\u0011q\u0003G\u0001\u0005QR$\bO\u0003\u0002\u001a5\u0005)\u0001/Z6l_*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h'\t\u0001q\u0004E\u0002!K\u001dj\u0011!\t\u0006\u0003E\r\nQa\u001d;bO\u0016T!\u0001\n\r\u0002\rM$(/Z1n\u0013\t1\u0013E\u0001\u0006He\u0006\u0004\bn\u0015;bO\u0016\u0004B\u0001K\u0015,o5\t1%\u0003\u0002+G\tIa\t\\8x'\"\f\u0007/\u001a\t\u0003YQr!!\f\u001a\u000f\u00059\ndBA\u00181\u001b\u0005Q\u0012BA\r\u001b\u0013\t!\u0003$\u0003\u00024G\u0005YA\u000bT*Qe>$xnY8m\u0013\t)dG\u0001\u0007TKN\u001c\u0018n\u001c8CsR,7O\u0003\u00024GA\u0011\u0001\b\u0010\b\u0003sij\u0011\u0001E\u0005\u0003wA\tA\u0002U1sg\u0016\u0014x*\u001e;qkRL!!\u0010 \u0003\u001bI+\u0017/^3ti>+H\u000f];u\u0015\tY\u0004#\u0001\u0005tKR$\u0018N\\4t\u0007\u0001\u0001\"A\u0011$\u000e\u0003\rS!a\u0010#\u000b\u0005\u00153\u0012\u0001C:dC2\fGm\u001d7\n\u0005\u001d\u001b%A\u0004)beN,'oU3ui&twm]\u0001\u0012o\u0016\u00147o\\2lKR\u001cV\r\u001e;j]\u001e\u001c\bC\u0001\"K\u0013\tY5IA\tXK\n\u001cvnY6fiN+G\u000f^5oON\f1C]1x%\u0016\fX/Z:u+JL\u0007*Z1eKJ\u0004\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013qAQ8pY\u0016\fg.\u0001\u0007iK\u0006$WM\u001d)beN,'\u000f\u0005\u0002:+&\u0011a\u000b\u0005\u0002\u0011\u0011R$\b\u000fS3bI\u0016\u0014\b+\u0019:tKJ\fa\u0001P5oSRtD#B-[7rk\u0006CA\u001d\u0001\u0011\u0015yT\u00011\u0001B\u0011\u0015AU\u00011\u0001J\u0011\u0015aU\u00011\u0001N\u0011\u0015\u0019V\u00011\u0001U\u0003\tIg.F\u0001a!\rA\u0013mK\u0005\u0003E\u000e\u0012Q!\u00138mKR\f1!\u001b8!\u0003\ryW\u000f^\u000b\u0002MB\u0019\u0001fZ\u001c\n\u0005!\u001c#AB(vi2,G/\u0001\u0003pkR\u0004\u0013!B:iCB,W#A\u0014\u0002\rMD\u0017\r]3!\u0003EIg.\u001b;jC2\fE\u000f\u001e:jEV$Xm]\u000b\u0002_B\u0011\u0001\u0006]\u0005\u0003c\u000e\u0012!\"\u0011;ue&\u0014W\u000f^3t\u0003-\u0019'/Z1uK2{w-[2\u0015\u0005Q<\bC\u0001\u0011v\u0013\t1\u0018EA\bHe\u0006\u0004\bn\u0015;bO\u0016dunZ5d\u0011\u0015AX\u00021\u0001p\u0003MIg\u000e[3sSR,G-\u0011;ue&\u0014W\u000f^3t\u0003!!xn\u0015;sS:<G#A>\u0011\u0007q\f9AD\u0002~\u0003\u0007\u0001\"A`(\u000e\u0003}T1!!\u0001A\u0003\u0019a$o\\8u}%\u0019\u0011QA(\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\u0003\u0003\rM#(/\u001b8h\u0015\r\t)a\u0014\u0015\u0004\u0001\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005U\u0001$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0014\tY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public final class HttpRequestParser
extends GraphStage<FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput>> {
    public final ParserSettings org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings;
    public final WebSocketSettings org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$websocketSettings;
    public final boolean org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader;
    public final HttpHeaderParser org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$headerParser;
    private final Inlet<TLSProtocol.SessionBytes> in;
    private final Outlet<ParserOutput.RequestOutput> out;
    private final FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput> shape;

    public Inlet<TLSProtocol.SessionBytes> in() {
        return this.in;
    }

    public Outlet<ParserOutput.RequestOutput> out() {
        return this.out;
    }

    public FlowShape<TLSProtocol.SessionBytes, ParserOutput.RequestOutput> shape() {
        return this.shape;
    }

    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("HttpRequestParser");
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new HttpMessageParser<ParserOutput.RequestOutput>(this, inheritedAttributes){
            private final ParserSettings settings;
            private final HttpHeaderParser headerParser;
            private final boolean isResponseParser;
            private HttpMethod method;
            private Uri uri;
            private ByteString uriBytes;
            private final UriParser uriParser;
            private Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
            private Function1<ByteString, HttpMessageParser.StateResult> org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
            private HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
            private Function0<Option<ParserOutput.ErrorOutput>> completionHandling;
            private boolean terminated;
            private SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            private Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            private final /* synthetic */ HttpRequestParser $outer;
            private final Attributes inheritedAttributes$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            public final ListBuffer<HttpHeader> initialHeaderBuffer() {
                return HttpMessageParser.initialHeaderBuffer$(this);
            }

            public final ParserOutput parseSessionBytes(TLSProtocol.SessionBytes input) {
                return HttpMessageParser.parseSessionBytes$(this, input);
            }

            public final ParserOutput parseBytes(ByteString input) {
                return HttpMessageParser.parseBytes$(this, input);
            }

            public final ParserOutput doPull() {
                return HttpMessageParser.doPull$(this);
            }

            public final boolean shouldComplete() {
                return HttpMessageParser.shouldComplete$(this);
            }

            public final HttpMessageParser.StateResult startNewMessage(ByteString input, int offset) {
                return HttpMessageParser.startNewMessage$(this, input, offset);
            }

            public final int parseProtocol(ByteString input, int cursor) {
                return HttpMessageParser.parseProtocol$(this, input, cursor);
            }

            public final HttpMessageParser.StateResult parseHeaderLines(ByteString input, int lineStart, ListBuffer<HttpHeader> headers2, int headerCount, Option<Connection> ch, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean e100c, boolean hh) {
                return HttpMessageParser.parseHeaderLines$(this, input, lineStart, headers2, headerCount, ch, clh, cth, isChunked, e100c, hh);
            }

            public final HttpMessageParser.StateResult parseFixedLengthBody(long remainingBodyBytes, boolean isLastMessage, ByteString input, int bodyStart) {
                return HttpMessageParser.parseFixedLengthBody$(this, remainingBodyBytes, isLastMessage, input, bodyStart);
            }

            public final HttpMessageParser.StateResult parseChunk(ByteString input, int offset, boolean isLastMessage, long totalBytesRead) {
                return HttpMessageParser.parseChunk$(this, input, offset, isLastMessage, totalBytesRead);
            }

            public void emit(ParserOutput output) {
                HttpMessageParser.emit$(this, output);
            }

            public final HttpMessageParser.StateResult continue(ByteString input, int offset, Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
                return HttpMessageParser.continue$(this, input, offset, next);
            }

            public final HttpMessageParser.StateResult continue(Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
                return HttpMessageParser.continue$(this, next);
            }

            public final HttpMessageParser.StateResult failMessageStart(String summary) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary);
            }

            public final HttpMessageParser.StateResult failMessageStart(String summary, String detail) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary, detail);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status, String summary, String detail) {
                return HttpMessageParser.failMessageStart$(this, status, summary, detail);
            }

            public final String failMessageStart$default$3() {
                return HttpMessageParser.failMessageStart$default$3$(this);
            }

            public final HttpMessageParser.StateResult failMessageStart(StatusCode status, ErrorInfo info) {
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status, info);
            }

            public final HttpMessageParser.StateResult failEntityStream(String summary) {
                return HttpMessageParser.failEntityStream$((HttpMessageParser)this, summary);
            }

            public final HttpMessageParser.StateResult failEntityStream(String summary, String detail) {
                return HttpMessageParser.failEntityStream$(this, summary, detail);
            }

            public final HttpMessageParser.StateResult failEntityStream(ErrorInfo info) {
                return HttpMessageParser.failEntityStream$((HttpMessageParser)this, info);
            }

            public final HttpMessageParser.StateResult terminate() {
                return HttpMessageParser.terminate$(this);
            }

            public final ContentType contentType(Option<Content$minusType> cth) {
                return HttpMessageParser.contentType$(this, cth);
            }

            public final ParserOutput.StrictEntityCreator<ParserOutput.RequestOutput, UniversalEntity> emptyEntity(Option<Content$minusType> cth) {
                return HttpMessageParser.emptyEntity$(this, cth);
            }

            public final ParserOutput.StrictEntityCreator<ParserOutput.RequestOutput, UniversalEntity> strictEntity(Option<Content$minusType> cth, ByteString input, int bodyStart, int contentLength) {
                return HttpMessageParser.strictEntity$(this, cth, input, bodyStart, contentLength);
            }

            public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, UniversalEntity> defaultEntity(Option<Content$minusType> cth, long contentLength) {
                return HttpMessageParser.defaultEntity$(this, cth, contentLength);
            }

            public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, RequestEntity> chunkedEntity(Option<Content$minusType> cth) {
                return HttpMessageParser.chunkedEntity$(this, cth);
            }

            public final void setCompletionHandling(Function0<Option<ParserOutput.ErrorOutput>> completionHandling) {
                HttpMessageParser.setCompletionHandling$(this, completionHandling);
            }

            public final ListBuffer<HttpHeader> parseHeaderLines$default$3() {
                return HttpMessageParser.parseHeaderLines$default$3$(this);
            }

            public final int parseHeaderLines$default$4() {
                return HttpMessageParser.parseHeaderLines$default$4$(this);
            }

            public final Option<Connection> parseHeaderLines$default$5() {
                return HttpMessageParser.parseHeaderLines$default$5$(this);
            }

            public final Option<Content$minusLength> parseHeaderLines$default$6() {
                return HttpMessageParser.parseHeaderLines$default$6$(this);
            }

            public final Option<Content$minusType> parseHeaderLines$default$7() {
                return HttpMessageParser.parseHeaderLines$default$7$(this);
            }

            public final boolean parseHeaderLines$default$8() {
                return HttpMessageParser.parseHeaderLines$default$8$(this);
            }

            public final boolean parseHeaderLines$default$9() {
                return HttpMessageParser.parseHeaderLines$default$9$(this);
            }

            public final boolean parseHeaderLines$default$10() {
                return HttpMessageParser.parseHeaderLines$default$10$(this);
            }

            public Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(Object x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result = x$1;
            }

            public Function1<ByteString, HttpMessageParser.StateResult> org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq(Function1<ByteString, HttpMessageParser.StateResult> x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state = x$1;
            }

            public HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocol x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol = x$1;
            }

            public Function0<Option<ParserOutput.ErrorOutput>> completionHandling() {
                return this.completionHandling;
            }

            public void completionHandling_$eq(Function0<Option<ParserOutput.ErrorOutput>> x$1) {
                this.completionHandling = x$1;
            }

            public boolean terminated() {
                return this.terminated;
            }

            public void terminated_$eq(boolean x$1) {
                this.terminated = x$1;
            }

            public SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(SSLSession x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession = x$1;
            }

            public Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() {
                return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
            }

            public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo x$1) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader = x$1;
            }

            public ParserSettings settings() {
                return this.settings;
            }

            public HttpHeaderParser headerParser() {
                return this.headerParser;
            }

            public boolean isResponseParser() {
                return this.isResponseParser;
            }

            public void onPush() {
                TLSProtocol.SessionBytes parseSessionBytes_input = (TLSProtocol.SessionBytes)this.grab(this.$outer.in());
                Object var1_1 = null;
                this.handleParserOutput((ParserOutput.RequestOutput)HttpMessageParser.parseSessionBytes$(this, parseSessionBytes_input));
            }

            public void onPull() {
                this.handleParserOutput((ParserOutput.RequestOutput)HttpMessageParser.doPull$(this));
            }

            public void onUpstreamFinish() {
                if (HttpMessageParser.shouldComplete$(this)) {
                    this.completeStage();
                    return;
                }
                if (this.isAvailable(this.$outer.out())) {
                    this.handleParserOutput((ParserOutput.RequestOutput)HttpMessageParser.doPull$(this));
                    return;
                }
            }

            private void handleParserOutput(ParserOutput.RequestOutput output) {
                if (ParserOutput$StreamEnd$.MODULE$.equals(output)) {
                    this.completeStage();
                    return;
                }
                if (ParserOutput$NeedMoreData$.MODULE$.equals(output)) {
                    this.pull(this.$outer.in());
                    return;
                }
                this.push(this.$outer.out(), output);
            }

            /*
             * WARNING - void declaration
             */
            public HttpMessageParser.StateResult parseMessage(ByteString input2, int offset2) {
                Function1 & Serializable org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq_x$1;
                if (offset2 < input2.length()) {
                    int byteChar_ix;
                    int cursor = this.parseMethod(input2, offset2);
                    cursor = this.parseRequestTarget(input2, cursor);
                    if ((char)(package$.MODULE$.byteAt(input2, cursor = HttpMessageParser.parseProtocol$(this, input2, cursor)) & 0xFF) == '\r' && (char)(package$.MODULE$.byteAt(input2, byteChar_ix = cursor + 1) & 0xFF) == '\n') {
                        void parseHeaderLines_hh;
                        void parseHeaderLines_e100c;
                        void parseHeaderLines_isChunked;
                        void parseHeaderLines_cth;
                        void parseHeaderLines_clh;
                        void parseHeaderLines_ch;
                        void parseHeaderLines_headerCount;
                        void parseHeaderLines_headers;
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        None$ none$ = None$.MODULE$;
                        None$ none$2 = None$.MODULE$;
                        None$ none$3 = None$.MODULE$;
                        boolean bl4 = false;
                        ListBuffer listBuffer = HttpMessageParser.initialHeaderBuffer$(this);
                        int parseHeaderLines_lineStart = cursor + 2;
                        return HttpMessageParser.parseHeaderLines$(this, input2, parseHeaderLines_lineStart, (ListBuffer)parseHeaderLines_headers, (int)parseHeaderLines_headerCount, (Option)parseHeaderLines_ch, (Option)parseHeaderLines_clh, (Option)parseHeaderLines_cth, (boolean)parseHeaderLines_isChunked, (boolean)parseHeaderLines_e100c, (boolean)parseHeaderLines_hh);
                    }
                    if ((char)(package$.MODULE$.byteAt(input2, cursor) & 0xFF) == '\n') {
                        void parseHeaderLines_hh;
                        void parseHeaderLines_e100c;
                        void parseHeaderLines_isChunked;
                        void parseHeaderLines_cth;
                        void parseHeaderLines_clh;
                        void parseHeaderLines_ch;
                        void parseHeaderLines_headerCount;
                        void parseHeaderLines_headers;
                        boolean bl = false;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        None$ none$ = None$.MODULE$;
                        None$ none$4 = None$.MODULE$;
                        None$ none$5 = None$.MODULE$;
                        boolean bl7 = false;
                        ListBuffer listBuffer = HttpMessageParser.initialHeaderBuffer$(this);
                        int parseHeaderLines_lineStart = cursor + 1;
                        return HttpMessageParser.parseHeaderLines$(this, input2, parseHeaderLines_lineStart, (ListBuffer)parseHeaderLines_headers, (int)parseHeaderLines_headerCount, (Option)parseHeaderLines_ch, (Option)parseHeaderLines_clh, (Option)parseHeaderLines_cth, (boolean)parseHeaderLines_isChunked, (boolean)parseHeaderLines_e100c, (boolean)parseHeaderLines_hh);
                    }
                    throw this.onBadProtocol(input2.drop(cursor));
                }
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state = org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq_x$1 = arg_0 -> HttpMessageParser.$anonfun$continue$3((Function2 & Serializable)(input, offset) -> $anon$1.$anonfun$parseMessage$1(this, input, BoxesRunTime.unboxToInt((Object)offset)), arg_0);
                return null;
            }

            /*
             * WARNING - void declaration
             */
            private int parseMethod(ByteString input, int cursor) {
                switch ((char)(package$.MODULE$.byteAt(input, cursor) & 0xFF)) {
                    case 'G': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.GET(), 1, input, cursor);
                    }
                    case 'P': {
                        int byteChar_ix = cursor + 1;
                        switch ((char)(package$.MODULE$.byteAt(input, byteChar_ix) & 0xFF)) {
                            case 'O': {
                                return this.parseMethod$1(HttpMethods$.MODULE$.POST(), 2, input, cursor);
                            }
                            case 'U': {
                                return this.parseMethod$1(HttpMethods$.MODULE$.PUT(), 2, input, cursor);
                            }
                            case 'A': {
                                return this.parseMethod$1(HttpMethods$.MODULE$.PATCH(), 2, input, cursor);
                            }
                        }
                        return this.parseCustomMethod$1(0, new StringBuilder(16), input, cursor);
                    }
                    case 'D': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.DELETE(), 1, input, cursor);
                    }
                    case 'H': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.HEAD(), 1, input, cursor);
                    }
                    case 'O': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.OPTIONS(), 1, input, cursor);
                    }
                    case 'T': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.TRACE(), 1, input, cursor);
                    }
                    case 'C': {
                        return this.parseMethod$1(HttpMethods$.MODULE$.CONNECT(), 1, input, cursor);
                    }
                    case '\u0016': {
                        void apply_detail;
                        String string = new StringBuilder(128).append("The HTTP method started with 0x16 rather than any known HTTP method").append(this.remoteAddressStr()).append(". ").append("Perhaps this was an HTTPS request sent to an HTTP endpoint?").toString();
                        String apply_summary = "Unsupported HTTP method";
                        Object var3_5 = null;
                        string = null;
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), new ErrorInfo(apply_summary, (String)apply_detail, ""));
                    }
                }
                return this.parseCustomMethod$1(0, new StringBuilder(16), input, cursor);
            }

            private UriParser uriParser() {
                return this.uriParser;
            }

            private int parseRequestTarget(ByteString input, int cursor) {
                int uriEndLimit = cursor + this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength();
                int uriEnd = this.findUriEnd$1(cursor, input, uriEndLimit);
                try {
                    this.uriBytes = input.slice(cursor, uriEnd);
                    this.uriParser().reset((ParserInput)new ByteStringParserInput(this.uriBytes));
                    this.uri = this.uriParser().parseHttpRequestTarget();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof IllegalUriException) {
                        ErrorInfo info = ((IllegalUriException)throwable).info();
                        throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), info);
                    }
                    throw throwable;
                }
                return uriEnd + 1;
            }

            public Nothing$ onBadProtocol(ByteString input) {
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.HttpVersionNotSupported(), "");
            }

            /*
             * WARNING - void declaration
             */
            public HttpMessageParser.StateResult parseEntity(List<HttpHeader> headers2, HttpProtocol protocol, ByteString input, int bodyStart, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean expect100continue, boolean hostHeaderPresent, boolean closeAfterResponseCompletion, SSLSession sslSession) {
                block14: {
                    block13: {
                        if (hostHeaderPresent) break block13;
                        HttpProtocol httpProtocol = protocol;
                        HttpProtocol httpProtocol2 = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
                        if (httpProtocol != null ? !((Object)httpProtocol).equals(httpProtocol2) : httpProtocol2 != null) break block14;
                    }
                    if (!isChunked) {
                        long l;
                        Content$minusLength content$minusLength;
                        if (clh instanceof Some && (content$minusLength = (Content$minusLength)((Some)clh).value()) != null) {
                            l = content$minusLength.length();
                        } else if (None$.MODULE$.equals(clh)) {
                            l = 0L;
                        } else {
                            throw new MatchError(clh);
                        }
                        long contentLength = l;
                        if (contentLength == 0L) {
                            this.emitRequestStart$1(HttpMessageParser.emptyEntity$(this, cth), headers2, sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                            Function0<Option<ParserOutput.ErrorOutput>> setCompletionHandling_completionHandling = HttpMessageParser$.MODULE$.CompletionOk();
                            this.completionHandling_$eq(setCompletionHandling_completionHandling);
                            Object var17_15 = null;
                            return HttpMessageParser.startNewMessage$(this, input, bodyStart);
                        }
                        if (!this.method.isEntityAccepted()) {
                            void failMessageStart_detail;
                            void failMessageStart_summary;
                            String string = "";
                            String string2 = new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString();
                            StatusCodes.ClientError failMessageStart_status = StatusCodes$.MODULE$.UnprocessableContent();
                            return HttpMessageParser.failMessageStart$(this, failMessageStart_status, (String)failMessageStart_summary, (String)failMessageStart_detail);
                        }
                        if (contentLength <= (long)(input.size() - bodyStart)) {
                            int cl = (int)contentLength;
                            this.emitRequestStart$1(HttpMessageParser.strictEntity$(this, cth, input, bodyStart, cl), headers2, sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                            Function0<Option<ParserOutput.ErrorOutput>> setCompletionHandling_completionHandling = HttpMessageParser$.MODULE$.CompletionOk();
                            this.completionHandling_$eq(setCompletionHandling_completionHandling);
                            Object var21_20 = null;
                            int startNewMessage_offset = bodyStart + cl;
                            return HttpMessageParser.startNewMessage$(this, input, startNewMessage_offset);
                        }
                        this.emitRequestStart$1(HttpMessageParser.defaultEntity$(this, cth, contentLength), headers2, sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                        return HttpMessageParser.parseFixedLengthBody$(this, contentLength, closeAfterResponseCompletion, input, bodyStart);
                    }
                    if (!this.method.isEntityAccepted()) {
                        void failMessageStart_detail;
                        void failMessageStart_summary;
                        String string = "";
                        String string3 = new StringBuilder(33).append(this.method.name()).append(" requests must not have an entity").toString();
                        StatusCodes.ClientError failMessageStart_status = StatusCodes$.MODULE$.UnprocessableContent();
                        return HttpMessageParser.failMessageStart$(this, failMessageStart_status, (String)failMessageStart_summary, (String)failMessageStart_detail);
                    }
                    if (clh.isEmpty()) {
                        this.emitRequestStart$1(HttpMessageParser.chunkedEntity$(this, cth), headers2, sslSession, hostHeaderPresent, protocol, expect100continue, closeAfterResponseCompletion);
                        long parseChunk_totalBytesRead = 0L;
                        return HttpMessageParser.parseChunk$(this, input, bodyStart, closeAfterResponseCompletion, parseChunk_totalBytesRead);
                    }
                    String failMessageStart_summary = "A chunked request must not contain a Content-Length header";
                    String failMessageStart_detail = "";
                    return HttpMessageParser.failMessageStart$((HttpMessageParser)this, failMessageStart_summary, failMessageStart_detail);
                }
                String failMessageStart_summary = "Request is missing required `Host` header";
                String failMessageStart_detail = "";
                return HttpMessageParser.failMessageStart$((HttpMessageParser)this, failMessageStart_summary, failMessageStart_detail);
            }

            private String remoteAddressStr() {
                Option option = this.inheritedAttributes$1.get(ClassTag$.MODULE$.apply(HttpAttributes.RemoteAddress.class)).map((Function1 & Serializable)x$4 -> x$4.address());
                if (option instanceof Some) {
                    InetSocketAddress addr = (InetSocketAddress)((Some)option).value();
                    return new StringBuilder(7).append(" from ").append(addr.getHostString()).append(":").append(addr.getPort()).toString();
                }
                if (None$.MODULE$.equals(option)) {
                    return "";
                }
                throw new MatchError((Object)option);
            }

            public static final /* synthetic */ HttpMessageParser.StateResult $anonfun$parseMessage$1($anon$1 $this, ByteString input, int offset) {
                return $this.startNewMessage(input, offset);
            }

            /*
             * WARNING - void declaration
             */
            private final int parseCustomMethod$1(int ix, StringBuilder sb, ByteString input$1, int cursor$1) {
                void apply_detail;
                while (ix < this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.maxMethodLength()) {
                    int byteChar_ix = cursor$1 + ix;
                    char c = (char)(package$.MODULE$.byteAt(input$1, byteChar_ix) & 0xFF);
                    switch (c) {
                        case ' ': {
                            Option option = (Option)this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.customMethods().apply((Object)sb.toString());
                            if (option instanceof Some) {
                                HttpMethod m;
                                this.method = m = (HttpMethod)((Some)option).value();
                                return cursor$1 + ix + 1;
                            }
                            if (None$.MODULE$.equals(option)) {
                                void apply_detail2;
                                String string = sb.toString();
                                String apply_summary = "Unsupported HTTP method";
                                Object var8_10 = null;
                                string = null;
                                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.NotImplemented(), new ErrorInfo(apply_summary, (String)apply_detail2, ""));
                            }
                            throw new MatchError((Object)option);
                        }
                    }
                    sb = sb.append(c);
                    ++ix;
                }
                String string = new StringBuilder(140).append("HTTP method too long (started with '").append(sb.toString()).append("')").append(this.remoteAddressStr()).append(". ").append("Increase `pekko.http.server.parsing.max-method-length` to support HTTP methods with more characters.").toString();
                String apply_summary = "Unsupported HTTP method";
                Object var10_12 = null;
                string = null;
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.BadRequest(), new ErrorInfo(apply_summary, (String)apply_detail, ""));
            }

            private static final int parseCustomMethod$default$1$1() {
                return 0;
            }

            private static final StringBuilder parseCustomMethod$default$2$1() {
                return new StringBuilder(16);
            }

            private final int parseMethod$1(HttpMethod meth, int ix, ByteString input$1, int cursor$1) {
                while (true) {
                    if (ix == meth.value().length()) {
                        int byteChar_ix = cursor$1 + ix;
                        if ((char)(package$.MODULE$.byteAt(input$1, byteChar_ix) & 0xFF) == ' ') {
                            this.method = meth;
                            return cursor$1 + ix + 1;
                        }
                        return this.parseCustomMethod$1(0, new StringBuilder(16), input$1, cursor$1);
                    }
                    int byteChar_ix = cursor$1 + ix;
                    if ((char)(package$.MODULE$.byteAt(input$1, byteChar_ix) & 0xFF) != meth.value().charAt(ix)) break;
                    ++ix;
                }
                return this.parseCustomMethod$1(0, new StringBuilder(16), input$1, cursor$1);
            }

            private static final int parseMethod$default$2$1() {
                return 1;
            }

            private final int findUriEnd$1(int ix, ByteString input$2, int uriEndLimit$1) {
                while (true) {
                    if (ix == input$2.length()) {
                        throw NotEnoughDataException$.MODULE$;
                    }
                    if (CharacterClasses$.MODULE$.WSPCRLF().apply((char)input$2.apply(ix))) {
                        return ix;
                    }
                    if (ix >= uriEndLimit$1) break;
                    ++ix;
                }
                throw new ParsingException((StatusCode)StatusCodes$.MODULE$.UriTooLong(), new StringBuilder(54).append("URI length exceeds the configured limit of ").append(this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.maxUriLength()).append(" characters").append(this.remoteAddressStr()).toString());
            }

            private static final int findUriEnd$default$1$1(int cursor$2) {
                return cursor$2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final void emitRequestStart$1(ParserOutput.EntityCreator createEntity, List headers2, SSLSession sslSession$1, boolean hostHeaderPresent$1, HttpProtocol protocol$1, boolean expect100continue$1, boolean closeAfterResponseCompletion$1) {
                ParserOutput.RequestStart requestStart;
                Map map;
                List allHeaders0;
                List list;
                if (this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader) {
                    Raw$minusRequest$minusURI raw$minusRequest$minusURI = new Raw$minusRequest$minusURI(this.uriBytes.decodeString(HttpCharsets$.MODULE$.US$minusASCII().nioCharset()));
                    list = headers2.$colon$colon((Object)raw$minusRequest$minusURI);
                } else {
                    list = allHeaders0 = headers2;
                }
                if (this.settings().includeSslSessionAttribute()) {
                    Object[] objectArray = new Tuple2[1];
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(AttributeKeys$.MODULE$.sslSession()), (Object)new SslSessionInfo(sslSession$1));
                    map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                } else {
                    map = Predef$.MODULE$.Map().empty();
                }
                Map attributes = map;
                HttpMethod httpMethod = this.method;
                HttpMethod httpMethod2 = HttpMethods$.MODULE$.GET();
                if (!(httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null)) {
                    UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel = Handshake$Server$.MODULE$.websocketUpgrade((List<HttpHeader>)headers2, hostHeaderPresent$1, this.$outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$websocketSettings, this.headerParser().log());
                    UpgradeToWebSocketLowLevel upgradeToWebSocketLowLevel2 = (UpgradeToWebSocketLowLevel)OptionVal.Some$.MODULE$.unapply((Object)upgradeToWebSocketLowLevel);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)upgradeToWebSocketLowLevel2)) {
                        UpgradeToWebSocketLowLevel upgrade = (UpgradeToWebSocketLowLevel)OptionVal$.MODULE$.get$extension((Object)upgradeToWebSocketLowLevel2);
                        requestStart = new ParserOutput.RequestStart(this.method, this.uri, protocol$1, (Map)attributes.updated(AttributeKeys$.MODULE$.webSocketUpgrade(), (Object)upgrade), (List<HttpHeader>)allHeaders0.$colon$colon((Object)upgrade), createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                    } else {
                        OptionVal$.MODULE$.None();
                        if (upgradeToWebSocketLowLevel != null) throw new MatchError((Object)new OptionVal((Object)upgradeToWebSocketLowLevel));
                        requestStart = new ParserOutput.RequestStart(this.method, this.uri, protocol$1, attributes, (List<HttpHeader>)allHeaders0, createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                    }
                } else {
                    requestStart = new ParserOutput.RequestStart(this.method, this.uri, protocol$1, attributes, (List<HttpHeader>)allHeaders0, createEntity, expect100continue$1, closeAfterResponseCompletion$1);
                }
                ParserOutput.RequestStart requestStart2 = requestStart;
                HttpMessageParser.emit$(this, requestStart2);
            }

            private static final List emitRequestStart$default$2$1(List headers$1) {
                return headers$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inheritedAttributes$1 = inheritedAttributes$1;
                super($outer.shape());
                HttpMessageParser.$init$(this);
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                this.settings = $outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings;
                this.headerParser = $outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$headerParser.createShallowCopy();
                this.isResponseParser = false;
                this.setHandlers($outer.in(), $outer.out(), this);
                Uri.ParsingMode x$2 = $outer.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings.uriParsingMode();
                Charset x$3 = org.parboiled2.package$.MODULE$.UTF8();
                this.uriParser = new UriParser(null, x$3, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$parseMessage$1$adapted(org.apache.pekko.http.impl.engine.parsing.HttpRequestParser$$anon$1 org.apache.pekko.util.ByteString java.lang.Object ), $anonfun$remoteAddressStr$1(org.apache.pekko.http.impl.engine.server.HttpAttributes$RemoteAddress ), $anonfun$continue$3(scala.Function2 org.apache.pekko.util.ByteString )}, serializedLambda);
            }
        };
    }

    public String toString() {
        return "HttpRequestParser";
    }

    public HttpRequestParser(ParserSettings settings, WebSocketSettings websocketSettings, boolean rawRequestUriHeader, HttpHeaderParser headerParser) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$settings = settings;
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$websocketSettings = websocketSettings;
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$rawRequestUriHeader = rawRequestUriHeader;
        this.org$apache$pekko$http$impl$engine$parsing$HttpRequestParser$$headerParser = headerParser;
        this.in = Inlet$.MODULE$.apply("HttpRequestParser.in");
        this.out = Outlet$.MODULE$.apply("HttpRequestParser.out");
        this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
    }
}

