/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

@Internal
public final class MessageHelper {
    private MessageHelper() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized String entityName, @Nullable @UnknownKeyFor @Initialized Object id) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (entityName == null) {
            s.append("<null entity name>");
        } else {
            s.append(entityName);
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else {
            s.append(id);
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister, @Nullable @UnknownKeyFor @Initialized Object id, @Nullable @UnknownKeyFor @Initialized SessionFactoryImplementor factory) {
        Type idType;
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (persister == null) {
            s.append("<null EntityPersister>");
            idType = null;
        } else {
            s.append(persister.getEntityName());
            idType = persister.getIdentifierType();
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else if (idType == null) {
            s.append(id);
        } else if (factory != null) {
            s.append(idType.toLoggableString(id, factory));
        } else {
            s.append("<not loggable>");
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister, @Nullable @UnknownKeyFor @Initialized Object id, @UnknownKeyFor @NonNull @Initialized Type identifierType, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (persister == null) {
            s.append("<null EntityPersister>");
        } else {
            s.append(persister.getEntityName());
        }
        s.append('#');
        if (id == null) {
            s.append("<null>");
        } else {
            s.append(identifierType.toLoggableString(id, factory));
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] ids, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (persister == null) {
            s.append("<null EntityPersister>");
        } else {
            s.append(persister.getEntityName());
            s.append("#<");
            for (int i = 0; i < ids.length; ++i) {
                s.append(persister.getIdentifierType().toLoggableString(ids[i], factory));
                if (i >= ids.length - 1) continue;
                s.append(", ");
            }
            s.append('>');
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@Nullable @UnknownKeyFor @Initialized EntityPersister persister) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (persister == null) {
            s.append("<null EntityPersister>");
        } else {
            s.append(persister.getEntityName());
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String infoString(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String propertyName, @Nullable @UnknownKeyFor @Initialized Object key) {
        StringBuilder s = new StringBuilder().append('[').append(entityName).append('.').append(propertyName).append('#');
        if (key == null) {
            s.append("<null>");
        } else {
            s.append(key);
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized CollectionPersister persister, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> collection, @UnknownKeyFor @NonNull @Initialized Object collectionKey, @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor session) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (persister == null) {
            s.append("<unreferenced>");
        } else {
            Object ownerKey;
            s.append(persister.getRole());
            s.append('#');
            Type ownerIdentifierType = persister.getOwnerEntityPersister().getIdentifierType();
            if (collectionKey.getClass().isAssignableFrom(ownerIdentifierType.getReturnedClass())) {
                ownerKey = collectionKey;
            } else {
                Object collectionOwner = collection == null ? null : collection.getOwner();
                EntityEntry entry = collectionOwner == null ? null : session.getPersistenceContextInternal().getEntry(collectionOwner);
                ownerKey = entry == null ? null : entry.getId();
            }
            s.append(ownerIdentifierType.toLoggableString(ownerKey, session.getFactory()));
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized CollectionPersister persister, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] ids, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (persister == null) {
            s.append("<unreferenced>");
        } else {
            s.append(persister.getRole());
            s.append("#<");
            for (int i = 0; i < ids.length; ++i) {
                MessageHelper.addIdToCollectionInfoString(persister, ids[i], factory, s);
                if (i >= ids.length - 1) continue;
                s.append(", ");
            }
            s.append('>');
        }
        s.append(']');
        return s.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized CollectionPersister persister, @Nullable @UnknownKeyFor @Initialized Object id, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (persister == null) {
            s.append("<unreferenced>");
        } else {
            s.append(persister.getRole());
            s.append('#');
            if (id == null) {
                s.append("<null>");
            } else {
                MessageHelper.addIdToCollectionInfoString(persister, id, factory, s);
            }
        }
        s.append(']');
        return s.toString();
    }

    private static void addIdToCollectionInfoString(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister, @UnknownKeyFor @NonNull @Initialized Object id, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory, @UnknownKeyFor @NonNull @Initialized StringBuilder s) {
        Type ownerIdentifierType = persister.getOwnerEntityPersister().getIdentifierType();
        if (id.getClass().isAssignableFrom(ownerIdentifierType.getReturnedClass())) {
            s.append(ownerIdentifierType.toLoggableString(id, factory));
        } else {
            s.append(id);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String collectionInfoString(@Nullable @UnknownKeyFor @Initialized String role, @Nullable @UnknownKeyFor @Initialized Object id) {
        StringBuilder s = new StringBuilder();
        s.append('[');
        if (role == null) {
            s.append("<unreferenced>");
        } else {
            s.append(role);
            s.append('#');
            if (id == null) {
                s.append("<null>");
            } else {
                s.append(id);
            }
        }
        s.append(']');
        return s.toString();
    }
}

