/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.registry.impl;

import java.security.AccessController;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.DefineConfigurationAction;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.UndefineConfigurationAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static void defineConfiguration(EmbeddedCacheManager cacheManager, String cacheName, Configuration configurationOverride) {
        DefineConfigurationAction action = new DefineConfigurationAction(cacheManager, cacheName, configurationOverride);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            Security.doPrivileged(action);
        }
    }

    static void undefineConfiguration(EmbeddedCacheManager cacheManager, String name) {
        UndefineConfigurationAction action = new UndefineConfigurationAction(cacheManager, name);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            Security.doPrivileged(action);
        }
    }

    static void getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        GetCacheAction action = new GetCacheAction(cacheManager, cacheName);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            Security.doPrivileged(action);
        }
    }
}

