/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.util.TrustManagerUtils;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;

public final class FtpsFileSystemConfigBuilder
extends FtpFileSystemConfigBuilder {
    private static final String PREFIX = FtpsFileSystemConfigBuilder.class.getName();
    private static final FtpsFileSystemConfigBuilder BUILDER = new FtpsFileSystemConfigBuilder();
    private static final String FTPS_MODE = PREFIX + ".FTPS_MODE";
    private static final String PROT = PREFIX + ".PROT";
    private static final String KEY_MANAGER = PREFIX + ".KEY_MANAGER";
    private static final String TRUST_MANAGER = PREFIX + ".TRUST_MANAGER";

    public static FtpsFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private FtpsFileSystemConfigBuilder() {
        super("ftps.");
    }

    public FtpsDataChannelProtectionLevel getDataChannelProtectionLevel(FileSystemOptions opts) {
        return this.getEnum(FtpsDataChannelProtectionLevel.class, opts, PROT);
    }

    public FtpsMode getFtpsMode(FileSystemOptions opts) {
        return this.getEnum(FtpsMode.class, opts, FTPS_MODE, FtpsMode.EXPLICIT);
    }

    @Deprecated
    public String getFtpsType(FileSystemOptions opts) {
        return this.getFtpsMode(opts).name().toLowerCase();
    }

    public KeyManager getKeyManager(FileSystemOptions opts) {
        return (KeyManager)this.getParam(opts, KEY_MANAGER);
    }

    public TrustManager getTrustManager(FileSystemOptions opts) {
        TrustManager trustManager = this.hasParam(opts, TRUST_MANAGER) ? (TrustManager)this.getParam(opts, TRUST_MANAGER) : TrustManagerUtils.getValidateServerCertificateTrustManager();
        return trustManager;
    }

    public void setDataChannelProtectionLevel(FileSystemOptions opts, FtpsDataChannelProtectionLevel prot) {
        this.setParam(opts, PROT, (Object)prot);
    }

    public void setFtpsMode(FileSystemOptions opts, FtpsMode ftpsMode) {
        this.setParam(opts, FTPS_MODE, (Object)ftpsMode);
    }

    @Deprecated
    public void setFtpsType(FileSystemOptions opts, String ftpsType) {
        FtpsMode mode = ftpsType != null ? FtpsMode.valueOf(ftpsType.toUpperCase()) : null;
        this.setFtpsMode(opts, mode);
    }

    public void setKeyManager(FileSystemOptions opts, KeyManager keyManager) {
        this.setParam(opts, KEY_MANAGER, keyManager);
    }

    public void setTrustManager(FileSystemOptions opts, TrustManager trustManager) {
        this.setParam(opts, TRUST_MANAGER, trustManager);
    }
}

