/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.config;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.service.UserGroupService;
import com.xebialabs.deployit.security.service.UserTokenService;
import com.xebialabs.xldeploy.auth.TokenExpiredException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001\u0002\n\u0014\u0001yA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d)\u0006A1A\u0005\nYCa!\u0018\u0001!\u0002\u00139\u0006b\u00020\u0001\u0001\u0004%Ia\u0018\u0005\bU\u0002\u0001\r\u0011\"\u0003l\u0011\u0019!\b\u0001)Q\u0005A\")Q\u000f\u0001C!m\")Q\u0010\u0001C\u0005}\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u0019\ty\u0007\u0001C\u0001?\"9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M$\u0001\b#fa2|\u00170Q;uQ\u0016tG/[2bi&|g\u000e\u0015:pm&$WM\u001d\u0006\u0003)U\taaY8oM&<'B\u0001\f\u0018\u0003\u0011\tW\u000f\u001e5\u000b\u0005aI\u0012\u0001\u0003=mI\u0016\u0004Hn\\=\u000b\u0005iY\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0012aA2p[\u000e\u00011c\u0001\u0001 OA\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0005Y\u0006twMC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019\n#AB(cU\u0016\u001cG\u000f\u0005\u0002)c5\t\u0011F\u0003\u0002+W\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'B\u0001\u0017.\u0003!\u0019XmY;sSRL(B\u0001\u00180\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023S\t1\u0012)\u001e;iK:$\u0018nY1uS>t\u0007K]8wS\u0012,'/A\u0006vg\u0016\u00148+\u001a:wS\u000e,\u0007CA\u001b:\u001b\u00051$B\u0001\u00178\u0015\tA\u0014$\u0001\u0005eKBdw._5u\u0013\tQdGA\u0006Vg\u0016\u00148+\u001a:wS\u000e,\u0017\u0001E;tKJ$vn[3o'\u0016\u0014h/[2f!\ti\u0004)D\u0001?\u0015\tyd'A\u0004tKJ4\u0018nY3\n\u0005\u0005s$\u0001E+tKJ$vn[3o'\u0016\u0014h/[2f\u0003U\u0001(/\u001b8dSB\fG\u000eR1uCB\u0013xN^5eKJ\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u001c\u0002\u001bA\u0014\u0018N\\2ja\u0006dG-\u0019;b\u0013\tAUIA\u000bQe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0002!U\u001cXM]$s_V\u00048+\u001a:wS\u000e,\u0007CA\u001fL\u0013\taeH\u0001\tVg\u0016\u0014xI]8vaN+'O^5dK\u00061A(\u001b8jiz\"RaT)S'R\u0003\"\u0001\u0015\u0001\u000e\u0003MAQaM\u0003A\u0002QBQaO\u0003A\u0002qBQAQ\u0003A\u0002\rCQ!S\u0003A\u0002)\u000ba\u0001\\8hO\u0016\u0014X#A,\u0011\u0005a[V\"A-\u000b\u0005i{\u0013!B:mMRR\u0017B\u0001/Z\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!E1vi\"|'/\u001b;jKNl\u0015\r\u001d9feV\t\u0001\r\u0005\u0002bQ6\t!M\u0003\u0002dI\u00069Q.\u00199qS:<'BA3g\u0003%\tW\u000f\u001e5pe&$\u0018P\u0003\u0002hW\u0005!1m\u001c:f\u0013\tI'M\u0001\rHe\u0006tG/\u001a3BkRDwN]5uS\u0016\u001cX*\u00199qKJ\fQ#Y;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3s?\u0012*\u0017\u000f\u0006\u0002meB\u0011Q\u000e]\u0007\u0002]*\tq.A\u0003tG\u0006d\u0017-\u0003\u0002r]\n!QK\\5u\u0011\u001d\u0019\u0018\"!AA\u0002\u0001\f1\u0001\u001f\u00132\u0003I\tW\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM\u001d\u0011\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0015\u0005]\\\bC\u0001=z\u001b\u00051\u0017B\u0001>g\u00059\tU\u000f\u001e5f]RL7-\u0019;j_:DQ\u0001`\u0006A\u0002]\fQ\u0001^8lK:\f\u0011$Y;uQ\u0016tG/[2bi\u00164%o\\7Vg\u0016\u0014Hk\\6f]R\u0011qo \u0005\u0007y2\u0001\r!!\u0001\u0011\t\u0005\r\u0011\u0011\u0003\b\u0005\u0003\u000b\ti\u0001E\u0002\u0002\b9l!!!\u0003\u000b\u0007\u0005-Q$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001fq\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!AB*ue&twMC\u0002\u0002\u00109\f1$Y;uQ\u0016tG/[2bi\u00164%o\\7De\u0016$WM\u001c;jC2\u001cH#B<\u0002\u001c\u0005}\u0001bBA\u000f\u001b\u0001\u0007\u0011\u0011A\u0001\tkN,'O\\1nK\"9\u0011\u0011E\u0007A\u0002\u0005\u0005\u0011\u0001\u00039bgN<xN\u001d3\u0002\u0011M,\b\u000f]8siN$B!a\n\u0002.A\u0019Q.!\u000b\n\u0007\u0005-bNA\u0004C_>dW-\u00198\t\r)r\u0001\u0019AA\u0018a\u0011\t\t$a\u000f\u0011\r\u0005\r\u00111GA\u001c\u0013\u0011\t)$!\u0006\u0003\u000b\rc\u0017m]:\u0011\t\u0005e\u00121\b\u0007\u0001\t1\ti$!\f\u0002\u0002\u0003\u0005)\u0011AA \u0005\ryFeM\t\u0005\u0003\u0003\n9\u0005E\u0002n\u0003\u0007J1!!\u0012o\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\\A%\u0013\r\tYE\u001c\u0002\u0004\u0003:L\u0018aE3wC2,\u0018\r^3BkRDwN]5uS\u0016\u001cH\u0003BA)\u0003[\u0002D!a\u0015\u0002bA1\u0011QKA.\u0003?j!!a\u0016\u000b\u0007\u0005e3%\u0001\u0003vi&d\u0017\u0002BA/\u0003/\u0012!bQ8mY\u0016\u001cG/[8o!\u0011\tI$!\u0019\u0005\u0017\u0005\rt\"!A\u0001\u0002\u000b\u0005\u0011Q\r\u0002\u0004?\u0012\"\u0014\u0003BA!\u0003O\u00022\u0001_A5\u0013\r\tYG\u001a\u0002\u0011\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:jifDq!!\b\u0010\u0001\u0004\t\t!\u0001\u000bhKR\fU\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM]\u0001\u0015g\u0016$\u0018)\u001e;i_JLG/[3t\u001b\u0006\u0004\b/\u001a:\u0015\u00071\f)\bC\u0003_#\u0001\u0007\u0001\rK\u0004\u0001\u0003s\n))a\"\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a .\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u0007\u000biHA\u0005D_6\u0004xN\\3oi\u0006)a/\u00197vK\u0006\u0012\u0011\u0011R\u0001\u0019q2\fU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\b")
public class DeployAuthenticationProvider
implements AuthenticationProvider {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final PrincipalDataProvider principalDataProvider;
    private final UserGroupService userGroupService;
    private final Logger logger;
    private GrantedAuthoritiesMapper authoritiesMapper;

    private Logger logger() {
        return this.logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) {
        Authentication authentication;
        this.logger().debug("Authenticating for Digital.ai Deploy");
        try {
            Authentication authentication2 = token;
            authentication = authentication2 instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace("Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        XldUserToken userToken = this.userTokenService.findByUserToken(tokenHash);
        if (userToken == null) {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        }
        if (((Tokens)userToken.tokens().head()).isExpired()) {
            throw new TokenExpiredException("The token expired on " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(((Tokens)userToken.tokens().head()).expiryDate()));
        }
        this.userTokenService.updateLastUsedDate(Predef$.MODULE$.Integer2int(((Tokens)userToken.tokens().head()).ciId()), new Date());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken((Object)userToken.username(), token, ((Tokens)userToken.tokens().head()).expiryDate(), mappedAuthorities, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace("Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, mappedAuthorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        ArrayList arrayList;
        UserData userData = this.principalDataProvider.getUserData(username);
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider.getAuthorities(username));
        }
        try {
            User user = this.userService.read(username);
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
            arrayList = grantedAuthorities;
        }
        catch (NotFoundException notFoundException) {
            Set userGroups = this.userGroupService.findGroupsForUser(username);
            ArrayList grantedAuthorities = new ArrayList();
            userGroups.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority(group))));
            arrayList = grantedAuthorities;
        }
        ArrayList authorities = arrayList;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public DeployAuthenticationProvider(UserService userService, UserTokenService userTokenService, PrincipalDataProvider principalDataProvider, UserGroupService userGroupService) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.principalDataProvider = principalDataProvider;
        this.userGroupService = userGroupService;
        this.logger = LoggerFactory.getLogger(DeployAuthenticationProvider.class);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

