/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.oidc.web;

import com.xebialabs.deployit.util.MustacheRenderer;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class XlDeployLoginFormFilter
extends UsernamePasswordAuthenticationFilter {
    public static final String DEFAULT_LOGIN_URL = "/login";
    public static final String ERROR_PARAMETER_NAME = "error";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private final RequestMatcher requiresAuthenticationRequestMatcher;
    private final Map<String, String> settings;
    private final Resource layout;
    private final Resource content;
    private final String loginUrl;

    public XlDeployLoginFormFilter(Map<String, String> settings) {
        this(DEFAULT_LOGIN_URL, settings);
    }

    public XlDeployLoginFormFilter(String loginUrl, Map<String, String> settings) {
        this(loginUrl, (Resource)new ClassPathResource("com/xebialabs/platform/sso/oidc/web/modal-layout.mustache"), (Resource)new ClassPathResource("com/xebialabs/platform/sso/oidc/web/login.mustache"), settings);
    }

    public XlDeployLoginFormFilter(String loginUrl, Resource layout, Resource content, Map<String, String> settings) {
        this.requiresAuthenticationRequestMatcher = new AntPathRequestMatcher(loginUrl);
        this.loginUrl = loginUrl;
        this.settings = settings;
        this.layout = layout;
        this.content = content;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws AuthenticationServiceException, IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.requiresAuthenticationRequestMatcher.matches(request)) {
            if (request.getMethod().equals(GET)) {
                HashMap<String, String> context = new HashMap<String, String>(this.settings);
                context.put("loginUrl", ((HttpServletRequest)req).getContextPath() + this.loginUrl);
                context.put(ERROR_PARAMETER_NAME, request.getParameter(ERROR_PARAMETER_NAME));
                HashMap<String, Resource> partials = new HashMap<String, Resource>();
                partials.put("content", this.content);
                MustacheRenderer mustacheRenderer = new MustacheRenderer(this.layout, partials, context);
                mustacheRenderer.render(response);
                return;
            } else {
                if (!request.getMethod().equals(POST)) throw new AuthenticationServiceException("Authentication method must be a POST or GET got: " + request.getMethod());
                super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
            return;
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

