/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.Arrays;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTable
extends AbstractTable {
    private static final Logger logger = LoggerFactory.getLogger(CompositeTable.class);
    private final ITableMetaData _metaData;
    private final ITable[] _tables;

    public CompositeTable(ITableMetaData metaData, ITable table) {
        this._metaData = metaData;
        this._tables = new ITable[]{table};
    }

    public CompositeTable(ITableMetaData metaData, ITable[] tables) {
        this._metaData = metaData;
        this._tables = tables;
    }

    public CompositeTable(ITable table1, ITable table2) {
        this._metaData = table1.getTableMetaData();
        this._tables = new ITable[]{table1, table2};
    }

    public CompositeTable(String newName, ITable table) throws DataSetException {
        ITableMetaData metaData = table.getTableMetaData();
        this._metaData = new DefaultTableMetaData(newName, metaData.getColumns(), metaData.getPrimaryKeys());
        this._tables = new ITable[]{table};
    }

    @Override
    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    @Override
    public int getRowCount() {
        logger.debug("getRowCount() - start");
        int totalCount = 0;
        for (int i = 0; i < this._tables.length; ++i) {
            ITable table = this._tables[i];
            totalCount += table.getRowCount();
        }
        return totalCount;
    }

    @Override
    public Object getValue(int row, String columnName) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)columnName);
        }
        if (row < 0) {
            throw new RowOutOfBoundsException(row + " < 0 ");
        }
        int totalCount = 0;
        for (int i = 0; i < this._tables.length; ++i) {
            ITable table = this._tables[i];
            int count = table.getRowCount();
            if (totalCount + count > row) {
                return table.getValue(row - totalCount, columnName);
            }
            totalCount += count;
        }
        throw new RowOutOfBoundsException(row + " > " + totalCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append(this.getClass().getName()).append("[");
        sb.append("_metaData=[").append(this._metaData).append("], ");
        sb.append("_tables=[").append(Arrays.toString(this._tables)).append("]");
        sb.append("]");
        return sb.toString();
    }
}

