/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.sql.Connection;
import java.sql.DriverManager;
import org.dbunit.AbstractDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDatabaseTester
extends AbstractDatabaseTester {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDatabaseTester.class);
    private String connectionUrl;
    private String driverClass;
    private String password;
    private String username;

    public JdbcDatabaseTester(String driverClass, String connectionUrl) throws ClassNotFoundException {
        this(driverClass, connectionUrl, null, null);
    }

    public JdbcDatabaseTester(String driverClass, String connectionUrl, String username, String password) throws ClassNotFoundException {
        this(driverClass, connectionUrl, username, password, null);
    }

    public JdbcDatabaseTester(String driverClass, String connectionUrl, String username, String password, String schema) throws ClassNotFoundException {
        super(schema);
        this.driverClass = driverClass;
        this.connectionUrl = connectionUrl;
        this.username = username;
        this.password = password;
        this.assertNotNullNorEmpty("driverClass", driverClass);
        Class.forName(driverClass);
    }

    @Override
    public IDatabaseConnection getConnection() throws Exception {
        logger.debug("getConnection() - start");
        this.assertNotNullNorEmpty("connectionUrl", this.connectionUrl);
        Connection conn = null;
        conn = this.username == null && this.password == null ? DriverManager.getConnection(this.connectionUrl) : DriverManager.getConnection(this.connectionUrl, this.username, this.password);
        return new DatabaseConnection(conn, this.getSchema());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("connectionUrl=").append(this.connectionUrl);
        sb.append(", driverClass=").append(this.driverClass);
        sb.append(", username=").append(this.username);
        sb.append(", password=**********");
        sb.append(", schema=").append(super.getSchema());
        sb.append("]");
        return sb.toString();
    }
}

