/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmFromClause
implements Serializable {
    private List<SqmRoot<?>> domainRoots;

    public SqmFromClause() {
    }

    public SqmFromClause(int expectedNumberOfRoots) {
        this.domainRoots = CollectionHelper.arrayList(expectedNumberOfRoots);
    }

    private SqmFromClause(SqmFromClause original, SqmCopyContext context) {
        if (original.domainRoots != null) {
            this.domainRoots = new ArrayList(original.domainRoots.size());
            for (SqmRoot<?> domainRoot : original.domainRoots) {
                this.domainRoots.add((SqmRoot<?>)domainRoot.copy(context));
            }
        }
    }

    public SqmFromClause copy(SqmCopyContext context) {
        return new SqmFromClause(this, context);
    }

    public List<SqmRoot<?>> getRoots() {
        return this.domainRoots == null ? Collections.emptyList() : Collections.unmodifiableList(this.domainRoots);
    }

    public void setRoots(List<SqmRoot<?>> domainRoots) {
        this.domainRoots = domainRoots;
    }

    public void addRoot(SqmRoot<?> root) {
        if (this.domainRoots == null) {
            this.domainRoots = new ArrayList();
        }
        this.domainRoots.add(root);
    }

    public void visitRoots(Consumer<SqmRoot<?>> consumer) {
        if (this.domainRoots != null) {
            this.domainRoots.forEach(consumer);
        }
    }

    public int getNumberOfRoots() {
        if (this.domainRoots == null) {
            return 0;
        }
        return this.domainRoots.size();
    }

    public void appendHqlString(StringBuilder sb) {
        String separator = " ";
        for (SqmRoot<?> root : this.getRoots()) {
            sb.append(separator);
            if (root.isCorrelated()) {
                if (root.containsOnlyInnerJoins()) {
                    this.appendJoins(root, root.getCorrelationParent().resolveAlias(), sb);
                } else {
                    sb.append(root.getCorrelationParent().resolveAlias());
                    sb.append(' ').append(root.resolveAlias());
                    SqmFromClause.appendJoins(root, sb);
                    SqmFromClause.appendTreatJoins(root, sb);
                }
            } else {
                sb.append(root.getEntityName());
                sb.append(' ').append(root.resolveAlias());
                SqmFromClause.appendJoins(root, sb);
                SqmFromClause.appendTreatJoins(root, sb);
            }
            separator = ", ";
        }
    }

    public static void appendJoins(SqmFrom<?, ?> sqmFrom, StringBuilder sb) {
        for (SqmJoin<?, ?> sqmJoin : sqmFrom.getSqmJoins()) {
            switch (sqmJoin.getSqmJoinType()) {
                case LEFT: {
                    sb.append(" left join ");
                    break;
                }
                case RIGHT: {
                    sb.append(" right join ");
                    break;
                }
                case INNER: {
                    sb.append(" join ");
                    break;
                }
                case FULL: {
                    sb.append(" full join ");
                    break;
                }
                case CROSS: {
                    sb.append(" cross join ");
                }
            }
            if (sqmJoin instanceof SqmAttributeJoin) {
                SqmAttributeJoin attributeJoin = (SqmAttributeJoin)sqmJoin;
                if (sqmFrom instanceof SqmTreatedPath) {
                    SqmTreatedPath treatedPath = (SqmTreatedPath)((Object)sqmFrom);
                    sb.append("treat(");
                    sb.append(treatedPath.getWrappedPath().resolveAlias());
                    sb.append(" as ").append(treatedPath.getTreatTarget().getTypeName()).append(')');
                } else {
                    sb.append(sqmFrom.resolveAlias());
                }
                sb.append('.').append(attributeJoin.getAttribute().getName());
                sb.append(' ').append(sqmJoin.resolveAlias());
                if (attributeJoin.getJoinPredicate() != null) {
                    sb.append(" on ");
                    attributeJoin.getJoinPredicate().appendHqlString(sb);
                }
                SqmFromClause.appendJoins(sqmJoin, sb);
                continue;
            }
            if (sqmJoin instanceof SqmCrossJoin) {
                sb.append(((SqmCrossJoin)sqmJoin).getEntityName());
                sb.append(' ').append(sqmJoin.resolveAlias());
                SqmFromClause.appendJoins(sqmJoin, sb);
                continue;
            }
            if (sqmJoin instanceof SqmEntityJoin) {
                SqmEntityJoin sqmEntityJoin = (SqmEntityJoin)sqmJoin;
                sb.append(sqmEntityJoin.getEntityName());
                sb.append(' ').append(sqmJoin.resolveAlias());
                if (sqmEntityJoin.getJoinPredicate() != null) {
                    sb.append(" on ");
                    sqmEntityJoin.getJoinPredicate().appendHqlString(sb);
                }
                SqmFromClause.appendJoins(sqmJoin, sb);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported join: " + sqmJoin);
        }
    }

    private void appendJoins(SqmFrom<?, ?> sqmFrom, String correlationPrefix, StringBuilder sb) {
        String separator = "";
        for (SqmJoin<?, ?> sqmJoin : sqmFrom.getSqmJoins()) {
            assert (sqmJoin instanceof SqmAttributeJoin);
            sb.append(separator);
            sb.append(correlationPrefix).append('.');
            sb.append(((SqmAttributeJoin)sqmJoin).getAttribute().getName());
            sb.append(' ').append(sqmJoin.resolveAlias());
            SqmFromClause.appendJoins(sqmJoin, sb);
            separator = ", ";
        }
    }

    public static void appendTreatJoins(SqmFrom<?, ?> sqmFrom, StringBuilder sb) {
        for (SqmFrom<?, ?> sqmTreat : sqmFrom.getSqmTreats()) {
            SqmFromClause.appendJoins(sqmTreat, sb);
        }
    }
}

