/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportListener;

public abstract class AbstractTransportMapping
implements TransportMapping {
    protected Vector transportListener = new Vector(1);
    protected int maxInboundMessageSize = 65535;
    protected boolean asyncMsgProcessingSupported = true;

    public abstract Class getSupportedAddressClass();

    public abstract void sendMessage(Address var1, byte[] var2) throws IOException;

    public void addMessageDispatcher(MessageDispatcher messageDispatcher) {
        this.addTransportListener(messageDispatcher);
    }

    public void removeMessageDispatcher(MessageDispatcher messageDispatcher) {
        this.removeTransportListener(messageDispatcher);
    }

    public synchronized void addTransportListener(TransportListener transportListener) {
        Vector vector;
        Vector vector2 = vector = this.transportListener == null ? new Vector(2) : (Vector)this.transportListener.clone();
        if (!vector.contains(transportListener)) {
            vector.addElement(transportListener);
            this.transportListener = vector;
        }
    }

    public synchronized void removeTransportListener(TransportListener transportListener) {
        if (this.transportListener != null && this.transportListener.contains(transportListener)) {
            Vector vector = (Vector)this.transportListener.clone();
            vector.removeElement(transportListener);
            this.transportListener = vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProcessMessage(Address address, ByteBuffer byteBuffer) {
        if (this.transportListener != null) {
            for (int i = 0; i < this.transportListener.size(); ++i) {
                TransportListener transportListener;
                AbstractTransportMapping abstractTransportMapping = this;
                synchronized (abstractTransportMapping) {
                    transportListener = (TransportListener)this.transportListener.get(i);
                }
                transportListener.processMessage(this, address, byteBuffer);
            }
        }
    }

    public abstract void close() throws IOException;

    public abstract void listen() throws IOException;

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public boolean isAsyncMsgProcessingSupported() {
        return this.asyncMsgProcessingSupported;
    }

    public void setAsyncMsgProcessingSupported(boolean bl) {
        this.asyncMsgProcessingSupported = bl;
    }
}

