/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.messages;

import com.hierynomus.ntlm.functions.NtlmFunctions;
import com.hierynomus.ntlm.messages.NtlmMessage;
import com.hierynomus.ntlm.messages.NtlmNegotiateFlag;
import com.hierynomus.ntlm.messages.Utils;
import com.hierynomus.ntlm.messages.WindowsVersion;
import com.hierynomus.protocol.commons.Charsets;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import java.util.Set;

public class NtlmNegotiate
extends NtlmMessage {
    private byte[] domain;
    private byte[] workstation;
    private boolean omitVersion;

    public NtlmNegotiate(Set<NtlmNegotiateFlag> flags, String domain, String workstation, WindowsVersion version, boolean omitVersion) {
        super(flags, version);
        this.domain = domain != null ? NtlmFunctions.oem(domain) : Utils.EMPTY;
        this.workstation = workstation != null ? NtlmFunctions.oem(workstation) : Utils.EMPTY;
        this.omitVersion = omitVersion;
    }

    @Override
    public void write(Buffer.PlainBuffer buffer) {
        buffer.putString("NTLMSSP\u0000", Charsets.UTF_8);
        buffer.putUInt32(1L);
        buffer.putUInt32(EnumWithValue.EnumUtils.toLong(this.negotiateFlags));
        int offset = 32;
        if (!this.omitVersion) {
            offset += 8;
        }
        if (this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED)) {
            offset = Utils.writeOffsettedByteArrayFields(buffer, this.domain, offset);
        } else {
            buffer.putUInt16(0);
            buffer.putUInt16(0);
            buffer.putUInt32(0L);
        }
        if (this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED)) {
            offset = Utils.writeOffsettedByteArrayFields(buffer, this.workstation, offset);
        } else {
            buffer.putUInt16(0);
            buffer.putUInt16(0);
            buffer.putUInt32(0L);
        }
        if (!this.omitVersion && this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_VERSION)) {
            this.version.writeTo(buffer);
        } else if (!this.omitVersion) {
            buffer.putUInt64(0L);
        }
        buffer.putRawBytes(this.domain);
        buffer.putRawBytes(this.workstation);
    }

    public String toString() {
        return "NtlmNegotiate{\n  domain='" + NtlmFunctions.oem(this.domain) + "'',\n  workstation='" + NtlmFunctions.oem(this.workstation) + "',\n  negotiateFlags=" + this.negotiateFlags + ",\n  version=" + this.version + "\n}";
    }
}

