/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication.ott;

import java.net.URI;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.authentication.ott.ServerOneTimeTokenGenerationSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ServerRedirectOneTimeTokenGenerationSuccessHandler
implements ServerOneTimeTokenGenerationSuccessHandler {
    private final ServerRedirectStrategy redirectStrategy = new DefaultServerRedirectStrategy();
    private final URI redirectUri;

    public ServerRedirectOneTimeTokenGenerationSuccessHandler(String redirectUri) {
        Assert.hasText((String)redirectUri, (String)"redirectUri cannot be empty or null");
        this.redirectUri = URI.create(redirectUri);
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange, OneTimeToken oneTimeToken) {
        return this.redirectStrategy.sendRedirect(exchange, this.redirectUri);
    }
}

