/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.ByteArrayFile;
import com.xebialabs.overthere.util.OverthereFileTransmitter;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class OverthereFileTranscoder
extends OverthereFileTransmitter {
    private static final String SOURCE = "Source";
    private static final String DESTINATION = "Destination";
    private final Charset srcCharset;
    private final Charset dstCharset;

    public OverthereFileTranscoder(Charset srcCharset, Charset dstCharset) {
        this.srcCharset = srcCharset;
        this.dstCharset = dstCharset;
    }

    private OverthereFileTranscoder(OverthereFile source, Charset srcCharset, OverthereFile dest, Charset dstCharset) {
        super(source, dest);
        this.srcCharset = srcCharset;
        this.dstCharset = dstCharset;
    }

    public static void transcode(String contents, String srcCharsetName, OverthereFile dst) {
        Charset srcCharset = Charset.forName(srcCharsetName);
        Charset dstCharset = OverthereFileTranscoder.getConfiguredCharacterSet(dst.getConnection());
        ByteArrayFile baf = new ByteArrayFile("byte_array", contents.getBytes(srcCharset));
        OverthereFileTranscoder.transcode((OverthereFile)baf, srcCharset, dst, dstCharset);
    }

    public static void transcode(OverthereFile src, OverthereFile dst) {
        Charset srcCharset = OverthereFileTranscoder.getConfiguredCharacterSet(src.getConnection());
        Charset dstCharset = OverthereFileTranscoder.getConfiguredCharacterSet(dst.getConnection());
        OverthereFileTranscoder.transcode(src, srcCharset, dst, dstCharset);
    }

    private static Charset getConfiguredCharacterSet(OverthereConnection connection) {
        OperatingSystemFamily hostOperatingSystem = connection.getHostOperatingSystem();
        String charsetName = connection.getOptions().get("remoteCharacterEncoding", hostOperatingSystem.getDefaultCharacterSet());
        return Charset.forName(charsetName);
    }

    public static void transcode(OverthereFile src, String srcCharsetName, OverthereFile dst, String dstCharsetName) {
        Charset srcCharset = Charset.forName(srcCharsetName);
        Charset dstCharset = Charset.forName(dstCharsetName);
        OverthereFileTranscoder.transcode(src, srcCharset, dst, dstCharset);
    }

    public static void transcode(OverthereFile src, Charset srcCharset, OverthereFile dst, Charset dstCharset) {
        if (src.isDirectory()) {
            OverthereFileTranscoder.transcodeDirectory(src, srcCharset, dst, dstCharset);
        } else {
            new OverthereFileTranscoder(srcCharset, dstCharset).transmitFile(src, dst);
        }
    }

    private static void transcodeDirectory(OverthereFile srcDir, Charset srcCharset, OverthereFile dstDir, Charset dstCharset) throws RuntimeIOException {
        OverthereFileTranscoder dirCopier = new OverthereFileTranscoder(srcDir, srcCharset, dstDir, dstCharset);
        dirCopier.startTransmission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transmitFile(OverthereFile srcFile, OverthereFile dstFile) {
        this.checkFileExists(srcFile, SOURCE);
        this.checkReallyIsAFile(dstFile, DESTINATION);
        this.logger.debug("Transcoding file {} ({}) to {} ({})", new Object[]{srcFile, this.srcCharset, dstFile, this.dstCharset});
        if (dstFile.exists()) {
            this.logger.trace("About to overwrite existing file {}", (Object)dstFile);
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(srcFile.getInputStream(), this.srcCharset));
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(dstFile.getOutputStream(), this.dstCharset));
                try {
                    OverthereUtils.write(in, out);
                }
                finally {
                    OverthereUtils.closeQuietly(out);
                }
            }
            finally {
                OverthereUtils.closeQuietly(in);
            }
        }
        catch (RuntimeIOException exc) {
            throw new RuntimeIOException("Cannot transcode " + String.valueOf(srcFile) + " (" + String.valueOf(this.srcCharset) + ") to " + String.valueOf(dstFile) + " (" + String.valueOf(this.dstCharset) + ")", exc.getCause());
        }
    }
}

