/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.util;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.engine.util.StringUtil$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.model.XldUserCredentials;
import com.xebialabs.deployit.security.service.UserCredentialsService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class GitCredentialsUtils$ {
    public static final GitCredentialsUtils$ MODULE$ = new GitCredentialsUtils$();

    private GitUserCredentials getSourceCredentials(GitSource source, PasswordEncrypter passwordEncrypter) {
        return new GitUserCredentials(source.getName(), source.username(), null, StringUtil$.MODULE$.getDecryptedString(source.password(), passwordEncrypter), StringUtil$.MODULE$.getDecryptedString(source.privateKey(), passwordEncrypter), StringUtil$.MODULE$.getDecryptedString(source.passphrase(), passwordEncrypter));
    }

    public GitUserCredentials getUserOrSourceCredentials(GitSource source, UserCredentialsService userCredentialsService, PasswordEncrypter passwordEncrypter) {
        String username = Permissions.getAuthenticatedUserName();
        if (StringUtil$.MODULE$.isNotNil(username)) {
            return (GitUserCredentials)this.getUserCredentials(true, userCredentialsService, passwordEncrypter).getOrElse((Function0 & Serializable)() -> MODULE$.getSourceCredentials(source, passwordEncrypter));
        }
        return this.getSourceCredentials(source, passwordEncrypter);
    }

    public Option<GitUserCredentials> getUserCredentials(boolean checkNotFoundException, UserCredentialsService userCredentialsService, PasswordEncrypter passwordEncrypter) {
        String username = Permissions.getAuthenticatedUserName();
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> userCredentialsService.findDefaultCredentialsByProfileUsername(username));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            XldUserCredentials credentials = (XldUserCredentials)success.value();
            return new Some((Object)new GitUserCredentials(credentials.label(), credentials.username(), credentials.email(), (String)credentials.password().map((Function1 & Serializable)string -> StringUtil$.MODULE$.getDecryptedString((String)string, passwordEncrypter)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)credentials.privateKey().map((Function1 & Serializable)string -> StringUtil$.MODULE$.getDecryptedString((String)string, passwordEncrypter)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)credentials.passphrase().map((Function1 & Serializable)string -> StringUtil$.MODULE$.getDecryptedString((String)string, passwordEncrypter)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException && checkNotFoundException) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Throwable exception = failure.exception();
            throw exception;
        }
        throw new MatchError((Object)try_);
    }

    public boolean getUserCredentials$default$1() {
        return false;
    }

    public <A> A withCredentials(Function1<GitUserCredentials, A> func, UserCredentialsService userCredentialsService, PasswordEncrypter passwordEncrypter) {
        return (A)func.apply(this.getUserCredentials(this.getUserCredentials$default$1(), userCredentialsService, passwordEncrypter).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Problem retrieving user profile credentials - check your settings", new Object[0]);
        }));
    }

    private GitCredentialsUtils$() {
    }
}

