/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.database.search.ForeignKeyRelationshipEdge;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.util.QualifiedTableName;
import org.dbunit.util.SQLHelper;
import org.dbunit.util.search.AbstractNodesFilterSearchCallback;
import org.dbunit.util.search.IEdge;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaDataBasedSearchCallback
extends AbstractNodesFilterSearchCallback {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetaDataBasedSearchCallback.class);
    private final IDatabaseConnection connection;
    protected static final int IMPORT = 0;
    protected static final int EXPORT = 1;
    protected static final int[] TABLENAME_INDEXES = new int[]{3, 7};
    protected static final int[] SCHEMANAME_INDEXES = new int[]{2, 6};
    protected static final int[] PK_INDEXES = new int[]{4, 4};
    protected static final int[] FK_INDEXES = new int[]{8, 8};

    public AbstractMetaDataBasedSearchCallback(IDatabaseConnection connection) {
        this.connection = connection;
    }

    public IDatabaseConnection getConnection() {
        return this.connection;
    }

    protected SortedSet getNodesFromImportedKeys(Object node) throws SearchException {
        logger.debug("getNodesFromImportedKeys(node={}) - start", node);
        return this.getNodes(0, node);
    }

    protected SortedSet getNodesFromExportedKeys(Object node) throws SearchException {
        logger.debug("getNodesFromExportedKeys(node={}) - start", node);
        return this.getNodes(1, node);
    }

    protected SortedSet getNodesFromImportAndExportKeys(Object node) throws SearchException {
        logger.debug("getNodesFromImportAndExportKeys(node={}) - start", node);
        SortedSet importedNodes = this.getNodesFromImportedKeys(node);
        SortedSet exportedNodes = this.getNodesFromExportedKeys(node);
        importedNodes.addAll(exportedNodes);
        return importedNodes;
    }

    private SortedSet getNodes(int type, Object node) throws SearchException {
        if (logger.isDebugEnabled()) {
            logger.debug("getNodes(type={}, node={}) - start", (Object)Integer.toString(type), node);
        }
        try {
            Connection conn = this.connection.getConnection();
            String schema = this.connection.getSchema();
            DatabaseMetaData metaData = conn.getMetaData();
            TreeSet edges = new TreeSet();
            this.getNodes(type, node, conn, schema, metaData, edges);
            return edges;
        }
        catch (SQLException e) {
            throw new SearchException(e);
        }
        catch (NoSuchTableException e) {
            throw new SearchException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNodes(int type, Object node, Connection conn, String schema, DatabaseMetaData metaData, SortedSet edges) throws SearchException, NoSuchTableException {
        if (logger.isDebugEnabled()) {
            logger.debug("getNodes(type={}, node={}, conn={}, schema={}, metaData={}, edges={}) - start", new Object[]{String.valueOf(type), node, conn, schema, metaData, edges});
            logger.debug("Getting edges for node " + node);
        }
        if (!(node instanceof String)) {
            throw new IllegalArgumentException("node '" + node + "' should be a String, not a " + node.getClass().getName());
        }
        String tableName = (String)node;
        QualifiedTableName qualifiedTableName = new QualifiedTableName(tableName, schema);
        schema = qualifiedTableName.getSchema();
        tableName = qualifiedTableName.getTable();
        ResultSet rs = null;
        try {
            IMetadataHandler metadataHandler = (IMetadataHandler)this.connection.getConfig().getProperty("http://www.dbunit.org/properties/metadataHandler");
            if (!metadataHandler.tableExists(metaData, schema, tableName)) {
                throw new NoSuchTableException("The table '" + tableName + "' does not exist in schema '" + schema + "'");
            }
            switch (type) {
                case 0: {
                    rs = metaData.getImportedKeys(null, schema, tableName);
                    break;
                }
                case 1: {
                    rs = metaData.getExportedKeys(null, schema, tableName);
                    break;
                }
            }
            DatabaseConfig dbConfig = this.connection.getConfig();
            while (rs.next()) {
                int index = TABLENAME_INDEXES[type];
                int schemaindex = SCHEMANAME_INDEXES[type];
                String dependentTableName = rs.getString(index);
                String dependentSchemaName = rs.getString(schemaindex);
                String pkColumn = rs.getString(PK_INDEXES[type]);
                String fkColumn = rs.getString(FK_INDEXES[type]);
                tableName = new QualifiedTableName(tableName, schema).getQualifiedNameIfEnabled(dbConfig);
                dependentTableName = new QualifiedTableName(dependentTableName, dependentSchemaName).getQualifiedNameIfEnabled(dbConfig);
                IEdge edge = this.newEdge(rs, type, tableName, dependentTableName, fkColumn, pkColumn);
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding edge " + edge);
                }
                edges.add(edge);
            }
        }
        catch (SQLException e) {
            try {
                throw new SearchException(e);
            }
            catch (Throwable throwable) {
                try {
                    SQLHelper.close(rs);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw new SearchException(e2);
                }
            }
        }
        try {
            SQLHelper.close(rs);
            return;
        }
        catch (SQLException e) {
            throw new SearchException(e);
        }
    }

    protected static ForeignKeyRelationshipEdge createFKEdge(ResultSet rs, int type, String from, String to, String fkColumn, String pkColumn) throws SearchException {
        if (logger.isDebugEnabled()) {
            logger.debug("createFKEdge(rs={}, type={}, from={}, to={}, fkColumn={}, pkColumn={}) - start", new Object[]{rs, String.valueOf(type), from, to, fkColumn, pkColumn});
        }
        return type == 0 ? new ForeignKeyRelationshipEdge(from, to, fkColumn, pkColumn) : new ForeignKeyRelationshipEdge(to, from, fkColumn, pkColumn);
    }

    protected IEdge newEdge(ResultSet rs, int type, String from, String to, String fkColumn, String pkColumn) throws SearchException {
        if (logger.isDebugEnabled()) {
            logger.debug("newEdge(rs={}, type={}, from={}, to={}, fkColumn={}, pkColumn={}) - start", new Object[]{rs, String.valueOf(type), from, to, fkColumn, pkColumn});
        }
        return AbstractMetaDataBasedSearchCallback.createFKEdge(rs, type, from, to, fkColumn, pkColumn);
    }
}

