/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.core;

import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListItemParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInCharsHandler;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListBlockParser
extends AbstractBlockParser {
    private final ListBlock myBlock;
    private final ListOptions myOptions;
    private final ListData myListData;
    ListItemParser myLastChild = null;
    BasedSequence myItemHandledLine = null;
    boolean myItemHandledNewListLine;
    boolean myItemHandledNewItemLine;
    boolean myItemHandledSkipActiveLine;

    public ListBlockParser(ListOptions options, ListData listData, ListItemParser listItemParser) {
        this.myOptions = options;
        this.myListData = listData;
        this.myBlock = listData.listBlock;
        this.myBlock.setTight(true);
        this.myLastChild = listItemParser;
        this.myItemHandledNewListLine = false;
        this.myItemHandledNewItemLine = false;
        this.myItemHandledSkipActiveLine = false;
    }

    BasedSequence getItemHandledLine() {
        return this.myItemHandledLine;
    }

    void setItemHandledLine(BasedSequence itemHandledLine) {
        this.myItemHandledLine = itemHandledLine;
        this.myItemHandledNewListLine = false;
        this.myItemHandledNewItemLine = false;
        this.myItemHandledSkipActiveLine = false;
    }

    void setItemHandledNewListLine(BasedSequence itemHandledLine) {
        this.myItemHandledLine = itemHandledLine;
        this.myItemHandledNewListLine = true;
        this.myItemHandledNewItemLine = false;
        this.myItemHandledSkipActiveLine = false;
    }

    void setItemHandledNewItemLine(BasedSequence itemHandledLine) {
        this.myItemHandledLine = itemHandledLine;
        this.myItemHandledNewListLine = false;
        this.myItemHandledNewItemLine = true;
        this.myItemHandledSkipActiveLine = false;
    }

    void setItemHandledLineSkipActive(BasedSequence itemHandledLine) {
        this.myItemHandledLine = itemHandledLine;
        this.myItemHandledNewListLine = false;
        this.myItemHandledNewItemLine = false;
        this.myItemHandledSkipActiveLine = true;
    }

    public ListItemParser getLastChild() {
        return this.myLastChild;
    }

    public void setLastChild(ListItemParser lastChild) {
        this.myLastChild = lastChild;
    }

    public ListOptions getOptions() {
        return this.myOptions;
    }

    public ListData getListData() {
        return this.myListData;
    }

    int getContentIndent() {
        return this.myListData.markerIndent + this.myListData.listMarker.length() + this.myListData.contentOffset;
    }

    int getLastContentIndent() {
        return this.myLastChild.getContentIndent();
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return block instanceof ListItem;
    }

    @Override
    public ListBlock getBlock() {
        return this.myBlock;
    }

    private void setTight(boolean tight) {
        this.myBlock.setTight(tight);
    }

    @Override
    public void closeBlock(ParserState state) {
        this.finalizeListTight(state);
        if (((Boolean)Parser.BLANK_LINES_IN_AST.get((DataHolder)state.getProperties())).booleanValue()) {
            ListBlock block = this.getBlock();
            Node child = block.getFirstChildAnyNot(new Class[]{BlankLine.class});
            while (child instanceof ListItem) {
                child.moveTrailingBlankLines();
                child = child.getNextAnyNot(new Class[]{BlankLine.class});
            }
        }
        this.myBlock.setCharsFromContentOnly();
    }

    @Override
    public boolean breakOutOnDoubleBlankLine() {
        return this.myOptions.isEndOnDoubleBlank();
    }

    private static boolean hasNonItemChildren(ListItem item) {
        if (item.hasChildren()) {
            int count = 0;
            for (Node child : item.getChildren()) {
                if (child instanceof ListBlock || ++count < 2) continue;
                return true;
            }
        }
        return false;
    }

    private void finalizeListTight(ParserState parserState) {
        boolean isTight = true;
        boolean prevItemHadTrueTrailingBlankLine = false;
        boolean haveNestedList = false;
        for (Node item = this.getBlock().getFirstChild(); item != null; item = item.getNext()) {
            boolean thisItemHadBlankAfterItemPara = false;
            boolean thisItemContainsBlankLine = false;
            boolean thisItemHadTrailingBlankLine = false;
            boolean thisItemHadTrueTrailingBlankLine = false;
            boolean thisItemHadChildren = false;
            boolean thisItemLoose = false;
            if (item instanceof ListItem) {
                if (((ListItem)item).isHadBlankAfterItemParagraph() && (item.getNext() != null || item.getFirstChild() != null && item.getFirstChild().getNext() != null)) {
                    thisItemHadBlankAfterItemPara = true;
                }
                if (((ListItem)item).isContainsBlankLine()) {
                    thisItemContainsBlankLine = true;
                }
                if (parserState.endsWithBlankLine(item) && item.getNext() != null) {
                    thisItemHadTrueTrailingBlankLine = true;
                }
                if (ListBlockParser.hasNonItemChildren((ListItem)item)) {
                    thisItemHadChildren = true;
                }
                boolean bl = thisItemLoose = thisItemHadTrueTrailingBlankLine && this.myOptions.isLooseWhenHasTrailingBlankLine() || thisItemHadBlankAfterItemPara && this.myOptions.isLooseWhenBlankLineFollowsItemParagraph() || thisItemContainsBlankLine && this.myOptions.isLooseWhenContainsBlankLine() || thisItemHadChildren && this.myOptions.isLooseWhenHasNonListChildren() || (thisItemHadTrueTrailingBlankLine && item.getPrevious() == null || prevItemHadTrueTrailingBlankLine) && (this.myOptions.isLooseWhenPrevHasTrailingBlankLine() || this.myOptions.isLooseWhenLastItemPrevHasTrailingBlankLine() && item.getNext() == null);
                if (thisItemLoose) {
                    ((ListItem)item).setLoose(true);
                    isTight = false;
                }
            }
            for (Node subItem = item.getFirstChild(); subItem != null; subItem = subItem.getNext()) {
                if (parserState.endsWithBlankLine(subItem) && (item.getNext() != null || subItem.getNext() != null)) {
                    thisItemHadTrailingBlankLine = true;
                    if (subItem == item.getLastChild()) {
                        thisItemHadTrueTrailingBlankLine = true;
                    }
                    if (!thisItemLoose) {
                        if (this.myOptions.isLooseWhenHasTrailingBlankLine()) {
                            isTight = false;
                        }
                        if (thisItemHadTrueTrailingBlankLine && item.getPrevious() == null && this.myOptions.isLooseWhenPrevHasTrailingBlankLine()) {
                            isTight = false;
                            thisItemLoose = true;
                            ((ListItem)item).setLoose(true);
                        }
                    }
                }
                if (subItem instanceof ListBlock) {
                    haveNestedList = true;
                    if (!thisItemLoose && this.myOptions.isLooseWhenHasLooseSubItem()) {
                        ReversiblePeekingIterator iterator = subItem.getChildIterator();
                        while (iterator.hasNext()) {
                            ListItem item1 = (ListItem)iterator.next();
                            if (item1.isTight()) continue;
                            thisItemLoose = true;
                            isTight = false;
                            ((ListItem)item).setLoose(true);
                            break;
                        }
                    }
                }
                if (this.myOptions.isLooseWhenHasLooseSubItem() ? thisItemLoose && (haveNestedList || !this.myOptions.isAutoLooseOneLevelLists()) : !isTight && (haveNestedList || !this.myOptions.isAutoLooseOneLevelLists())) break;
            }
            if (!(item instanceof ListItem)) continue;
            prevItemHadTrueTrailingBlankLine = thisItemHadTrueTrailingBlankLine;
        }
        if (this.myOptions.isAutoLoose() && this.myOptions.isAutoLooseOneLevelLists()) {
            if (!haveNestedList && this.getBlock().getAncestorOfType(new Class[]{ListBlock.class}) == null && !isTight) {
                this.setTight(false);
            }
        } else if (this.myOptions.isAutoLoose() && !isTight) {
            this.setTight(false);
        }
    }

    static ListData parseListMarker(ListOptions options, int newItemCodeIndent, ParserState state) {
        Parsing parsing = state.getParsing();
        BasedSequence line = state.getLine();
        int markerIndex = state.getNextNonSpaceIndex();
        int markerColumn = state.getColumn() + state.getIndent();
        int markerIndent = state.getIndent();
        BasedSequence rest = line.subSequence(markerIndex, line.length());
        Matcher matcher = parsing.LIST_ITEM_MARKER.matcher((CharSequence)rest);
        if (!matcher.find()) {
            return null;
        }
        ListBlock listBlock = ListBlockParser.createListBlock(matcher);
        int markerLength = matcher.end() - matcher.start();
        boolean isNumberedList = !"+-*".contains(matcher.group());
        int indexAfterMarker = markerIndex + markerLength;
        int columnAfterMarker = markerColumn + markerLength;
        int contentOffset = 0;
        boolean hasContent = false;
        int contentIndex = indexAfterMarker;
        for (int i = indexAfterMarker; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                contentOffset += Parsing.columnsToNextTabStop(columnAfterMarker + contentOffset);
                ++contentIndex;
                continue;
            }
            if (c == ' ') {
                ++contentOffset;
                ++contentIndex;
                continue;
            }
            hasContent = true;
            break;
        }
        BasedSequence markerSuffix = BasedSequence.NULL;
        int markerSuffixOffset = contentOffset;
        if (!hasContent || contentOffset > newItemCodeIndent) {
            contentOffset = 1;
            markerSuffixOffset = 1;
        } else if (!isNumberedList || options.isNumberedItemMarkerSuffixed()) {
            String[] markerSuffixes;
            for (String suffix : markerSuffixes = options.getItemMarkerSuffixes()) {
                char c;
                int suffixLength = suffix.length();
                if (suffixLength <= 0 || !line.matchChars((CharSequence)suffix, contentIndex) || options.isItemMarkerSpace() && (c = line.midCharAt(contentIndex + suffixLength)) != ' ' && c != '\t') continue;
                markerSuffix = line.subSequence(contentIndex, contentIndex + suffixLength);
                columnAfterMarker += suffixLength;
                hasContent = false;
                int suffixContentOffset = contentOffset += suffixLength;
                for (int i = contentIndex += suffixLength; i < line.length(); ++i) {
                    char c2 = line.charAt(i);
                    if (c2 == '\t') {
                        contentOffset += Parsing.columnsToNextTabStop(columnAfterMarker + contentOffset);
                        continue;
                    }
                    if (c2 == ' ') {
                        ++contentOffset;
                        continue;
                    }
                    hasContent = true;
                    break;
                }
                if (hasContent && contentOffset - suffixContentOffset <= newItemCodeIndent) break;
                contentOffset = suffixContentOffset + 1;
                break;
            }
        }
        return new ListData(listBlock, !hasContent, markerIndex, markerColumn, markerIndent, contentOffset, rest.subSequence(matcher.start(), matcher.end()), isNumberedList, markerSuffix, markerSuffixOffset);
    }

    private static ListBlock createListBlock(Matcher matcher) {
        String bullet = matcher.group(1);
        if (bullet != null) {
            BulletList bulletList = new BulletList();
            bulletList.setOpeningMarker(bullet.charAt(0));
            return bulletList;
        }
        String digit = matcher.group(2);
        String delimiter = matcher.group(3);
        OrderedList orderedList = new OrderedList();
        orderedList.setStartNumber(Integer.parseInt(digit));
        orderedList.setDelimiter(delimiter.charAt(0));
        return orderedList;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.atIndex(state.getIndex());
    }

    static class ListData {
        final ListBlock listBlock;
        final boolean isEmpty;
        final int markerIndex;
        final int markerColumn;
        final int markerIndent;
        final int contentOffset;
        final BasedSequence listMarker;
        final boolean isNumberedList;
        final BasedSequence markerSuffix;
        final int markerSuffixOffset;

        ListData(ListBlock listBlock, boolean isEmpty, int markerIndex, int markerColumn, int markerIndent, int contentOffset, BasedSequence listMarker, boolean isNumberedList, BasedSequence markerSuffix, int markerSuffixOffset) {
            this.listBlock = listBlock;
            this.isEmpty = isEmpty;
            this.markerIndex = markerIndex;
            this.markerColumn = markerColumn;
            this.markerIndent = markerIndent;
            this.contentOffset = contentOffset;
            this.listMarker = listMarker;
            this.isNumberedList = isNumberedList;
            this.markerSuffix = markerSuffix;
            this.markerSuffixOffset = markerSuffixOffset;
        }
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final ListOptions myOptions;

        BlockFactory(DataHolder options) {
            super(options);
            this.myOptions = ListOptions.get(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int currentIndent;
            BlockParser matched = matchedBlockParser.getBlockParser();
            ParserEmulationProfile emulationFamily = this.myOptions.getParserEmulationProfile().family;
            int newItemCodeIndent = this.myOptions.getNewItemCodeIndent();
            if (matched instanceof ListBlockParser) {
                ListBlockParser listBlockParser = (ListBlockParser)matched;
                if (state.getLine() == listBlockParser.myItemHandledLine) {
                    if (listBlockParser.myItemHandledNewListLine) {
                        ListData listData = ListBlockParser.parseListMarker(this.myOptions, newItemCodeIndent, state);
                        ListItemParser listItemParser = new ListItemParser(this.myOptions, state.getParsing(), listData);
                        assert (listData != null);
                        int newColumn = listData.markerColumn + listData.listMarker.length() + listData.contentOffset;
                        listBlockParser = new ListBlockParser(this.myOptions, listData, listItemParser);
                        return BlockStart.of(listBlockParser, listItemParser).atColumn(newColumn);
                    }
                    if (listBlockParser.myItemHandledNewItemLine) {
                        ListData listData = ListBlockParser.parseListMarker(this.myOptions, newItemCodeIndent, state);
                        ListItemParser listItemParser = new ListItemParser(this.myOptions, state.getParsing(), listData);
                        assert (listData != null);
                        int newColumn = listData.markerColumn + listData.listMarker.length() + listData.contentOffset;
                        listBlockParser.myLastChild = listItemParser;
                        return BlockStart.of(listItemParser).atColumn(newColumn);
                    }
                    listBlockParser.myItemHandledLine = null;
                    return BlockStart.none();
                }
                return BlockStart.none();
            }
            ListBlock block = (ListBlock)matched.getBlock().getAncestorOfType(new Class[]{ListBlock.class});
            if (block != null) {
                ListBlockParser listBlockParser = (ListBlockParser)state.getActiveBlockParser(block);
                if (listBlockParser.myItemHandledLine == state.getLine() && listBlockParser.myItemHandledSkipActiveLine) {
                    listBlockParser.myItemHandledLine = null;
                    return BlockStart.none();
                }
            }
            if (emulationFamily == ParserEmulationProfile.COMMONMARK ? (currentIndent = state.getIndent()) >= this.myOptions.getCodeIndent() : (emulationFamily == ParserEmulationProfile.FIXED_INDENT ? (currentIndent = state.getIndent()) >= this.myOptions.getCodeIndent() : (emulationFamily == ParserEmulationProfile.KRAMDOWN ? (currentIndent = state.getIndent()) >= this.myOptions.getItemIndent() : emulationFamily == ParserEmulationProfile.MARKDOWN && (currentIndent = state.getIndent()) >= this.myOptions.getItemIndent()))) {
                return BlockStart.none();
            }
            ListData listData = ListBlockParser.parseListMarker(this.myOptions, newItemCodeIndent, state);
            if (listData != null) {
                boolean inParagraphListItem;
                int newColumn = listData.markerColumn + listData.listMarker.length() + listData.contentOffset;
                boolean inParagraph = matched.isParagraphParser();
                boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                if (inParagraph && !this.myOptions.canInterrupt(listData.listBlock, listData.isEmpty, inParagraphListItem)) {
                    return BlockStart.none();
                }
                ListItemParser listItemParser = new ListItemParser(this.myOptions, state.getParsing(), listData);
                ListBlockParser listBlockParser = new ListBlockParser(this.myOptions, listData, listItemParser);
                return BlockStart.of(listBlockParser, listItemParser).atColumn(newColumn);
            }
            return BlockStart.none();
        }
    }

    static class ListItemLeadInHandler
    extends SpecialLeadInCharsHandler {
        static final CharPredicate ORDERED_DELIM_DOT = CharPredicate.anyOf((char[])new char[]{'.'});
        static final CharPredicate ORDERED_DELIM_DOT_PARENS = CharPredicate.anyOf((CharSequence)".)");
        static final SpecialLeadInHandler ORDERED_DELIM_DOT_HANDLER = new ListItemLeadInHandler((CharSequence)Parser.LISTS_ITEM_PREFIX_CHARS.getDefaultValue(), true);
        static final SpecialLeadInHandler ORDERED_DELIM_DOT_PARENS_HANDLER = new ListItemLeadInHandler((CharSequence)Parser.LISTS_ITEM_PREFIX_CHARS.getDefaultValue(), false);
        final CharPredicate orderedDelims;

        @NotNull
        static SpecialLeadInHandler create(@NotNull CharSequence listItemDelims, boolean dotOnly) {
            return SequenceUtils.equals((CharSequence)((CharSequence)Parser.LISTS_ITEM_PREFIX_CHARS.getDefaultValue()), (Object)listItemDelims) ? (dotOnly ? ORDERED_DELIM_DOT_HANDLER : ORDERED_DELIM_DOT_PARENS_HANDLER) : new ListItemLeadInHandler(listItemDelims, dotOnly);
        }

        public ListItemLeadInHandler(CharSequence listItemDelims, boolean dotOnly) {
            super(CharPredicate.anyOf((CharSequence)listItemDelims));
            this.orderedDelims = dotOnly ? ORDERED_DELIM_DOT : ORDERED_DELIM_DOT_PARENS;
        }

        public boolean escape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
            int nonDigit;
            if (super.escape(sequence, options, consumer)) {
                return true;
            }
            if (((Boolean)SharedDataKeys.ESCAPE_NUMBERED_LEAD_IN.get(options)).booleanValue() && (nonDigit = sequence.indexOfAnyNot(CharPredicate.DECIMAL_DIGITS)) > 0 && nonDigit + 1 == sequence.length() && this.orderedDelims.test(sequence.charAt(nonDigit))) {
                consumer.accept((CharSequence)sequence.subSequence(0, nonDigit));
                consumer.accept("\\");
                consumer.accept((CharSequence)sequence.subSequence(nonDigit));
                return true;
            }
            return false;
        }

        public boolean unEscape(@NotNull BasedSequence sequence, @Nullable DataHolder options, @NotNull Consumer<CharSequence> consumer) {
            if (super.unEscape(sequence, options, consumer)) {
                return true;
            }
            int nonDigit = sequence.indexOfAnyNot(CharPredicate.DECIMAL_DIGITS);
            if (nonDigit > 0 && nonDigit + 2 == sequence.length() && sequence.charAt(nonDigit) == '\\' && this.orderedDelims.test(sequence.charAt(nonDigit + 1))) {
                consumer.accept((CharSequence)sequence.subSequence(0, nonDigit));
                consumer.accept((CharSequence)sequence.subSequence(nonDigit + 1));
                return true;
            }
            return false;
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return new HashSet(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class, FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class));
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            HashSet set = new HashSet();
            set.add(IndentedCodeBlockParser.Factory.class);
            return set;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }

        @Override
        @Nullable
        public SpecialLeadInHandler getLeadInHandler(@NotNull DataHolder options) {
            return ListItemLeadInHandler.create((CharSequence)Parser.LISTS_ITEM_PREFIX_CHARS.get(options), (Boolean)Parser.LISTS_ORDERED_ITEM_DOT_ONLY.get(options));
        }
    }
}

