/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion.comparer.value;

import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValueComparerBase
implements ValueComparer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String BASE_FAIL_MSG = "Actual value='%s' is %s expected value='%s'";

    @Override
    public String compare(ITable expectedTable, ITable actualTable, int rowNum, String columnName, DataType dataType, Object expectedValue, Object actualValue) throws DatabaseUnitException {
        String failMessage = this.doCompare(expectedTable, actualTable, rowNum, columnName, dataType, expectedValue, actualValue);
        this.log.debug("compare: rowNum={}, columnName={}, expectedValue={}, actualValue={}, failMessage={}", new Object[]{rowNum, columnName, expectedValue, actualValue, failMessage});
        return failMessage;
    }

    protected abstract String doCompare(ITable var1, ITable var2, int var3, String var4, DataType var5, Object var6, Object var7) throws DatabaseUnitException;

    public String toString() {
        return this.getClass().getName();
    }
}

