/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.plugin.manager.Plugin;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.PluginId$;
import com.xebialabs.plugin.manager.PluginId$PluginIdOps$;
import com.xebialabs.plugin.manager.PluginManager;
import com.xebialabs.plugin.manager.compatibility.Jdk17Compatibility$;
import com.xebialabs.plugin.manager.config.PluginManagerProperties;
import com.xebialabs.plugin.manager.event.PluginInstalledEvent;
import com.xebialabs.plugin.manager.event.PluginUpdatedEvent;
import com.xebialabs.plugin.manager.metadata.ArtifactId;
import com.xebialabs.plugin.manager.metadata.ExtendedMetadata;
import com.xebialabs.plugin.manager.metadata.PluginMetadata;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.repository.PluginsRepository;
import com.xebialabs.plugin.manager.repository.artifactory.ArtifactoryPluginRepository;
import com.xebialabs.plugin.manager.repository.config.PluginRepositoryConfig;
import com.xebialabs.plugin.manager.repository.config.PluginServerConfig;
import com.xebialabs.plugin.manager.repository.nexus.NexusPluginRepository;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.rest.dto.PluginDto;
import com.xebialabs.plugin.manager.rest.dto.PluginDto$;
import com.xebialabs.plugin.manager.service.DifferentVersionInstalledAlready;
import com.xebialabs.plugin.manager.service.InstallationFailure;
import com.xebialabs.plugin.manager.service.InstallationFailure$;
import com.xebialabs.plugin.manager.service.InstallationResult;
import com.xebialabs.plugin.manager.service.InstallationSuccess;
import com.xebialabs.plugin.manager.service.MultipleInstalledPluginsFoundForUpdate;
import com.xebialabs.plugin.manager.service.PluginNotFound;
import com.xebialabs.plugin.manager.service.PluginNotFoundException;
import com.xebialabs.plugin.manager.service.PluginService$;
import com.xebialabs.plugin.manager.service.PluginUninstallException;
import com.xebialabs.plugin.manager.service.ProductConfig;
import com.xebialabs.plugin.manager.service.RepositoryNotFound;
import com.xebialabs.plugin.manager.service.SameVersionInstalledAlready;
import com.xebialabs.plugin.manager.service.UpdateFailed;
import com.xebialabs.plugin.manager.service.UpdateStrategy$;
import com.xebialabs.plugin.manager.service.UpdateSuccess;
import com.xebialabs.plugin.manager.service.ZeroInstalledPluginsFoundForUpdate;
import com.xebialabs.plugin.manager.startup.PluginReloader;
import com.xebialabs.plugin.manager.validator.PluginValidator;
import com.xebialabs.plugin.manager.validator.TypeSystemValidationResults;
import com.xebialabs.plugin.manager.validator.TypeSystemValidator;
import com.xebialabs.plugin.manager.validator.ValidationResult;
import grizzled.slf4j.Logging;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005ba\u0002\u0016,!\u0003\r\tA\u000e\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u0006\u0015\u00021\ta\u0013\u0005\u0006%\u00021\ta\u0015\u0005\u00061\u00021\t!\u0017\u0005\u0006A\u00021\t!\u0019\u0005\tY\u0002A)\u0019!C\u0002[\")A\u000f\u0001D\u0001k\"9\u0011q\u0004\u0001\u0007\u0002\u0005\u0005\u0002bBA\u0016\u0001\u0019\u0005\u0011Q\u0006\u0005\b\u0003g\u0001a\u0011AA\u001b\u0011\u0019\t9\u0004\u0001C\u0001\r\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003s\u0001A\u0011AA3\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBA\u001c\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003G\u0004A\u0011AAs\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDqAa\u0003\u0001\t\u0003\u0011i\u0001C\u0004\u0003\u0012\u0001!\tAa\u0005\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!q\u0004\u0001\u0005\u0002\t\u0005\u0002b\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005'\u0002A\u0011\u0001B+\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005cBqA!!\u0001\t\u0003\u0011\u0019\tC\u0004\u0003\f\u0002!\tA!$\t\r\tU\u0005\u0001\"\u0001G\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005W;qA!-,\u0011\u0003\u0011\u0019L\u0002\u0004+W!\u0005!Q\u0017\u0005\b\u0005o\u001bC\u0011\u0001B]\u0011%\u0011Yl\tb\u0001\n\u0003\u0011i\f\u0003\u0005\u0003L\u000e\u0002\u000b\u0011\u0002B`\u0011\u001d\u0011im\tC\u0001\u0005\u001fDqAa<$\t\u0003\u0011\t\u0010C\u0004\u0004\u0010\r\"\ta!\u0005\u0003\u001bAcWoZ5o'\u0016\u0014h/[2f\u0015\taS&A\u0004tKJ4\u0018nY3\u000b\u00059z\u0013aB7b]\u0006<WM\u001d\u0006\u0003aE\na\u0001\u001d7vO&t'B\u0001\u001a4\u0003%AXMY5bY\u0006\u00147OC\u00015\u0003\r\u0019w.\\\u0002\u0001'\r\u0001q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015!B:mMRR'\"\u0001\"\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001R \u0003\u000f1{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012a\u0012\t\u0003q!K!!S\u001d\u0003\tUs\u0017\u000e^\u0001\u0014if\u0004XmU=ti\u0016lg+\u00197jI\u0006$xN]\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011q*L\u0001\nm\u0006d\u0017\u000eZ1u_JL!!\u0015(\u0003'QK\b/Z*zgR,WNV1mS\u0012\fGo\u001c:\u0002\u001bAdWoZ5o\u001b\u0006t\u0017mZ3s+\u0005!\u0006CA+W\u001b\u0005i\u0013BA,.\u00055\u0001F.^4j]6\u000bg.Y4fe\u0006q\u0001\u000f\\;hS:\u0014V\r\\8bI\u0016\u0014X#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uk\u0013aB:uCJ$X\u000f]\u0005\u0003?r\u0013a\u0002\u00157vO&t'+\u001a7pC\u0012,'/\u0001\bfm\u0016tG\u000fU;cY&\u001c\b.\u001a:\u0016\u0003\t\u0004\"a\u00196\u000e\u0003\u0011T!!\u001a4\u0002\u000f\r|g\u000e^3yi*\u0011q\r[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011.A\u0002pe\u001eL!a\u001b3\u00033\u0005\u0003\b\u000f\\5dCRLwN\\#wK:$\b+\u001e2mSNDWM]\u0001\u0003K\u000e,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cf\n!bY8oGV\u0014(/\u001a8u\u0013\t\u0019\bO\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006a!/\u001a9pg&$xN]5fgV\ta\u000fE\u0003xyz\f\u0019\"D\u0001y\u0015\tI(0A\u0004nkR\f'\r\\3\u000b\u0005mL\u0014AC2pY2,7\r^5p]&\u0011Q\u0010\u001f\u0002\u0004\u001b\u0006\u0004\bcA@\u0002\u000e9!\u0011\u0011AA\u0005!\r\t\u0019!O\u0007\u0003\u0003\u000bQ1!a\u00026\u0003\u0019a$o\\8u}%\u0019\u00111B\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0005\u0003\rM#(/\u001b8h\u0015\r\tY!\u000f\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u0017\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0002\u001e\u0005]!!\u0005)mk\u001eLgn\u001d*fa>\u001c\u0018\u000e^8ss\u0006i\u0011\r\u001a3SKB|7/\u001b;pef$B!a\t\u0002*A\u0019\u0001(!\n\n\u0007\u0005\u001d\u0012HA\u0004C_>dW-\u00198\t\u000f\u0005e\u0001\u00021\u0001\u0002\u0014\u0005\u0001B-\u001a7fi\u0016\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003G\ty\u0003\u0003\u0004\u00022%\u0001\rA`\u0001\u0005]\u0006lW-A\u000ftQ>,H\u000eZ\"iK\u000e\\'\nZ62o\r{W\u000e]1uS\nLG.\u001b;z+\t\t\u0019#\u0001\u0004va\u0012\fG/Z\u0001\u0007g\u0016\f'o\u00195\u0015\t\u0005u\u0012\u0011\f\t\b\u007f\u0006}\u0012\u0011IA'\u0013\ri\u0018\u0011\u0003\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI\u0017\u0002\u00115,G/\u00193bi\u0006LA!a\u0013\u0002F\tQ\u0011I\u001d;jM\u0006\u001cG/\u00133\u0011\u000ba\ny%a\u0015\n\u0007\u0005E\u0013H\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0007\n)&\u0003\u0003\u0002X\u0005\u0015#A\u0004)mk\u001eLg.T3uC\u0012\fG/\u0019\u0005\b\u00037b\u0001\u0019AA/\u0003\u0015\tX/\u001a:z!\u0011A\u0014q\n@\u0002\u001dM,\u0017M]2i\u001f\u001a4\u0017nY5bYR!\u0011QHA2\u0011\u0019\tY&\u0004a\u0001}R!\u0011QHA4\u0011\u0019\tYF\u0004a\u0001}\u0006!A.[:u)\t\ti$A\u0007mSN$\u0018J\\:uC2dW\r\u001a\u000b\u0003\u0003c\u0002b!a\u001d\u0002~\u0005\re\u0002BA;\u0003srA!a\u0001\u0002x%\t!(C\u0002\u0002|e\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0000\u0005\u0005%aA*fc*\u0019\u00111P\u001d\u0011\u0007U\u000b))C\u0002\u0002\b6\u0012\u0001\u0002\u00157vO&t\u0017\nZ\u0001\u0010S:\u001cH/\u00197m\u001fJ,\u0006\u000fZ1uKR\u0019q)!$\t\rA\n\u0002\u0019AAH!\r)\u0016\u0011S\u0005\u0004\u0003'k#A\u0002)mk\u001eLg.A\u0004j]N$\u0018\r\u001c7\u0015\r\u0005e\u0015\u0011UAS!\u0011\tY*!(\u000e\u0003-J1!a(,\u0005IIen\u001d;bY2\fG/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\u0005\r&\u00031\u0001\u0002\u0004\u0006A\u0001\u000f\\;hS:LE\rC\u0004\u0002(J\u0001\r!!+\u0002\u000b\tLH/Z:\u0011\u000ba\nY+a,\n\u0007\u00055\u0016HA\u0003BeJ\f\u0017\u0010E\u00029\u0003cK1!a-:\u0005\u0011\u0011\u0015\u0010^3\u0002\u001fY\fG.\u001b3bi\u0016Len\u001d;bY2$b!!/\u0002F\u0006\u001dG\u0003BAM\u0003wC\u0001\"!0\u0014\t\u0003\u0007\u0011qX\u0001\u0010gV\u001c7-Z:t\u0007\u0006dGNY1dWB)\u0001(!1\u0002\u001a&\u0019\u00111Y\u001d\u0003\u0011q\u0012\u0017P\\1nKzBq!a)\u0014\u0001\u0004\t\u0019\tC\u0004\u0002(N\u0001\r!!+\u0015\u0011\u0005e\u00151ZAh\u0003CDa!!4\u0015\u0001\u0004q\u0018AE3ySN$\u0018N\\4QYV<\u0017N\u001c(b[\u0016Dq!!5\u0015\u0001\u0004\t\u0019.\u0001\u0006oK^4VM]:j_:\u0004B!!6\u0002\\:\u0019Q+a6\n\u0007\u0005eW&\u0001\u0005QYV<\u0017N\\%e\u0013\u0011\ti.a8\u0003\u00131{7-\u00197GS2,'bAAm[!9\u0011q\u0015\u000bA\u0002\u0005%\u0016!H5ogR\fG\u000e\\(s+B$\u0017\r^3Ge>l'+\u001a9pg&$xN]=\u0015\t\u0005\u001d\u00181\u001f\t\u0006\u0003S\fyoR\u0007\u0003\u0003WT1!!<:\u0003\u0011)H/\u001b7\n\t\u0005E\u00181\u001e\u0002\u0004)JL\bbBA{+\u0001\u0007\u0011q_\u0001\u0003S\u0012\u0004B!!6\u0002z&!\u00111`Ap\u0005!\t%\u000f^5gC\u000e$\u0018A\u00073p/&$\b\u000eV=qKNK8\u000f^3n-\u0006d\u0017\u000eZ1uS>tG\u0003\u0002B\u0001\u0005\u0013!B!!'\u0003\u0004!A!Q\u0001\f\u0005\u0002\u0004\u00119!A\bqYV<\u0017N\\(qKJ\fG/[8o!\u0011A\u0014\u0011Y$\t\rA2\u0002\u0019AAH\u0003UIgn\u001d;bY24%o\\7SKB|7/\u001b;pef$B!!'\u0003\u0010!9\u0011Q_\fA\u0002\u0005]\u0018\u0001F;qI\u0006$XM\u0012:p[J+\u0007o\\:ji>\u0014\u0018\u0010\u0006\u0003\u0002\u001a\nU\u0001bBA{1\u0001\u0007\u0011q_\u0001\u0013O\u0016$\b\u000b\\;hS:\u001cHk\\+qI\u0006$X\r\u0006\u0003\u0002r\tm\u0001B\u0002B\u000f3\u0001\u0007a0\u0001\u0006qYV<\u0017N\u001c(b[\u0016\f\u0001dZ3u+B$\u0017\r^3NCR\u001c\u0007.\u001b8h!2,x-\u001b8t)\u0011\tiDa\t\t\u000f\u0005U(\u00041\u0001\u0002x\u0006IQO\\5ogR\fG\u000e\u001c\u000b\u000b\u0003O\u0014ICa\u0012\u0003L\t=\u0003b\u0002B\u00167\u0001\u0007!QF\u0001\re\u0016\u0004xn]5u_JL\u0018\n\u001a\t\u0005\u0005_\u0011yD\u0004\u0003\u00032\tmRB\u0001B\u001a\u0015\u0011\u0011)Da\u000e\u0002\u0007\u0005\u0004\u0018NC\u0002\u0003:5\nAA]3ti&!!Q\bB\u001a\u00031\u0001F.^4j]N{WO]2f\u0013\u0011\u0011\tEa\u0011\u0003\u000bY\u000bG.^3\n\u0007\t\u0015\u0013HA\u0006F]VlWM]1uS>t\u0007B\u0002B%7\u0001\u0007a0A\u0004he>,\b/\u00133\t\r\t53\u00041\u0001\u007f\u0003)\t'\u000f^5gC\u000e$\u0018\n\u001a\u0005\b\u0005#Z\u0002\u0019AA/\u0003\u001d1XM]:j_:\fqaZ3u\u0019><w\u000e\u0006\u0005\u0003X\t%$1\u000eB7!\u0015A\u0014q\nB-!\u0011\u0011YF!\u001a\u000e\u0005\tu#\u0002\u0002B0\u0005C\n!![8\u000b\u0005\t\r\u0014\u0001\u00026bm\u0006LAAa\u001a\u0003^\t!a)\u001b7f\u0011\u0019\u0011Y\u0003\ba\u0001}\"1!\u0011\n\u000fA\u0002yDaA!\u0014\u001d\u0001\u0004q\u0018AD1ui\u0006\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u0005\u0005g\u0012y\b\u0005\u0003\u0003v\tmTB\u0001B<\u0015\u0011\u0011IHa\u000e\u0002\u0007\u0011$x.\u0003\u0003\u0003~\t]$!\u0003)mk\u001eLg\u000e\u0012;p\u0011\u001d\t\u0019+\ba\u0001\u0003\u0007\u000bA\"\u0019;uC\u000eD7\u000b^1ukN,\"A!\"\u0011\u000fa\u00129Ia\u001d\u0003t%\u0019!\u0011R\u001d\u0003\u0013\u0019+hn\u0019;j_:\f\u0014AB3yi\u0016tG\r\u0006\u0003\u0003\u0010\nE\u0005CBA:\u0003{\u0012\u0019\bC\u0004\u0003\u0014~\u0001\r!!\u001d\u0002\t\u0011\fG/Y\u0001\tg\",H\u000fZ8x]\"\u001a\u0001E!'\u0011\t\tm%QU\u0007\u0003\u0005;SAAa(\u0003\"\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\t\r\u0016a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0005O\u0013iJ\u0001\u0006Qe\u0016$Um\u001d;s_f\f\u0011\u0004];cY&\u001c\b\u000e\u00157vO&tW*\u00198bO\u0016\u0014XI^3oiR\u0019qI!,\t\u000f\t=\u0016\u00051\u0001\u0002\u001a\u00061!/Z:vYR\fQ\u0002\u00157vO&t7+\u001a:wS\u000e,\u0007cAANGM\u00111eN\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\tM\u0016A\u00043fM\u0006,H\u000e\u001e+j[\u0016|W\u000f^\u000b\u0003\u0005\u007f\u0003BA!1\u0003H6\u0011!1\u0019\u0006\u0004\u0005\u000b\u0004\u0018\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\t%'1\u0019\u0002\t\tV\u0014\u0018\r^5p]\u0006yA-\u001a4bk2$H+[7f_V$\b%A\ttKJ4XM]:Ge>l7i\u001c8gS\u001e$BA!5\u0003bB1q0a\u0010\u007f\u0005'\u0004b!!;\u0002p\nU\u0007\u0003\u0002Bl\u0005;l!A!7\u000b\t\tm\u0017qC\u0001\u0007G>tg-[4\n\t\t}'\u0011\u001c\u0002\u0013!2,x-\u001b8TKJ4XM]\"p]\u001aLw\rC\u0004\u0003d\u001e\u0002\rA!:\u0002\u001bAdWoZ5og\u000e{gNZ5h!\u0011\u00119Oa;\u000e\u0005\t%(b\u0001Bn[%!!Q\u001eBu\u0005]\u0001F.^4j]6\u000bg.Y4feB\u0013x\u000e]3si&,7/\u0001\fsKB|7/\u001b;pe&,7O\u0012:p[\u000e{gNZ5h)\u0019\u0011\u0019p!\u0003\u0004\fQ!!Q\u001fB\u0000!\u0019y\u0018q\b@\u0003xB1\u0011\u0011^Ax\u0005s\u0004BAa6\u0003|&!!Q Bm\u0005Y\u0001F.^4j]J+\u0007o\\:ji>\u0014\u0018pQ8oM&<\u0007bBB\u0001Q\u0001\u000f11A\u0001\u000eaJ|G-^2u\u0007>tg-[4\u0011\t\u0005m5QA\u0005\u0004\u0007\u000fY#!\u0004)s_\u0012,8\r^\"p]\u001aLw\rC\u0004\u0003d\"\u0002\rA!:\t\u000f\r5\u0001\u00061\u0001\u0003R\u000691/\u001a:wKJ\u001c\u0018AF2p]\u001aLw-\u001e:fIJ+\u0007o\\:ji>\u0014\u0018.Z:\u0015\t\rM1q\u0004\u000b\u0005\u0007+\u0019i\u0002\u0005\u0004\u0002t\r]11D\u0005\u0005\u00073\t\tI\u0001\u0003MSN$\bCBAu\u0003_\f\u0019\u0002C\u0004\u0004\u0002%\u0002\u001daa\u0001\t\u000f\t\r\u0018\u00061\u0001\u0003f\u0002")
public interface PluginService
extends Logging {
    public static List<Try<PluginsRepository>> configuredRepositories(PluginManagerProperties pluginsConfig, ProductConfig productConfig) {
        return PluginService$.MODULE$.configuredRepositories(pluginsConfig, productConfig);
    }

    public static scala.collection.immutable.Map<String, Try<PluginRepositoryConfig>> repositoriesFromConfig(PluginManagerProperties pluginsConfig, scala.collection.immutable.Map<String, Try<PluginServerConfig>> servers, ProductConfig productConfig) {
        return PluginService$.MODULE$.repositoriesFromConfig(pluginsConfig, servers, productConfig);
    }

    public static scala.collection.immutable.Map<String, Try<PluginServerConfig>> serversFromConfig(PluginManagerProperties pluginsConfig) {
        return PluginService$.MODULE$.serversFromConfig(pluginsConfig);
    }

    public static Duration defaultTimeout() {
        return PluginService$.MODULE$.defaultTimeout();
    }

    public TypeSystemValidator typeSystemValidator();

    public PluginManager pluginManager();

    public PluginReloader pluginReloader();

    public ApplicationEventPublisher eventPublisher();

    public static /* synthetic */ ExecutionContext ec$(PluginService $this) {
        return $this.ec();
    }

    default public ExecutionContext ec() {
        return this.pluginManager().ec();
    }

    public Map<String, PluginsRepository> repositories();

    public boolean addRepository(PluginsRepository var1);

    public boolean deleteRepository(String var1);

    public boolean shouldCheckJdk17Compatibility();

    public static /* synthetic */ void update$(PluginService $this) {
        $this.update();
    }

    default public void update() {
        if (this.repositories().nonEmpty()) {
            Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((IterableOnce)this.repositories().values().map((Function1 & Serializable)x$1 -> x$1.update()), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()), PluginService$.MODULE$.defaultTimeout());
            return;
        }
    }

    public static /* synthetic */ scala.collection.immutable.Map search$(PluginService $this, Option query) {
        return $this.search((Option<String>)query);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> search(Option<String> query) {
        this.logger().debug((Function0 & Serializable)() -> "search(" + query + ")");
        return (scala.collection.immutable.Map)Await$.MODULE$.result((Awaitable)this.pluginManager().search(query).flatMap((Function1 & Serializable)installed -> Future$.MODULE$.sequence((IterableOnce)this.repositories().values().map((Function1 & Serializable)x$2 -> x$2.search(query)), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()).map((Function1 & Serializable)x$3 -> (Iterable)x$3.flatten(Predef$.MODULE$.$conforms()), this.ec()).map((Function1 & Serializable)available -> (scala.collection.immutable.Map)available.foldLeft((Object)((IterableOnceOps)installed.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)Option$.MODULE$.empty()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map acc = (scala.collection.immutable.Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    ArtifactId id = (ArtifactId)tuple22._1();
                    Option pm1 = (Option)tuple22._2();
                    Option option = acc.get((Object)id);
                    if (None$.MODULE$.equals(option)) {
                        return (scala.collection.immutable.Map)acc.updated((Object)id, (Object)pm1);
                    }
                    if (option instanceof Some) {
                        return (scala.collection.immutable.Map)pm1.map((Function1 & Serializable)pm -> (scala.collection.immutable.Map)acc.updated((Object)id, (Object)new Some(pm))).getOrElse((Function0 & Serializable)() -> acc);
                    }
                    throw new MatchError((Object)option);
                }
            }
            throw new MatchError((Object)tuple2);
        }), this.ec()), this.ec()), PluginService$.MODULE$.defaultTimeout());
    }

    public static /* synthetic */ scala.collection.immutable.Map searchOfficial$(PluginService $this, String query) {
        return $this.searchOfficial(query);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> searchOfficial(String query) {
        return (scala.collection.immutable.Map)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)this.repositories().values().map((Function1 & Serializable)x$5 -> x$5.search((Option<String>)new Some((Object)query))), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()).map((Function1 & Serializable)x$6 -> (Iterable)x$6.flatten(Predef$.MODULE$.$conforms()), this.ec()).map((Function1 & Serializable)available -> available.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.ec()), PluginService$.MODULE$.defaultTimeout());
    }

    public static /* synthetic */ scala.collection.immutable.Map search$(PluginService $this, String query) {
        return $this.search(query);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> search(String query) {
        return this.search((Option<String>)Option$.MODULE$.apply((Object)query).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7)))));
    }

    public static /* synthetic */ scala.collection.immutable.Map list$(PluginService $this) {
        return $this.list();
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> list() {
        return this.search((Option<String>)None$.MODULE$);
    }

    public static /* synthetic */ Seq listInstalled$(PluginService $this) {
        return $this.listInstalled();
    }

    default public Seq<PluginId> listInstalled() {
        return this.pluginManager().listInstalled();
    }

    public static /* synthetic */ void installOrUpdate$(PluginService $this, Plugin plugin) {
        $this.installOrUpdate(plugin);
    }

    default public void installOrUpdate(Plugin plugin) {
        this.logger().info((Function0 & Serializable)() -> "Installing plugin " + plugin.id().id() + "...");
        this.pluginManager().installOrUpdate(plugin);
        this.logger().info((Function0 & Serializable)() -> "Installation of plugin " + plugin.id().id() + " to the database is complete. System restart required for the plugin to be ready for usage.");
    }

    public static /* synthetic */ InstallationResult install$(PluginService $this, PluginId pluginId, byte[] bytes) {
        return $this.install(pluginId, bytes);
    }

    default public InstallationResult install(PluginId pluginId, byte[] bytes) {
        this.logger().info((Function0 & Serializable)() -> "Installing plugin " + pluginId + "...");
        if (this.shouldCheckJdk17Compatibility()) {
            boolean bl;
            boolean bl2 = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Jdk17Compatibility$.MODULE$.isCompatible(pluginId.name() + "." + pluginId.extension(), bytes));
            if (try_ instanceof Success) {
                bl2 = true;
                success = (Success)try_;
                boolean bl3 = BoxesRunTime.unboxToBoolean((Object)success.value());
                if (!bl3) {
                    this.logger().warn((Function0 & Serializable)() -> "Installation of plugin " + pluginId.name() + " failed due to JDK17 incompatibility.");
                    return new InstallationFailure(pluginId.name(), pluginId.name() + " is not JDK17 compatible.", InstallationFailure$.MODULE$.apply$default$3(), InstallationFailure$.MODULE$.apply$default$4());
                }
            }
            if (bl2 && (bl = BoxesRunTime.unboxToBoolean((Object)success.value()))) {
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    this.logger().warn((Function0 & Serializable)() -> "Installation of plugin " + pluginId.name() + " failed due to JDK17 incompatibility.");
                    return new InstallationFailure(pluginId.name(), "Unable to verify plugin " + pluginId.name() + " JDK17 compatibility. Error message " + ex.getMessage(), InstallationFailure$.MODULE$.apply$default$3(), InstallationFailure$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)try_);
            }
        }
        return this.validateInstall(pluginId, bytes, (Function0<InstallationResult>)(Function0 & Serializable)() -> {
            Plugin plugin = new Plugin(pluginId, (Option<ExtendedMetadata>)None$.MODULE$, bytes);
            InstallationResult result = this.doWithTypeSystemValidation(plugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().install(plugin));
            this.publishPluginManagerEvent(result);
            return result;
        });
    }

    private InstallationResult validateInstall(PluginId pluginId, byte[] bytes, Function0<InstallationResult> successCallback) {
        Seq<PluginId> installedPlugins = this.listInstalled();
        boolean sameVersionAlreadyInstalled = installedPlugins.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.equals(pluginId)));
        String pluginName = pluginId.name();
        boolean differentVersionAlreadyInstalled = installedPlugins.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$validateInstall$2(pluginName, x$9)));
        if (sameVersionAlreadyInstalled) {
            SameVersionInstalledAlready result = new SameVersionInstalledAlready(pluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        if (differentVersionAlreadyInstalled) {
            DifferentVersionInstalledAlready result = new DifferentVersionInstalledAlready(pluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        ValidationResult valid = new PluginValidator().validate(bytes, pluginId);
        if (valid.success()) {
            return (InstallationResult)successCallback.apply();
        }
        return valid;
    }

    public static /* synthetic */ InstallationResult update$(PluginService $this, String existingPluginName, PluginId.LocalFile newVersion, byte[] bytes) {
        return $this.update(existingPluginName, newVersion, bytes);
    }

    default public InstallationResult update(String existingPluginName, PluginId.LocalFile newVersion, byte[] bytes) {
        this.logger().info((Function0 & Serializable)() -> "Updating plugin " + existingPluginName + " to version " + newVersion + "...");
        Seq matchingPlugins = (Seq)this.listInstalled().filter((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$update$3(existingPluginName, plugin)));
        if (matchingPlugins.size() > 1) {
            MultipleInstalledPluginsFoundForUpdate result = new MultipleInstalledPluginsFoundForUpdate(existingPluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        if (matchingPlugins.isEmpty()) {
            ZeroInstalledPluginsFoundForUpdate result = new ZeroInstalledPluginsFoundForUpdate(existingPluginName);
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        }
        if (this.shouldCheckJdk17Compatibility()) {
            boolean bl;
            boolean bl2 = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Jdk17Compatibility$.MODULE$.isCompatible(existingPluginName, bytes));
            if (try_ instanceof Success) {
                bl2 = true;
                success = (Success)try_;
                boolean bl3 = BoxesRunTime.unboxToBoolean((Object)success.value());
                if (!bl3) {
                    this.logger().warn((Function0 & Serializable)() -> "Update of plugin " + existingPluginName + " failed due to JDK17 incompatibility.");
                    return new UpdateFailed(existingPluginName, existingPluginName + " is not JDK17 compatible.");
                }
            }
            if (bl2 && (bl = BoxesRunTime.unboxToBoolean((Object)success.value()))) {
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    this.logger().warn((Function0 & Serializable)() -> "Update of plugin " + existingPluginName + " failed due to JDK17 incompatibility.");
                    return new UpdateFailed(existingPluginName, "Unable to verify plugin " + existingPluginName + " JDK17 compatibility. Error message " + ex.getMessage());
                }
                throw new MatchError((Object)try_);
            }
        }
        PluginId.LocalFile alreadyInstalled = (PluginId.LocalFile)matchingPlugins.head();
        Plugin newPlugin = new Plugin(newVersion, (Option<ExtendedMetadata>)None$.MODULE$, bytes);
        InstallationResult result = this.doWithTypeSystemValidation(newPlugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().update(alreadyInstalled, newPlugin));
        this.publishPluginManagerEvent(result);
        return result;
    }

    public static /* synthetic */ Try installOrUpdateFromRepository$(PluginService $this, PluginId.Artifact id) {
        return $this.installOrUpdateFromRepository(id);
    }

    default public Try<BoxedUnit> installOrUpdateFromRepository(PluginId.Artifact id) {
        return (Try)this.repositories().get((Object)id.repository()).map((Function1 & Serializable)repo -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Plugin plugin = (Plugin)Await$.MODULE$.result(repo.get(id), PluginService$.MODULE$.defaultTimeout());
            InstallationResult installationResult = this.doWithTypeSystemValidation(plugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().install(plugin));
            this.publishPluginManagerEvent(installationResult);
            if (!installationResult.success()) {
                throw new IllegalStateException(installationResult.message());
            }
        }).recoverWith((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PluginService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().warn((Function0 & Serializable)() -> A1.getMessage());
                return (B1)new Failure(A1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.Throwable )}, serializedLambda);
            }
        })).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new NotFoundException("Unknown plugin repository '" + id.repository(), new Object[0])));
    }

    private InstallationResult doWithTypeSystemValidation(Plugin plugin, Function0<BoxedUnit> pluginOperation) {
        InstallationResult installationResult;
        TypeSystemValidationResults validations = this.typeSystemValidator().validate(plugin);
        validations.messages().foreach((Function1 & Serializable)info -> {
            PluginService.$anonfun$doWithTypeSystemValidation$1(this, info);
            return BoxedUnit.UNIT;
        });
        validations.warnings().foreach((Function1 & Serializable)warning -> {
            PluginService.$anonfun$doWithTypeSystemValidation$3(this, warning);
            return BoxedUnit.UNIT;
        });
        validations.errors().foreach((Function1 & Serializable)error -> {
            PluginService.$anonfun$doWithTypeSystemValidation$5(this, error);
            return BoxedUnit.UNIT;
        });
        if (validations.failed()) {
            return new InstallationFailure(plugin.id().name(), validations.messages().mkString("\n"), validations.warnings(), validations.errors());
        }
        Try try_ = Try$.MODULE$.apply(pluginOperation);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unable install/update " + plugin.id().name(), (Function0 & Serializable)() -> exception);
            installationResult = new InstallationFailure(plugin.id().name(), exception.getMessage(), validations.warnings(), validations.errors());
        } else if (try_ instanceof Success) {
            installationResult = new InstallationSuccess(plugin.id().name(), true, validations.warnings());
        } else {
            throw new MatchError((Object)try_);
        }
        InstallationResult result = installationResult;
        if (validations.restartRequired()) {
            return result;
        }
        this.pluginReloader().reloadPlugin(plugin);
        return new InstallationSuccess(plugin.id().name(), false, validations.warnings());
    }

    public static /* synthetic */ InstallationResult installFromRepository$(PluginService $this, PluginId.Artifact id) {
        return $this.installFromRepository(id);
    }

    /*
     * WARNING - void declaration
     */
    default public InstallationResult installFromRepository(PluginId.Artifact id) {
        InstallationResult installationResult;
        try {
            installationResult = (InstallationResult)this.repositories().get((Object)id.repository()).map((Function1 & Serializable)repo -> {
                Plugin plugin = (Plugin)Await$.MODULE$.result(repo.get(id), PluginService$.MODULE$.defaultTimeout());
                return this.validateInstall(plugin.id(), plugin.bytes(), (Function0<InstallationResult>)(Function0 & Serializable)() -> {
                    InstallationResult result = this.doWithTypeSystemValidation(plugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().install(plugin));
                    this.publishPluginManagerEvent(result);
                    return result;
                });
            }).getOrElse((Function0 & Serializable)() -> {
                RepositoryNotFound result = new RepositoryNotFound(id.repository(), id.name());
                this.logger().info((Function0 & Serializable)() -> result.message());
                return result;
            });
        }
        catch (Exception err) {
            void var3_3;
            this.logger().warn((Function0 & Serializable)() -> err.getMessage());
            PluginNotFound result = new PluginNotFound(id.name());
            this.logger().info((Function0 & Serializable)() -> result.message());
            installationResult = var3_3;
        }
        return installationResult;
    }

    public static /* synthetic */ InstallationResult updateFromRepository$(PluginService $this, PluginId.Artifact id) {
        return $this.updateFromRepository(id);
    }

    default public InstallationResult updateFromRepository(PluginId.Artifact id) {
        return (InstallationResult)this.repositories().get((Object)id.repository()).map((Function1 & Serializable)repo2 -> {
            Seq<PluginId> installedPlugins = this.getPluginsToUpdate(id.name());
            scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> availablePlugins = this.getUpdateMatchingPlugins(id);
            InstallationResult updateResult = UpdateStrategy$.MODULE$.doUpdate((PluginsRepository)repo2, installedPlugins, availablePlugins, id.name(), (Function3<PluginsRepository, PluginId.Artifact, PluginId, InstallationResult>)(Function3 & Serializable)(repo, newVersion, existing) -> this.doUpdate$1((PluginsRepository)repo, (PluginId.Artifact)newVersion, (PluginId)existing));
            this.logger().info((Function0 & Serializable)() -> updateResult.message());
            this.publishPluginManagerEvent(updateResult);
            return updateResult;
        }).getOrElse((Function0 & Serializable)() -> {
            RepositoryNotFound result = new RepositoryNotFound(id.repository(), id.name());
            this.logger().info((Function0 & Serializable)() -> result.message());
            return result;
        });
    }

    public static /* synthetic */ Seq getPluginsToUpdate$(PluginService $this, String pluginName) {
        return $this.getPluginsToUpdate(pluginName);
    }

    default public Seq<PluginId> getPluginsToUpdate(String pluginName) {
        String pluginNameCriteria = pluginName.endsWith("*") ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(pluginName), 1) : pluginName;
        return (Seq)this.listInstalled().filter((Function1 & Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$getPluginsToUpdate$1(pluginNameCriteria, plugin)));
    }

    public static /* synthetic */ scala.collection.immutable.Map getUpdateMatchingPlugins$(PluginService $this, PluginId.Artifact id) {
        return $this.getUpdateMatchingPlugins(id);
    }

    default public scala.collection.immutable.Map<ArtifactId, Option<PluginMetadata>> getUpdateMatchingPlugins(PluginId.Artifact id) {
        if (id.name().endsWith("*")) {
            return this.searchOfficial(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(id.name()), 1));
        }
        return (scala.collection.immutable.Map)this.searchOfficial(id.name()).filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)PluginService.$anonfun$getUpdateMatchingPlugins$1(id, item)));
    }

    public static /* synthetic */ Try uninstall$(PluginService $this, Enumeration.Value repositoryId, String groupId, String artifactId, Option version) {
        return $this.uninstall(repositoryId, groupId, artifactId, (Option<String>)version);
    }

    default public Try<BoxedUnit> uninstall(Enumeration.Value repositoryId, String groupId, String artifactId, Option<String> version) {
        this.logger().info((Function0 & Serializable)() -> "Uninstalling plugin " + repositoryId + ":" + groupId + ":" + artifactId + "-" + version);
        Option<DbPlugin> option = this.pluginManager().getPluginBy(repositoryId, groupId, artifactId, version);
        if (option instanceof Some) {
            Some some = (Some)option;
            DbPlugin plugin = (DbPlugin)some.value();
            if (this.pluginManager().uninstall(plugin)) {
                this.pluginManager().revertPreviousVersionIfNecessary(plugin);
                return new Success((Object)BoxedUnit.UNIT);
            }
            return new Failure((Throwable)((Object)new PluginUninstallException(plugin, "Only plugins in " + PluginStatus$.MODULE$.READY_FOR_INSTALL() + " status can be uninstalled.")));
        }
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)((Object)new PluginNotFoundException("Plugin " + repositoryId + ":" + groupId + ":" + artifactId + "-" + version + " not found in the system.")));
        }
        throw new MatchError(option);
    }

    public static /* synthetic */ Option getLogo$(PluginService $this, String repositoryId, String groupId, String artifactId) {
        return $this.getLogo(repositoryId, groupId, artifactId);
    }

    default public Option<File> getLogo(String repositoryId, String groupId, String artifactId) {
        return this.repositories().get((Object)repositoryId).flatMap((Function1 & Serializable)repo -> repo.getLogo(groupId, artifactId).map((Function1 & Serializable)logo -> logo));
    }

    public static /* synthetic */ PluginDto attachMetadata$(PluginService $this, PluginId pluginId) {
        return $this.attachMetadata(pluginId);
    }

    default public PluginDto attachMetadata(PluginId pluginId) {
        String repoId = pluginId.source().toString();
        Option metadata = this.repositories().get((Object)repoId).flatMap((Function1 & Serializable)repo -> repo.getMetadata(PluginId$PluginIdOps$.MODULE$.toArtifactId$extension(PluginId$.MODULE$.PluginIdOps(pluginId))).map((Function1 & Serializable)pluginsMeta -> pluginsMeta));
        return new PluginDto(pluginId, (Option<PluginMetadata>)metadata, PluginDto$.MODULE$.apply$default$3());
    }

    public static /* synthetic */ Function1 attachStatus$(PluginService $this) {
        return $this.attachStatus();
    }

    default public Function1<PluginDto, PluginDto> attachStatus() {
        scala.collection.immutable.Map<String, Enumeration.Value> statuses = this.pluginManager().fetchPluginStatuses();
        return (Function1 & Serializable)pluginDto -> {
            Option x$1 = statuses.get((Object)pluginDto.plugin().name());
            PluginId x$2 = pluginDto.copy$default$1();
            Option<PluginMetadata> x$3 = pluginDto.copy$default$2();
            return pluginDto.copy(x$2, x$3, (Option<Enumeration.Value>)x$1);
        };
    }

    public static /* synthetic */ Seq extend$(PluginService $this, Seq data) {
        return $this.extend((Seq<PluginId>)data);
    }

    default public Seq<PluginDto> extend(Seq<PluginId> data) {
        return (Seq)((IterableOps)data.map((Function1 & Serializable)pluginId -> this.attachMetadata((PluginId)pluginId))).map(this.attachStatus());
    }

    public static /* synthetic */ void shutdown$(PluginService $this) {
        $this.shutdown();
    }

    @PreDestroy
    default public void shutdown() {
        this.logger().info((Function0 & Serializable)() -> "Shutting down LocalPluginManager...");
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((IterableOnce)this.repositories().values().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends PluginsRepository, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NexusPluginRepository) {
                    NexusPluginRepository nexusPluginRepository = (NexusPluginRepository)A1;
                    return (B1)nexusPluginRepository.shutdown();
                }
                if (A1 instanceof ArtifactoryPluginRepository) {
                    ArtifactoryPluginRepository artifactoryPluginRepository = (ArtifactoryPluginRepository)A1;
                    return (B1)artifactoryPluginRepository.shutdown();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PluginsRepository x1) {
                PluginsRepository pluginsRepository = x1;
                if (pluginsRepository instanceof NexusPluginRepository) {
                    return true;
                }
                return pluginsRepository instanceof ArtifactoryPluginRepository;
            }
        }), BuildFrom$.MODULE$.buildFromIterableOps(), this.ec()), package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(this.repositories().size()), PluginService$.MODULE$.defaultTimeout()));
    }

    private void publishPluginManagerEvent(InstallationResult result) {
        InstallationResult installationResult = result;
        if (installationResult instanceof InstallationSuccess) {
            InstallationSuccess installationSuccess = (InstallationSuccess)installationResult;
            String pluginName = installationSuccess.pluginName();
            boolean requiresRestart = installationSuccess.requiresRestart();
            this.eventPublisher().publishEvent((ApplicationEvent)new PluginInstalledEvent(this, pluginName, requiresRestart));
            return;
        }
        if (installationResult instanceof UpdateSuccess) {
            UpdateSuccess updateSuccess = (UpdateSuccess)installationResult;
            String pluginName = updateSuccess.pluginName();
            boolean requiresRestart = updateSuccess.requiresRestart();
            this.eventPublisher().publishEvent((ApplicationEvent)new PluginUpdatedEvent(this, pluginName, requiresRestart));
            return;
        }
    }

    public static /* synthetic */ boolean $anonfun$validateInstall$2(String pluginName$1, PluginId x$9) {
        return x$9.name().equals(pluginName$1);
    }

    public static /* synthetic */ boolean $anonfun$update$3(String existingPluginName$1, PluginId plugin) {
        return PluginId$.MODULE$.PluginIdOps(plugin).name().startsWith(existingPluginName$1) && PluginId$.MODULE$.PluginIdOps(plugin) instanceof PluginId.LocalFile;
    }

    public static /* synthetic */ void $anonfun$doWithTypeSystemValidation$1(PluginService $this, String info) {
        $this.logger().info((Function0 & Serializable)() -> info);
    }

    public static /* synthetic */ void $anonfun$doWithTypeSystemValidation$3(PluginService $this, String warning) {
        $this.logger().warn((Function0 & Serializable)() -> warning);
    }

    public static /* synthetic */ void $anonfun$doWithTypeSystemValidation$5(PluginService $this, String error) {
        $this.logger().error((Function0 & Serializable)() -> error);
    }

    private InstallationResult doUpdate$1(PluginsRepository repo, PluginId.Artifact newVersion, PluginId existing) {
        Plugin newPlugin = (Plugin)Await$.MODULE$.result(repo.get(newVersion), PluginService$.MODULE$.defaultTimeout());
        return this.doWithTypeSystemValidation(newPlugin, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.pluginManager().update(existing, newPlugin));
    }

    public static /* synthetic */ boolean $anonfun$getPluginsToUpdate$1(String pluginNameCriteria$1, PluginId plugin) {
        return PluginId$.MODULE$.PluginIdOps(plugin).name().startsWith(pluginNameCriteria$1) && PluginId$.MODULE$.PluginIdOps(plugin) instanceof PluginId.Artifact;
    }

    public static /* synthetic */ boolean $anonfun$getUpdateMatchingPlugins$1(PluginId.Artifact id$5, Tuple2 item) {
        return ((String)((ArtifactId)item._1()).repository().get()).equals(id$5.repository()) && ((ArtifactId)item._1()).groupId().equals(id$5.groupId()) && ((ArtifactId)item._1()).artifactId().equals(id$5.artifactId());
    }

    public static void $init$(PluginService $this) {
    }
}

