/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractDiscriminatorMapping
implements EntityDiscriminatorMapping {
    private final NavigableRole role;
    private final BasicType<Object> underlyingJdbcMapping;
    private final DiscriminatorType<Object> discriminatorType;
    private final ManagedMappingType mappingType;

    public AbstractDiscriminatorMapping(ManagedMappingType mappingType, DiscriminatorType<Object> discriminatorType, BasicType<Object> underlyingJdbcMapping) {
        this.underlyingJdbcMapping = underlyingJdbcMapping;
        this.mappingType = mappingType;
        this.role = mappingType.getNavigableRole().append("{discriminator}");
        this.discriminatorType = discriminatorType;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.mappingType.asEntityMappingType();
    }

    @Override
    public BasicType<?> getUnderlyingJdbcMapping() {
        return this.discriminatorType.getUnderlyingJdbcMapping();
    }

    @Override
    public DiscriminatorConverter<?, ?> getValueConverter() {
        return this.discriminatorType.getValueConverter();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.role;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.discriminatorType;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.mappingType.findContainingEntityMapping();
    }

    @Override
    public MappingType getMappedType() {
        return this.getJdbcMapping();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getJdbcMapping().getJavaTypeDescriptor();
    }

    public DomainResult createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, this.underlyingJdbcMapping, tableGroup, null, creationState.getSqlAstCreationState());
        return new BasicResult<Object>(sqlSelection.getValuesArrayPosition(), resultVariable, this.discriminatorType.getJavaTypeDescriptor(), this.discriminatorType.getValueConverter(), navigablePath, false, !sqlSelection.isVirtual());
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, FetchParent fetchParent, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        return expressionResolver.resolveSqlSelection(this.resolveSqlExpression(navigablePath, jdbcMappingToUse, tableGroup, creationState), jdbcMappingToUse.getJdbcJavaType(), fetchParent, creationState.getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public BasicFetch<?> generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, this.underlyingJdbcMapping, tableGroup, fetchParent, creationState.getSqlAstCreationState());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, this.discriminatorType.getValueConverter(), fetchTiming, true, creationState, false, !sqlSelection.isVirtual());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, this.underlyingJdbcMapping, tableGroup, null, creationState.getSqlAstCreationState());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, this.underlyingJdbcMapping, tableGroup, null, creationState.getSqlAstCreationState()), this.getJdbcMapping());
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.underlyingJdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.underlyingJdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, this.disassemble(domainValue, session), this);
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }
}

